/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ActionDesc;
import SEdit.Formalism;
import SEdit.ReflectorUtil;
import SEdit.SElement;
import java.beans.IntrospectionException;
import java.util.Hashtable;
import madkit.kernel.Utils;

public abstract class ElementDesc {
    public static final int PROPERTIES = 1;
    public static final int GRAPHICPROPERTIES = 2;
    public static final int ACTIONPROPERTIES = 3;
    public static boolean debug = false;
    String name;
    Formalism formalism;
    String defaultLabel;
    String description;
    public String icon = "";
    public String elementClass;
    public String category;
    public String graphicClass;
    Hashtable properties;
    Hashtable graphicProperties;
    public Hashtable actions = new Hashtable();

    public Formalism getFormalism() {
        return this.formalism;
    }

    public void setFormalism(Formalism formalism) {
        this.formalism = formalism;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String string) {
        this.defaultLabel = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGraphicClass() {
        return this.graphicClass;
    }

    public void setGraphicClass(String string) {
        this.graphicClass = string;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public Hashtable getGraphicProperties() {
        return this.graphicProperties;
    }

    public void setGraphicProperties(Hashtable hashtable) {
        this.graphicProperties = hashtable;
    }

    public boolean isDefaultValue(String string, String string2, int n) {
        Hashtable hashtable = null;
        if (n == 1) {
            hashtable = this.getProperties();
        } else if (n == 2) {
            hashtable = this.getGraphicProperties();
        } else if (n == 3) {
            hashtable = this.getActions();
        }
        if (hashtable != null && hashtable.containsKey(string) && string2 != null && string2.equals(hashtable.get(string))) {
            return true;
        }
        return this.isStandardDefaultValue(string, string2, n);
    }

    public boolean isStandardDefaultValue(String string, String string2, int n) {
        return n == 2 && (string.equalsIgnoreCase("labellocation") && string2.equals("5") || string.equalsIgnoreCase("displayLabel") && string2.equalsIgnoreCase("true"));
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean hasIcon() {
        if (this.icon == null) {
            return false;
        }
        return !this.icon.equals("");
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getElementClass() {
        return this.elementClass;
    }

    public void setElementClass(String string) {
        this.elementClass = string;
    }

    public String toString() {
        return this.name + "," + this.description + "," + this.elementClass + "," + this.graphicClass + "," + this.icon + "," + this.actions;
    }

    public boolean hasActions() {
        return this.actions != null;
    }

    public void setActions(Hashtable hashtable) {
        this.actions = hashtable;
    }

    public Hashtable getActions() {
        return this.actions;
    }

    public ActionDesc getAction(String string) {
        return (ActionDesc)this.actions.get(string);
    }

    public void addActionDesc(ActionDesc actionDesc) {
        if (this.actions == null) {
            this.actions = new Hashtable();
        }
        this.actions.put(actionDesc.getDescription(), actionDesc);
    }

    public void addActionDesc(String string, String string2) {
        this.actions.put(string2, new ActionDesc(string, string2));
    }

    public ElementDesc() {
        this.addActionDesc("inspect", "Inspect");
        this.addActionDesc("delete", "Delete");
    }

    public ElementDesc(String string, String string2, String string3, String string4) {
        this();
        this.name = string;
        this.description = string2;
        this.elementClass = string3;
        this.icon = string4;
    }

    public SElement makeElement(Hashtable hashtable) {
        try {
            Class clazz = Utils.loadClass((String)this.elementClass);
            SElement sElement = (SElement)clazz.newInstance();
            sElement.setDescriptor(this);
            if (this.getProperties() != null) {
                ReflectorUtil.setProperties(sElement, this.getProperties());
            }
            if (hashtable != null) {
                ReflectorUtil.setProperties(sElement, hashtable);
            }
            return sElement;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found :" + this.elementClass + " " + classNotFoundException);
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Can't instanciate ! " + this.elementClass + " " + instantiationException);
            instantiationException.printStackTrace();
            return null;
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("Can't introspect ! " + this.elementClass + " " + introspectionException);
            introspectionException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("il a pas aime l'acces dis donc! " + this.elementClass + " " + illegalAccessException);
            illegalAccessException.printStackTrace();
            return null;
        }
    }
}

