/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.io.File;
import java.util.StringTokenizer;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ActMessage;
import madkit.system.PluginInformation;

public class PluginAgent
extends Agent {
    PluginInformation pluginfo;
    boolean alive = true;

    public void init(File file) {
        if (this.pluginfo == null) {
            this.pluginfo = new PluginInformation(file);
        }
        if (!this.pluginfo.updateInfo()) {
            System.err.println("Error when building the pluginAgent of " + file);
            this.alive = false;
        }
    }

    public String getPluginName() {
        return this.pluginfo.getName();
    }

    public void activate() {
        if (this.alive) {
            this.createGroup(false, "system", null, null);
            this.requestRole("system", "plugin", null);
        }
    }

    public void live() {
        if (!this.alive) {
            return;
        }
        AgentAddress agentAddress = this.getAgentWithRole("system", "designer");
        if (agentAddress != null) {
            this.sendMessage(agentAddress, (Message)new ActMessage("newPlugin", (Object)this.pluginfo));
        }
        while (this.alive) {
            Message message = this.waitNextMessage();
            if (message instanceof StringMessage) {
                this.handleStringMessage((StringMessage)message);
                continue;
            }
            if (!(message instanceof ActMessage)) continue;
            this.handleActMessage((ActMessage)message);
        }
    }

    void handleStringMessage(StringMessage stringMessage) {
        String string = stringMessage.getString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        if ("info".equalsIgnoreCase(string2)) {
            this.sendMessage(stringMessage.getSender(), (Message)new StringMessage(this.pluginfo.toString()));
        } else if ("getdoc".equalsIgnoreCase(string2) && this.pluginfo.getDocPath() != null) {
            String string3 = "displayLink\ufffdPlugins\ufffd" + this.pluginfo.getName() + "\ufffd" + this.pluginfo.getDocPath() + "\ufffd" + this.pluginfo.getName();
            this.sendMessage(stringMessage.getSender(), (Message)new StringMessage(string3));
        }
    }

    void handleActMessage(ActMessage actMessage) {
        String string = actMessage.getAction();
        if ("info".equalsIgnoreCase(string)) {
            this.sendMessage(actMessage.getSender(), (Message)new ActMessage("infos", (Object)this.pluginfo));
        }
    }
}

