/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.system.ChatMessage;
import madkit.system.MinimalChatPanel;
import madkit.utils.agents.AbstractEditorAgent;

public class MinimalChatAgent
extends AbstractEditorAgent {
    String chatter;

    public void setChatter(String string) {
        this.chatter = string;
    }

    public String getChatter() {
        return this.chatter;
    }

    public void initGUI() {
        this.display = new MinimalChatPanel(this);
        this.setGUIObject(this.display);
    }

    public void activate() {
        int n = this.createGroup(true, "minimalchat", null, null);
        int n2 = this.requestRole("minimalchat", "chatter", null);
    }

    public void handleMessage(Message message) {
        String string = null;
        if (message instanceof ChatMessage) {
            string = ((ChatMessage)message).getString();
            String string2 = ((ChatMessage)message).getChatter();
            if (string2 == null) {
                ((MinimalChatPanel)this.display).println(message.getSender() + "> " + string);
            } else {
                ((MinimalChatPanel)this.display).println(string2 + "> " + string);
            }
        } else if (message instanceof StringMessage) {
            string = ((StringMessage)message).getString();
            ((MinimalChatPanel)this.display).println("<< message from " + message.getSender() + ">> \n" + string);
        }
    }

    public void live() {
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void sendChatMessage(String string) {
        AgentAddress[] agentAddressArray = this.getAgentsWithRole("minimalchat", "chatter");
        for (int i = 0; i < agentAddressArray.length; ++i) {
            if (agentAddressArray[i].equals((Object)this.getAddress())) continue;
            this.sendMessage(agentAddressArray[i], new ChatMessage(this.chatter, string));
        }
    }
}

