/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JPanel;
import madkit.system.AgentSpy;
import madkit.system.GraphicGroupObserverGUIPane;

class GraphicHeader
extends JPanel {
    GraphicGroupObserverGUIPane parent;

    public GraphicHeader(GraphicGroupObserverGUIPane graphicGroupObserverGUIPane) {
        this.parent = graphicGroupObserverGUIPane;
        this.setBackground(Color.WHITE);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 0;
        for (AgentSpy agentSpy : this.parent.getListAgent()) {
            int n2 = n * this.parent.getAgentWidth();
            Rectangle rectangle = new Rectangle(n2 + this.parent.getMargeX(), this.parent.getMargeY(), this.parent.getAgentWidth() - 2 * this.parent.getMargeX(), this.parent.getHeaderHeight() - 2 * this.parent.getMargeY());
            graphics2D.draw(rectangle);
            ++n;
            int n3 = n2 + this.parent.getMargeX() + 3;
            int n4 = this.parent.getMargeY() + 3;
            int n5 = this.parent.getAgentWidth() - 6 - 2 * this.parent.getMargeX();
            int n6 = this.parent.getHeaderHeight() - 6 - 2 * this.parent.getMargeY();
            Rectangle rectangle2 = graphics2D.getClipBounds();
            graphics2D.clipRect(n3, n4, n5, n6);
            float f = n4;
            String string = agentSpy.getAgentAddress().getName();
            if (string.length() > 0) {
                AttributedString attributedString = new AttributedString(string, graphics2D.getFont().getAttributes());
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                int n7 = attributedCharacterIterator.getBeginIndex();
                int n8 = attributedCharacterIterator.getEndIndex();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                lineBreakMeasurer.setPosition(n7);
                try {
                    while (lineBreakMeasurer.getPosition() < n8) {
                        TextLayout textLayout = lineBreakMeasurer.nextLayout(n5);
                        float f2 = n3;
                        textLayout.draw(graphics2D, f2, f += (float)graphics2D.getFontMetrics(graphics2D.getFont()).getAscent());
                        f += (float)(graphics2D.getFontMetrics(graphics2D.getFont()).getDescent() + graphics2D.getFontMetrics(graphics2D.getFont()).getLeading());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rectangle2 != null) {
                graphics2D.setClip((int)rectangle2.getX(), (int)rectangle2.getY(), (int)rectangle2.getWidth(), (int)rectangle2.getHeight());
                continue;
            }
            graphics2D.setClip(null);
        }
    }

    public Dimension getPreferredSize() {
        int n = Math.max(this.parent.getListAgent().size(), 1) * this.parent.getAgentWidth();
        int n2 = this.parent.getHeaderHeight();
        return new Dimension(n, n2);
    }
}

