/*
 * Decompiled with CFR 0.152.
 */
package madkit.TreeTools;

import java.io.File;
import java.io.IOException;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import madkit.TreeTools.AbstractFileNode;
import madkit.TreeTools.DirNode;
import madkit.TreeTools.FileNode;
import madkit.TreeTools.GenericTree;
import madkit.TreeTools.GenericTreeNode;

public class LocalTree
extends GenericTree
implements TreeWillExpandListener {
    String rootPath;
    File rootFile;
    GenericTreeNode localRoot;
    String selection;
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    protected void buildDirectoryTree(AbstractFileNode abstractFileNode, File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    DirNode dirNode;
                    if (fileArray[i].list() == null) {
                        dirNode = new DirNode(fileArray[i], false);
                        abstractFileNode.add(dirNode);
                        continue;
                    }
                    if (fileArray[i].list().length == 0) {
                        dirNode = new DirNode(fileArray[i], true);
                        abstractFileNode.add(dirNode);
                        continue;
                    }
                    dirNode = new DirNode(fileArray[i], true);
                    abstractFileNode.add(dirNode);
                    this.buildFileTree(dirNode, fileArray[i]);
                    continue;
                }
                this.buildFileTree(abstractFileNode, fileArray[i]);
            }
        }
    }

    public void buildTree() {
        this.buildDirectoryTree((AbstractFileNode)this.localRoot, this.rootFile);
    }

    protected void buildFileTree(AbstractFileNode abstractFileNode, File file) {
        abstractFileNode.add(new FileNode(file));
    }

    public void addDirectory(File file) {
        this.localRoot = new DirNode(file, true);
        this.top.add(this.localRoot);
        this.buildDirectoryTree((AbstractFileNode)this.localRoot, file);
        this.treeModel.reload();
    }

    public LocalTree(File file) {
        super(new GenericTreeNode("top"));
        File file2 = file;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't get Canonical File");
        }
        File file3 = file2.getParentFile();
        this.rootPath = file3 == null ? (LocalTree.isWindowsPlatform() ? file2.getAbsolutePath() + File.separator : File.separator) : file3.getAbsolutePath() + File.separator;
        this.rootFile = file2;
        this.localRoot = new DirNode(file2, true);
        this.top.add(this.localRoot);
        this.buildTree();
        this.installTree();
    }

    public void installTree() {
        super.installTree();
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.addTreeWillExpandListener(this);
    }

    public String getPath(Object[] objectArray) {
        String string = "";
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            string = string + objectArray[i].toString();
            if (i == n - 1) continue;
            string = string + File.separator;
        }
        string = this.rootPath + string;
        return string;
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        AbstractFileNode abstractFileNode = (AbstractFileNode)treeExpansionEvent.getPath().getLastPathComponent();
        abstractFileNode.removeAllChildren();
        File file = new File(this.getPath(treeExpansionEvent.getPath().getPath()));
        this.buildDirectoryTree(abstractFileNode, file);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selection = this.getPath(treeSelectionEvent.getPath().getPath());
    }

    static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }
}

