/*
 * Decompiled with CFR 0.152.
 */
package marketorg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.messages.ACLMessage;

public class Provider
extends Agent {
    int prix = 0;
    String competence = Math.random() > 0.5 ? "train" : "plane";
    JLabel message;

    public Provider() {
        if (this.prix == 0) {
            this.prix = (int)(Math.random() * 500.0) + 100;
        }
        if (this.competence.equals("plane")) {
            this.prix *= 2;
        }
    }

    public void initGUI() {
        Serializable serializable;
        ImageIcon imageIcon = null;
        String string = "";
        string = this.competence.equals("plane") ? "/images/plane.jpg" : "/images/train.jpg";
        try {
            serializable = ((Object)((Object)this)).getClass().getResource(string);
            imageIcon = new ImageIcon((URL)serializable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        ((Container)serializable).add(new JLabel("Price: " + this.prix));
        if (imageIcon != null) {
            ((Container)serializable).add(new JLabel(imageIcon));
        }
        this.message = new JLabel("                             ");
        ((Container)serializable).add(this.message);
        this.message.setOpaque(true);
        ((Component)serializable).setSize(170, 100);
        this.message.setBackground(Color.lightGray);
        this.setGUIObject(serializable);
    }

    public void activate() {
        this.createGroup(true, "travel", "travel-providers", null, null);
        this.requestRole("travel", "travel-providers", this.competence + "-provider", null);
        this.display("Ticket: " + this.competence);
    }

    public void display(String string) {
        if (this.hasGUI()) {
            this.message.setText(string);
        } else {
            this.println(string);
        }
    }

    protected void handleMessage(ACLMessage aCLMessage) {
        Color color = null;
        if (this.hasGUI()) {
            color = this.message.getBackground();
        }
        if (aCLMessage.getAct().equalsIgnoreCase("REQUEST-FOR-BID")) {
            this.debug("s" + aCLMessage.getSender());
            this.debug("r" + aCLMessage.getReceiver());
            this.display("Sending bid");
            if (this.hasGUI()) {
                this.message.setBackground(Color.yellow);
            }
            this.sendMessage(aCLMessage.getSender(), (Message)new ACLMessage("BID", String.valueOf(this.prix)));
            this.display("Bid sent");
            if (this.hasGUI()) {
                this.pause(4000);
                this.message.setBackground(Color.lightGray);
            }
            this.display("Ticket: " + this.competence);
        } else if (aCLMessage.getAct().equalsIgnoreCase("MAKE-CONTRACT")) {
            String string = aCLMessage.getContent().toString();
            this.display("Received offer: " + string);
            if (this.hasGUI()) {
                this.message.setBackground(Color.green);
            }
            this.createGroup(true, "travel", string, null, null);
            this.requestRole("travel", string, "service", null);
        } else if (aCLMessage.getAct().equalsIgnoreCase("VALIDATE")) {
            this.display("Validating contract OK");
            if (this.hasGUI()) {
                this.message.setBackground(Color.magenta);
            }
            this.sendMessage(aCLMessage.getSender(), (Message)new ACLMessage("ACCEPT-CONTRACT"));
            if (this.hasGUI()) {
                this.pause(6000);
                this.message.setBackground(Color.lightGray);
            }
            this.display("Ticket: " + this.competence);
        }
    }

    public void live() {
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof ACLMessage)) {
                continue;
            }
            this.handleMessage((ACLMessage)message);
        }
    }
}

