/*
 * Decompiled with CFR 0.152.
 */
package madkit.messages;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.AgentAddress;
import madkit.messages.ActMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLMessage
extends ActMessage {
    public static final int ACCEPT_PROPOSAL = 0;
    public static final int AGREE = 1;
    public static final int CANCEL = 2;
    public static final int CFP = 3;
    public static final int CONFIRM = 4;
    public static final int DISCONFIRM = 5;
    public static final int FAILURE = 6;
    public static final int INFORM = 7;
    public static final int INFORM_IF = 8;
    public static final int INFORM_REF = 9;
    public static final int NOT_UNDERSTOOD = 10;
    public static final int PROPOSE = 11;
    public static final int QUERY_IF = 12;
    public static final int QUERY_REF = 13;
    public static final int REFUSE = 14;
    public static final int REJECT_PROPOSAL = 15;
    public static final int REQUEST = 16;
    public static final int REQUEST_WHEN = 17;
    public static final int REQUEST_WHENEVER = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PROXY = 20;
    public static final int PROPAGATE = 21;
    public static final int UNKNOWN = -1;
    public static final String ACCEPT_PROPOSAL_STRING = "ACCEPT-PROPOSAL";
    public static final String AGREE_STRING = "AGREE";
    public static final String CANCEL_STRING = "CANCEL";
    public static final String CFP_STRING = "CFP";
    public static final String CONFIRM_STRING = "CONFIRMP";
    public static final String DISCONFIRM_STRING = "DISCONFIRM";
    public static final String FAILURE_STRING = "FAILURE";
    public static final String INFORM_STRING = "INFORM";
    public static final String INFORM_IF_STRING = "INFORM-IF";
    public static final String INFORM_REF_STRING = "INFORM-REF";
    public static final String NOT_UNDERSTOOD_STRING = "NOT-UNDERSTOOD";
    public static final String PROPOSE_STRING = "PROPOSE";
    public static final String QUERY_IF_STRING = "QUERY-IF";
    public static final String QUERY_REF_STRING = "QUERY-REF";
    public static final String REFUSE_STRING = "REFUSE";
    public static final String REJECT_PROPOSAL_STRING = "REJECT-PROPOSAL";
    public static final String REQUEST_STRING = "REQUEST";
    public static final String REQUEST_WHEN_STRING = "REQUEST-WHEN";
    public static final String REQUEST_WHENEVER_STRING = "REQUEST-WHENEVER";
    public static final String SUBSCRIBE_STRING = "SUBSCRIBE";
    public static final String PROXY_STRING = "PROXY";
    public static final String PROPAGATE_STRING = "PROPAGATE";
    private static final String SENDER_KEY = ":sender";
    private static final String RECEIVER_KEY = ":receiver";
    private static final String CONTENT_KEY = ":content";
    private static final String REPLY_WITH_KEY = ":reply-with";
    private static final String IN_REPLY_TO_KEY = ":in-reply-to";
    private static final String REPLY_TO_KEY = ":reply-to";
    private static final String REPLY_BY_KEY = ":reply-by";
    private static final String LANGUAGE_KEY = ":language";
    private static final String ENCODING_KEY = ":encoding";
    private static final String ONTOLOGY_KEY = ":ontology";
    private static final String PROTOCOL_KEY = ":protocol";
    private static final String CONVERSATION_ID_KEY = ":conversation-id";
    private static final String ENVELOPE_KEY = ":envelope";
    public static List<String> performatives = new ArrayList<String>(22);
    private ArrayList<AgentAddress> dests = new ArrayList();
    private ArrayList<AgentAddress> reply_to = new ArrayList();

    public ACLMessage() {
        super(NOT_UNDERSTOOD_STRING);
    }

    public ACLMessage(String string) {
        super(string.toUpperCase());
    }

    public ACLMessage(String string, String string2) {
        super(string.toUpperCase(), string2);
    }

    public ACLMessage(int n, String string) {
        super(performatives.get(n), string);
    }

    public String getAct() {
        return this.action;
    }

    public String getPerformative() {
        return this.getAct();
    }

    public void setPerformative(String string) {
        this.action = string;
    }

    public void addReceiver(AgentAddress agentAddress) {
        if (agentAddress != null) {
            this.dests.add(agentAddress);
        }
    }

    public List<AgentAddress> getReceivers() {
        return this.dests;
    }

    public boolean removeReceiver(AgentAddress agentAddress) {
        if (agentAddress != null) {
            return this.dests.remove(agentAddress);
        }
        return false;
    }

    public void clearAllReceiver() {
        this.dests.clear();
    }

    public void addReplyTo(AgentAddress agentAddress) {
        if (agentAddress != null) {
            this.reply_to.add(agentAddress);
        }
    }

    public boolean removeReplyTo(AgentAddress agentAddress) {
        if (agentAddress != null) {
            return this.reply_to.remove(agentAddress);
        }
        return false;
    }

    public void clearAllReplyTo() {
        this.reply_to.clear();
    }

    public String getEnvelope() {
        return (String)this.getFieldValue(ENVELOPE_KEY);
    }

    public void setEnvelope(String string) {
        this.setField(ENVELOPE_KEY, string);
    }

    public String getConversationID() {
        return (String)this.getFieldValue(CONVERSATION_ID_KEY);
    }

    public void setConversationID(String string) {
        this.setField(CONVERSATION_ID_KEY, string);
    }

    public String getProtocol() {
        return (String)this.getFieldValue(PROTOCOL_KEY);
    }

    public void setProtocol(String string) {
        this.setField(PROTOCOL_KEY, string);
    }

    public String getReplyWith() {
        return (String)this.getFieldValue(REPLY_WITH_KEY);
    }

    public void setReplyWith(String string) {
        this.setField(REPLY_WITH_KEY, string);
    }

    public String getReplyBy() {
        return (String)this.getFieldValue(REPLY_BY_KEY);
    }

    public void setReplyBy(String string) {
        this.setField(REPLY_BY_KEY, string);
    }

    public void setReplyBy(Date date) {
        this.setField(REPLY_BY_KEY, date.toString());
    }

    @Override
    public String getInReplyTo() {
        return (String)this.getFieldValue(IN_REPLY_TO_KEY);
    }

    @Override
    public void setInReplyTo(String string) {
        this.setField(IN_REPLY_TO_KEY, string);
    }

    public String getLanguage() {
        return (String)this.getFieldValue(LANGUAGE_KEY);
    }

    public void setLanguage(String string) {
        this.setField(LANGUAGE_KEY, string);
    }

    public String getEncoding() {
        return (String)this.getFieldValue(ENCODING_KEY);
    }

    public void setEncoding(String string) {
        this.setField(ENCODING_KEY, string);
    }

    public String getOntology() {
        return (String)this.getFieldValue(ONTOLOGY_KEY);
    }

    public void setOntology(String string) {
        this.setField(ONTOLOGY_KEY, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + this.getAct() + " ");
        if (this.getSender() != null) {
            stringBuffer.append(":sender " + this.getSender());
        }
        if (this.getReceiver() != null) {
            stringBuffer.append(" :receiver " + this.getReceiver());
        }
        if (this.content != null && this.content.length() > 0) {
            stringBuffer.append(" :content " + this.content + "\n");
        }
        stringBuffer.append(")");
        return new String(stringBuffer);
    }

    public ACLMessage createReply() {
        ACLMessage aCLMessage = new ACLMessage();
        if (this.reply_to.isEmpty()) {
            aCLMessage.addReceiver(this.getSender());
        } else {
            Iterator<AgentAddress> iterator = this.reply_to.iterator();
            while (iterator.hasNext()) {
                aCLMessage.addReceiver(iterator.next());
            }
        }
        return aCLMessage;
    }

    public static void main(String[] stringArray) {
        ACLMessage aCLMessage = new ACLMessage("tell");
        aCLMessage.setLanguage("KIF");
        aCLMessage.setOntology("cook");
        aCLMessage.setProtocol("cuisine-net");
        aCLMessage.setEnvelope("PGP-env");
        aCLMessage.setConversationID("42");
        aCLMessage.setReplyWith("q2");
        aCLMessage.setReplyBy(new Date());
        aCLMessage.setInReplyTo("carottes-sont-cuites");
        System.out.println((Object)aCLMessage);
    }

    static {
        performatives.add(ACCEPT_PROPOSAL_STRING);
        performatives.add(AGREE_STRING);
        performatives.add(CANCEL_STRING);
        performatives.add(CFP_STRING);
        performatives.add("CONFIRM");
        performatives.add(DISCONFIRM_STRING);
        performatives.add(FAILURE_STRING);
        performatives.add(INFORM_STRING);
        performatives.add(INFORM_IF_STRING);
        performatives.add(INFORM_REF_STRING);
        performatives.add(NOT_UNDERSTOOD_STRING);
        performatives.add(PROPOSE_STRING);
        performatives.add(QUERY_IF_STRING);
        performatives.add(QUERY_REF_STRING);
        performatives.add(REFUSE_STRING);
        performatives.add(REJECT_PROPOSAL_STRING);
        performatives.add(REQUEST_STRING);
        performatives.add(REQUEST_WHEN_STRING);
        performatives.add(REQUEST_WHENEVER_STRING);
        performatives.add(SUBSCRIBE_STRING);
        performatives.add(PROXY_STRING);
        performatives.add(PROPAGATE_STRING);
    }
}

