/*
 * Decompiled with CFR 0.152.
 */
package madkit.jess;

import java.awt.event.ActionListener;
import java.io.Writer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jess.JessException;
import jess.Rete;
import madkit.jess.EditJessAgent;
import madkit.jess.JessController;
import madkit.jess.JessSetWatchDialog;
import madkit.kernel.AbstractAgent;
import madkit.utils.agents.AbstractEditorPanel;

class JessEditorPanel
extends AbstractEditorPanel {
    boolean[] watchItems = new boolean[]{false, false, false, false, true, true, false, false};
    protected JPanel commandPanel;

    JessEditorPanel(EditJessAgent editJessAgent, Rete rete) {
        super((AbstractAgent)editJessAgent);
        JMenuBar jMenuBar = this.getMenubar();
        JMenu jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Run", (String)"run", (int)74, (int)74);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Halt", (String)"halt", (int)84, (int)84);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Facts", (String)"facts", (int)70, (int)70);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Rules", (String)"rules", (int)82, (int)82);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Reset", (String)"reset", (int)68, (int)68);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Reset", (String)"reset", (int)68, (int)68);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Re-init", (String)"reinit", (int)89, (int)89);
        JessEditorPanel.addMenuItem((ActionListener)((Object)this), (JMenu)jMenu, (String)"Eval buffer", (String)"evalBuffer", (int)66, (int)66);
        JToolBar jToolBar = this.getToolbar();
        jToolBar.addSeparator();
        this.addTool(jToolBar, "run", "Run", "/images/toolbars/run.gif");
        this.addTool(jToolBar, "halt", "Halt", "/images/toolbars/halt.gif");
        this.addTool(jToolBar, "facts", "Facts", "/images/toolbars/facts.gif");
        this.addTool(jToolBar, "rules", "Rules", "/images/toolbars/rules.gif");
        this.addTool(jToolBar, "reset", "Reset", "/images/toolbars/reset.gif");
        this.addTool(jToolBar, "reinit", "Re-init", "/images/toolbars/reinit.gif");
        this.addTool(jToolBar, "watch", "Watch all", "/images/toolbars/watch.gif");
        jToolBar.addSeparator();
        this.addTool(jToolBar, "evalBuffer", "eval buffer", "/images/toolbars/sendbuf.gif");
        this.addTool(jToolBar, "evalSelection", "eval selection", "/images/toolbars/sendsel.gif");
        rete.addOutputRouter("t", (Writer)this.stdout());
        rete.addOutputRouter("WSTDOUT", (Writer)this.stdout());
        rete.addOutputRouter("WSTDERR", (Writer)this.stdout());
        this.setExtens("clp");
    }

    public void command(String string) {
        JessController jessController = (JessController)this.ag.getController();
        if (string.equals("evalBuffer")) {
            this.evalBuffer();
        } else if (string.equals("evalSelection")) {
            this.evalSelection();
        } else if (string.equals("run")) {
            jessController.doSendControlMessage("run");
        } else if (string.equals("reset")) {
            jessController.doSendControlMessage("reset");
        } else if (string.equals("halt")) {
            try {
                this.println("halting");
                jessController.getRete().halt();
            }
            catch (JessException jessException) {
                System.err.println("Error in halting Jess with agent: " + this.ag);
            }
        } else if (string.equals("facts")) {
            jessController.doSendControlMessage("facts");
        } else if (string.equals("rules")) {
            jessController.doSendControlMessage("rules");
        } else if (string.equals("reinit")) {
            jessController.doSendControlMessage("reinit");
        } else if (string.equals("watch")) {
            this.watchItems[4] = jessController.getWatchOutMessages();
            this.watchItems[5] = jessController.getWatchInMessages();
            this.watchItems[6] = jessController.getWatchRestartEngine();
            this.watchItems[7] = jessController.getWatchControlMessages();
            new JessSetWatchDialog(this, this.watchItems);
        } else {
            super.command(string);
        }
    }

    void setWatchItems(boolean[] blArray) {
        this.watchItems = blArray;
        JessController jessController = (JessController)this.ag.getController();
        jessController.doSendControlMessage("unwatch", "all");
        if (this.watchItems[0] && this.watchItems[1] & this.watchItems[2] && this.watchItems[3]) {
            jessController.doSendControlMessage("watch", "all");
        } else {
            if (this.watchItems[0]) {
                jessController.doSendControlMessage("watch", "facts");
            }
            if (this.watchItems[1]) {
                jessController.doSendControlMessage("watch", "rules");
            }
            if (this.watchItems[2]) {
                jessController.doSendControlMessage("watch", "activations");
            }
            if (this.watchItems[3]) {
                jessController.doSendControlMessage("watch", "compilations");
            }
        }
        if (this.watchItems[4] != jessController.getWatchOutMessages()) {
            jessController.doSendControlMessage("watchOutMessages");
        }
        if (this.watchItems[5] != jessController.getWatchInMessages()) {
            jessController.doSendControlMessage("watchInMessages");
        }
        if (this.watchItems[6] != jessController.getWatchRestartEngine()) {
            jessController.doSendControlMessage("watchRestartEngine");
        }
        if (this.watchItems[7] != jessController.getWatchRestartEngine()) {
            jessController.doSendControlMessage("watchControlMessages");
        }
    }

    void evalBuffer() {
        String string = this.inputArea.getText();
        JessController jessController = (JessController)this.ag.getController();
        jessController.doSendControlMessage("eval", string);
    }

    void evalSelection() {
        String string = this.inputArea.getSelectedText();
        JessController jessController = (JessController)this.ag.getController();
        jessController.doSendControlMessage("eval", string);
    }

    public void println(String string) {
        this.stdout().println(string);
    }
}

