/*
 * Decompiled with CFR 0.152.
 */
package madkit.jess;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import jess.Funcall;
import jess.Jesp;
import jess.JessException;
import jess.Rete;
import jess.Userfunction;
import jess.Userpackage;
import jess.Value;
import madkit.jess.BroadcastMessage;
import madkit.jess.CreateGroup;
import madkit.jess.GetAgentWithRole;
import madkit.jess.GetAgentsWithRole;
import madkit.jess.GetAvailableCommunities;
import madkit.jess.GetExistingGroups;
import madkit.jess.GetMyGroups;
import madkit.jess.GetRoles;
import madkit.jess.IsGroup;
import madkit.jess.IsRole;
import madkit.jess.LaunchAgent;
import madkit.jess.LeaveGroup;
import madkit.jess.LeaveRole;
import madkit.jess.Me;
import madkit.jess.MyController;
import madkit.jess.Pause;
import madkit.jess.ReadMessages;
import madkit.jess.RequestRole;
import madkit.jess.SendMessage;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Controller;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.kernel.Utils;
import madkit.messages.ControlMessage;
import madkit.utils.agents.LanguageController;

public class JessController
extends LanguageController
implements Controller {
    Jesp jesp;
    Rete rete;
    static final String JESS_LIBFILE = "plugins/jesslib/scripts/madkitlib.clp";
    public static final String DATE = "31/03/2002";
    public static final String VERSION = "1.1";
    Hashtable messageTypes = new Hashtable();
    boolean activation;

    public JessController(AbstractAgent abstractAgent) {
        this(abstractAgent, null);
    }

    public JessController(AbstractAgent abstractAgent, String string) {
        super(abstractAgent);
        this.rete = new Rete();
        this.setLibFile(System.getProperty("madkit.dir") + File.separator + JESS_LIBFILE);
        if (string != null) {
            String string2 = new File(string).getAbsolutePath();
            this.setBehaviorFile(string2);
        }
    }

    public Rete getRete() {
        return this.rete;
    }

    public String getMessageType(String string) {
        return (String)this.messageTypes.get(string);
    }

    public void setMessageType(String string, String string2) {
        this.messageTypes.put(string, string2);
    }

    public void setActivate(boolean bl) {
        if (!bl) {
            try {
                this.println("halting");
                this.rete.halt();
            }
            catch (JessException jessException) {
                System.err.println("Error in halting Jess with agent: " + this.thisAgent);
            }
        }
    }

    public boolean getActivate() {
        return true;
    }

    public void activate() {
        this.thisAgent.createGroup(true, "Jess", null, null);
        this.thisAgent.requestRole("Jess", "member", null);
        this.println("Jess, the Java Expert System Shell");
        this.println("Copyright (C) 1998 E.J. Friedman-Hill and the Sandia Corporation");
        this.println("JessAgentLib, integration of Jess into Madkit");
        this.println("Version 1.1 - 31/03/2002 - Copyright (C) 2000-2008 MadKit team");
        this.execute();
        this.thisAgent.activate();
    }

    public void println(String string) {
        this.thisAgent.println(string);
    }

    private void execute() {
        String[] stringArray = new String[]{"jess.StringFunctions", "jess.PredFunctions", "jess.MultiFunctions", "jess.MiscFunctions", "jess.MathFunctions", "jess.BagFunctions", "jess.reflect.ReflectFunctions", "jess.view.ViewFunctions"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.rete.addUserpackage((Userpackage)Utils.loadClass((String)stringArray[i]).newInstance());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.rete.executeCommand("(printout t (jess-version-string) crlf)");
            this.rete.addUserfunction((Userfunction)new CreateGroup(this));
            this.rete.addUserfunction((Userfunction)new RequestRole(this));
            this.rete.addUserfunction((Userfunction)new LeaveRole(this));
            this.rete.addUserfunction((Userfunction)new LeaveGroup(this));
            this.rete.addUserfunction((Userfunction)new GetAgentsWithRole(this));
            this.rete.addUserfunction((Userfunction)new GetAgentWithRole(this));
            this.rete.addUserfunction((Userfunction)new GetRoles(this));
            this.rete.addUserfunction((Userfunction)new GetMyGroups(this));
            this.rete.addUserfunction((Userfunction)new GetExistingGroups(this));
            this.rete.addUserfunction((Userfunction)new GetAvailableCommunities(this));
            this.rete.addUserfunction((Userfunction)new IsGroup(this));
            this.rete.addUserfunction((Userfunction)new IsRole(this));
            this.rete.addUserfunction((Userfunction)new SendMessage(this));
            this.rete.addUserfunction((Userfunction)new BroadcastMessage(this));
            this.rete.addUserfunction((Userfunction)new LaunchAgent(this));
            this.rete.addUserfunction((Userfunction)new Me(this));
            this.rete.addUserfunction((Userfunction)new MyController(this));
            this.rete.addUserfunction((Userfunction)new ReadMessages(this));
            this.rete.addUserfunction((Userfunction)new Pause(this));
            this.loadFile(this.getLibFile());
            this.loadFile(this.getBehaviorFile());
        }
        catch (JessException jessException) {
            this.println("ERROR DURING SETUP: " + jessException.toString());
        }
    }

    public synchronized void halt() {
        try {
            this.rete.halt();
            this.println(":: Jess engine halted");
        }
        catch (JessException jessException) {
            this.println("Jess error while halting ");
        }
    }

    protected void handleControlMessage(ControlMessage controlMessage) {
        String string = controlMessage.getAction();
        Value value = Funcall.TRUE;
        if (this.getWatchControlMessages()) {
            this.println("<< ControlMessage: " + string);
        }
        try {
            if (string.equals("halt")) {
                this.rete.halt();
                this.println(":: Jess engine halted");
            } else if (string.equals("run")) {
                value = this.rete.executeCommand("(run)");
            } else if (string.equals("reset")) {
                value = this.rete.executeCommand("(reset)");
            } else if (string.equals("facts")) {
                value = this.rete.executeCommand("(facts)");
            } else if (string.equals("rules")) {
                value = this.rete.executeCommand("(rules)");
            } else if (string.equals("watch")) {
                value = this.rete.executeCommand("(watch " + controlMessage.getContent() + ")");
            } else if (string.equals("unwatch")) {
                value = this.rete.executeCommand("(unwatch " + controlMessage.getContent() + ")");
            } else if (string.equals("eval")) {
                value = this.rete.executeCommand(controlMessage.getContent());
            } else if (string.equals("watchOutMessages")) {
                this.toggleWatchOutMessages();
            } else if (string.equals("watchInMessages")) {
                this.toggleWatchInMessages();
            } else if (string.equals("watchRestartEngine")) {
                this.toggleWatchRestartEngine();
            } else if (string.equals("watchControlMessages")) {
                this.toggleWatchControlMessages();
            } else if (string.equals("clear")) {
                value = this.rete.executeCommand("(clear)");
            } else if (string.equals("reinit")) {
                value = this.rete.executeCommand("(clear)");
                this.loadFile(this.getLibFile());
                this.loadFile(this.getBehaviorFile());
            } else if (string.equals("load")) {
                this.loadFile(controlMessage.getContent());
            } else {
                this.println("** Error: command unknown " + string);
                return;
            }
            this.println("> " + value.toString());
        }
        catch (JessException jessException) {
            this.println("Jess error doing " + string);
            jessException.printStackTrace(System.err);
        }
    }

    protected boolean handleMyMessages(Message message) {
        Object var2_2 = null;
        if (message instanceof ControlMessage) {
            this.handleControlMessage((ControlMessage)message);
            return false;
        }
        try {
            boolean bl = false;
            if (!this.rete.listActivations().hasNext()) {
                bl = true;
            }
            this.rete.store("MESSAGE", (Object)message);
            if (this.getWatchInMessages()) {
                this.println("<< receiving message of type : " + message.getClass().getName());
            }
            this.rete.executeCommand("(definstance " + this.getMessageType(message.getClass().getName()) + "(fetch MESSAGE) static)");
            return true;
        }
        catch (JessException jessException) {
            this.println("ERROR ON MESSAGE RECEPTION: " + jessException.toString());
            return false;
        }
    }

    public void live() {
        Agent agent = (Agent)this.thisAgent;
        while (true) {
            Message message;
            if (!this.handleMyMessages(message = agent.waitNextMessage())) {
                continue;
            }
            try {
                if (this.getWatchRestartEngine()) {
                    this.println(":: restart engine");
                }
                this.rete.run();
                continue;
            }
            catch (JessException jessException) {
                this.println("Run error???");
                jessException.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public void doIt() {
        boolean bl = false;
        Message message = null;
        while ((message = this.thisAgent.nextMessage()) != null) {
            bl = this.handleMyMessages(message);
        }
        if (bl) {
            try {
                this.println(":: restart engine");
                this.rete.run();
            }
            catch (JessException jessException) {
                this.println("Run error??? see the output to get the stack trace");
                jessException.printStackTrace(System.err);
            }
        }
    }

    public void readMessages() {
        while (!this.thisAgent.isMessageBoxEmpty()) {
            this.handleMyMessages(this.thisAgent.nextMessage());
        }
    }

    public void doPause(int n) {
        if (this.thisAgent instanceof Agent) {
            ((Agent)this.thisAgent).pause(n);
        }
    }

    public int doRequestRole(String string, String string2) {
        return this.thisAgent.requestRole(string, string2, null);
    }

    public int doRequestRole(String string, String string2, String string3) {
        return this.thisAgent.requestRole(string, string2, string3, null);
    }

    public void doLeaveRole(String string, String string2) {
        this.thisAgent.leaveRole(string, string2);
    }

    public void doLeaveRole(String string, String string2, String string3) {
        this.thisAgent.leaveRole(string, string2, string3);
    }

    public void doLeaveGroup(String string) {
        this.thisAgent.leaveGroup(string);
    }

    public void doLeaveGroup(String string, String string2) {
        this.thisAgent.leaveGroup(string, string2);
    }

    public AgentAddress[] doGetAgentsWithRole(String string, String string2) {
        AgentAddress[] agentAddressArray = this.thisAgent.getAgentsWithRole(string, string2);
        return agentAddressArray;
    }

    public AgentAddress[] doGetAgentsWithRole(String string, String string2, String string3) {
        AgentAddress[] agentAddressArray = this.thisAgent.getAgentsWithRole(string, string2, string3);
        return agentAddressArray;
    }

    public AgentAddress doGetAgentWithRole(String string, String string2) {
        return this.thisAgent.getAgentWithRole(string, string2);
    }

    public AgentAddress doGetAgentWithRole(String string, String string2, String string3) {
        return this.thisAgent.getAgentWithRole(string, string2, string3);
    }

    public String doGetName() {
        return this.thisAgent.getName();
    }

    public String[] doGetRoles(String string) {
        return this.thisAgent.getExistingRoles(string);
    }

    public String[] doGetMyGroups() {
        return this.thisAgent.getMyGroups();
    }

    public String[] doGetMyGroups(String string) {
        return this.thisAgent.getMyGroups(string);
    }

    public String[] doGetExistingGroups() {
        return this.thisAgent.getExistingGroups();
    }

    public String[] doGetExistingGroups(String string) {
        return this.thisAgent.getExistingGroups(string);
    }

    public String[] doGetAvailableCommunities() {
        return this.thisAgent.getAvailableCommunities();
    }

    public boolean doIsGroup(String string) {
        return this.thisAgent.isGroup(string);
    }

    public boolean doIsGroup(String string, String string2) {
        return this.thisAgent.isGroup(string, string2);
    }

    public boolean doIsRole(String string, String string2) {
        return this.thisAgent.isRole(string, string2);
    }

    public boolean doIsRole(String string, String string2, String string3) {
        return this.thisAgent.isRole(string, string2, string3);
    }

    public int doCreateGroup(boolean bl, String string) {
        return this.thisAgent.createGroup(bl, string, null, null);
    }

    public int doCreateGroup(boolean bl, String string, String string2) {
        return this.thisAgent.createGroup(bl, string, string2, null, null);
    }

    public void doLaunchAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        this.thisAgent.launchAgent(abstractAgent, string, bl);
    }

    public void doSendStringMessage(AgentAddress agentAddress, String string) {
        if (this.getWatchOutMessages()) {
            this.println(">> sending string message : " + string + " to " + agentAddress);
        }
        this.thisAgent.sendMessage(agentAddress, (Message)new StringMessage(string));
    }

    public void doSendMessage(AgentAddress agentAddress, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> sending message : " + message + " to " + agentAddress);
        }
        this.thisAgent.sendMessage(agentAddress, message);
    }

    public void doSendControlMessage(String string) {
        this.thisAgent.sendMessage(this.thisAgent.getAddress(), (Message)new ControlMessage(string));
    }

    public void doSendControlMessage(String string, String string2) {
        this.thisAgent.sendMessage(this.thisAgent.getAddress(), (Message)new ControlMessage(string, string2));
    }

    public void doSendMessage(String string, String string2, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> sending messages : " + message + " to role " + string2 + " of " + string);
        }
        this.thisAgent.sendMessage(string, string2, message);
    }

    public void doBroadcastMessage(String string, String string2, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> broadcast messages : " + message + " to role " + string2 + " of " + string);
        }
        this.thisAgent.broadcastMessage(string, string2, message);
    }

    public void doBroadcastMessage(String string, String string2, String string3, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> broadcast messages : " + message + " to role " + string3 + " of " + string2 + " from community " + string);
        }
        this.thisAgent.broadcastMessage(string, string2, string3, message);
    }

    public void loadFile(String string) {
        if (string != null) {
            try {
                FileReader fileReader = new FileReader(string);
                Jesp jesp = new Jesp((Reader)fileReader, this.rete);
                try {
                    jesp.parse(false);
                }
                catch (JessException jessException) {
                    jessException.printStackTrace(System.err);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.println("Error opening file " + string);
            }
            catch (IOException iOException) {
                this.println("Error reading file " + string);
            }
        }
    }
}

