/*
 * Decompiled with CFR 0.152.
 */
package madkit.jess;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JToolBar;
import madkit.jess.JessAgent;
import madkit.jess.JessAgentSetWatchDialog;
import madkit.jess.JessController;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.OPanel;
import madkit.system.EditorAgent;
import madkit.utils.graphics.DefaultControlPanel;

class JessAgentGUI
extends DefaultControlPanel
implements ActionListener {
    OPanel outPanel;
    boolean[] watchItems = new boolean[]{false, false, false, false, true, true, false, false};

    JessAgentGUI(JessAgent jessAgent) {
        super((Agent)jessAgent);
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.addSeparator();
        this.addButton(jToolBar, "run", "Run", "/images/toolbars/run.gif");
        this.addButton(jToolBar, "halt", "Halt", "/images/toolbars/halt.gif");
        this.addButton(jToolBar, "facts", "Facts", "/images/toolbars/facts.gif");
        this.addButton(jToolBar, "rules", "Rules", "/images/toolbars/rules.gif");
        this.addButton(jToolBar, "reset", "Reset", "/images/toolbars/reset.gif");
        this.addButton(jToolBar, "reinit", "Re-init", "/images/toolbars/reinit.gif");
        this.addButton(jToolBar, "watch", "Watch all", "/images/toolbars/watch.gif");
        this.addButton(jToolBar, "notePad", "Edit script with NotePadAgent", "/images/toolbars/agentEditor24.gif");
        this.addButton(jToolBar, "jEdit", "Edit script with jEdit", "/images/toolbars/jedit24.gif");
        this.add(jToolBar, "North");
        this.outPanel = new OPanel();
        this.add((Component)this.outPanel, "Center");
    }

    OPanel getOutPanel() {
        return this.outPanel;
    }

    public void command(String string) {
        JessController jessController = (JessController)this.ag.getController();
        if (string.equals("evalBuffer")) {
            this.evalBuffer();
        } else if (string.equals("evalSelection")) {
            this.evalSelection();
        } else if (string.equals("run")) {
            jessController.doSendControlMessage("run");
        } else if (string.equals("reset")) {
            jessController.doSendControlMessage("reset");
        } else if (string.equals("halt")) {
            jessController.halt();
        } else if (string.equals("facts")) {
            jessController.doSendControlMessage("facts");
        } else if (string.equals("rules")) {
            jessController.doSendControlMessage("rules");
        } else if (string.equals("reinit")) {
            jessController.doSendControlMessage("reinit");
        } else if (string.equals("jEdit")) {
            this.jedit();
        } else if (string.equals("notePad")) {
            String string2 = jessController.getBehaviorFile();
            if (string2 == null) {
                jessController.println("sorry no behavior file to edit");
            } else {
                jessController.println("editing : " + string2);
                EditorAgent editorAgent = new EditorAgent(string2);
                this.ag.launchAgent((AbstractAgent)editorAgent, "Edit : " + string2, true);
            }
        } else if (string.equals("watch")) {
            this.watchItems[4] = jessController.getWatchOutMessages();
            this.watchItems[5] = jessController.getWatchInMessages();
            this.watchItems[6] = jessController.getWatchRestartEngine();
            this.watchItems[7] = jessController.getWatchControlMessages();
            new JessAgentSetWatchDialog(this, this.watchItems);
        } else {
            super.command(string);
        }
    }

    void setWatchItems(boolean[] blArray) {
        this.watchItems = blArray;
        JessController jessController = (JessController)this.ag.getController();
        jessController.doSendControlMessage("unwatch", "all");
        if (this.watchItems[0] && this.watchItems[1] & this.watchItems[2] && this.watchItems[3]) {
            jessController.doSendControlMessage("watch", "all");
        } else {
            if (this.watchItems[0]) {
                jessController.doSendControlMessage("watch", "facts");
            }
            if (this.watchItems[1]) {
                jessController.doSendControlMessage("watch", "rules");
            }
            if (this.watchItems[2]) {
                jessController.doSendControlMessage("watch", "activations");
            }
            if (this.watchItems[3]) {
                jessController.doSendControlMessage("watch", "compilations");
            }
        }
        if (this.watchItems[4] != jessController.getWatchOutMessages()) {
            jessController.doSendControlMessage("watchOutMessages");
        }
        if (this.watchItems[5] != jessController.getWatchInMessages()) {
            jessController.doSendControlMessage("watchInMessages");
        }
        if (this.watchItems[6] != jessController.getWatchRestartEngine()) {
            jessController.doSendControlMessage("watchRestartEngine");
        }
        if (this.watchItems[7] != jessController.getWatchRestartEngine()) {
            jessController.doSendControlMessage("watchControlMessages");
        }
    }

    void evalBuffer() {
    }

    void evalSelection() {
    }

    void println(String string) {
        ((PrintWriter)this.outPanel.getOut()).println(string);
    }
}

