/*
 * Decompiled with CFR 0.152.
 */
package gnu.jbrowser;

import gnu.gui.JextButton;
import gnu.gui.JextHighlightButton;
import gnu.jbrowser.JBrowseLineParser;
import gnu.jbrowser.JBrowseOptionPane;
import gnu.jbrowser.JBrowseParser;
import gnu.jbrowser.Options;
import gnu.jbrowser.PropertyAccessor;
import gnu.jbrowser.UML;
import gnu.jbrowser.UMLTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsynedit.AbstractEditorPanel;

public class JBrowse
extends JPanel
implements ActionListener {
    public static final String VER_NUM = "1.0.1";
    public JBrowseParser.Results results;
    private AbstractEditorPanel frame;
    private PropertyAccessor props;
    private JBrowseParser parser;
    private UMLTree umlTree;
    private String fileName;
    private UMLTree.Model treeModel;
    private UMLTree.Node root;
    private JButton parseBtn;
    private JButton resizeBtn;
    private JButton configBtn;
    JPanel statusPanel;
    JLabel classLabel;
    JLabel interfaceLabel;
    JLabel attributeLabel;
    JLabel methodLabel;
    JLabel errorLabel;
    JPanel topPanel;
    private TreePane treePane;
    private OptionDialog optionDialog;
    private Options options;
    private Options.Filter filterOpt;
    private Options.Display displayOpt;
    private ChangeListener optionListener;
    private boolean hasJavaFileExtension = false;
    JScrollPane scpTreePane;

    public JBrowse(Activator activator) {
        this.frame = activator.getOwner();
        this.props = activator.getPropertyAccessor();
        this.parser = activator.getJBrowseParser();
        this.umlTree = activator.getUMLTree();
        if (this.props == null) {
            return;
        }
        if (this.parser == null) {
            return;
        }
        if (this.umlTree == null) {
            return;
        }
        this.treePane = new TreePane("jbrowse_tree");
        JBrowse jBrowse = this;
        jBrowse.setLayout(new BorderLayout());
        jBrowse.add("Center", this.treePane);
        this.optionDialog = new OptionDialog(this.frame, this, "JBrowse - Configure Options");
        this.options = this.optionDialog.getOptions();
        this.filterOpt = this.options.getFilterOptions();
        this.displayOpt = this.options.getDisplayOptions();
        this.treePane.init();
        this.parser.setOptions(this.options);
        this.parser.setRootNode(this.root);
        this.optionListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Object object = changeEvent.getSource();
                if (object == JBrowse.this.options) {
                    if (JBrowse.this.options.getShowStatusBar()) {
                        JBrowse.this.statusPanel.setVisible(true);
                    } else {
                        JBrowse.this.statusPanel.setVisible(false);
                    }
                    JBrowse.this.setPreferredSize();
                } else if (object == JBrowse.this.filterOpt) {
                    if (JBrowse.this.root.getChildCount() > 0) {
                        JBrowse.this.umlTree.display(JBrowse.this.treeModel, JBrowse.this.options, JBrowse.this.results);
                    }
                } else if (object == JBrowse.this.displayOpt && JBrowse.this.root.getChildCount(JBrowse.this.filterOpt) > 0) {
                    JBrowse.this.umlTree.updateVisibleToggled(JBrowse.this.options);
                }
            }
        };
        if (this.hasJavaFileExtension) {
            this.results = this.parser.parse();
            this.showResults(this.results);
        } else {
            this.showResults(this.results);
        }
    }

    public void parseNow() {
        this.setCursor(new Cursor(3));
        this.umlTree.setModel(null);
        this.results = this.parser.parse();
        this.showResults(this.results);
        this.paintAll(this.getGraphics());
        this.setCursor(new Cursor(0));
    }

    public Options.DisplayIro getDisplayOptions() {
        return this.displayOpt;
    }

    public ChangeListener getOptionListener() {
        return this.optionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals("reparse")) {
            this.parseNow();
            return;
        }
        if (object == this.parseBtn) {
            this.parseNow();
        } else if (object == this.resizeBtn) {
            this.setPreferredSize();
        } else if (object == this.configBtn) {
            this.optionDialog.reInit();
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.optionDialog.getSize();
            int n = this.getLocation().x;
            int n2 = (dimension.height - dimension2.height) / 2;
            if (n + this.getSize().width + 12 + dimension2.width > dimension.width) {
                if (n - dimension2.width - 12 < 0) {
                    this.optionDialog.setLocation(dimension.width - dimension2.width - 2, n2);
                } else {
                    this.optionDialog.setLocation(n - dimension2.width - 10, n2);
                }
            } else {
                this.optionDialog.setLocation(n + this.getSize().width + 10, n2);
            }
            this.optionDialog.setVisible(true);
            this.optionDialog.paintAll(this.getGraphics());
            this.paintAll(this.getGraphics());
        }
    }

    public void setPreferredSize() {
        this.topPanel.validate();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.scpTreePane.getViewport().getSize();
        Dimension dimension3 = this.scpTreePane.getViewport().getPreferredSize();
        Dimension dimension4 = this.umlTree.getPreferredSize();
        if (dimension2.height < dimension3.height) {
            this.scpTreePane.getVerticalScrollBar().setVisible(true);
        }
        int n = this.scpTreePane.getVerticalScrollBar().isVisible() ? dimension3.width + 12 + 16 : dimension3.width + 12;
        if (this.statusPanel.isVisible()) {
            this.statusPanel.validate();
            n = Math.max(n, this.statusPanel.getPreferredSize().width + 8);
        }
        dimension.width = Math.max(n, this.topPanel.getPreferredSize().width + 8);
        this.setSize(dimension);
        this.paintAll(this.getGraphics());
    }

    public void showResults(JBrowseParser.Results results) {
        this.umlTree.display(this.treeModel, this.options, results);
        if (results != null) {
            this.classLabel.setText("" + results.getClassCount());
            this.interfaceLabel.setText("" + results.getInterfaceCount());
            this.attributeLabel.setText("" + (results.getObjAttrCount() + results.getPrimAttrCount()));
            this.methodLabel.setText("" + results.getMethodCount());
            if (results.getErrorCount() > 0) {
                this.errorLabel.setText("" + results.getErrorCount() + " error(s)");
                this.errorLabel.setVisible(true);
                this.topPanel.validate();
                Dimension dimension = this.getSize();
                Dimension dimension2 = this.topPanel.getPreferredSize();
                if (dimension.width < dimension2.width + 8) {
                    this.setPreferredSize();
                }
            } else {
                this.errorLabel.setVisible(false);
            }
            if (results.getClassCount() + results.getInterfaceCount() == 0) {
                this.getToolkit().beep();
            }
        }
    }

    PropertyAccessor getPropertyAccessor() {
        return this.props;
    }

    static class OptionDialog
    extends JDialog
    implements ActionListener {
        private JBrowse parent;
        JBrowseOptionPane optionPane;
        private JButton btnSetAsDefaults;
        private JButton btnRestoreDefaults;

        OptionDialog(AbstractEditorPanel abstractEditorPanel, JBrowse jBrowse, String string) {
            this.parent = jBrowse;
            this.optionPane = new JBrowseOptionPane("jbrowse_options");
            this.optionPane.setPropertyAccessor(jBrowse.getPropertyAccessor());
            this.optionPane.load();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.optionPane);
            JPanel jPanel = new JPanel();
            this.btnSetAsDefaults = new JextHighlightButton("Set As Defaults");
            this.btnSetAsDefaults.addActionListener(this);
            jPanel.add(this.btnSetAsDefaults);
            this.btnRestoreDefaults = new JextHighlightButton("Restore Defaults");
            this.btnRestoreDefaults.addActionListener(this);
            jPanel.add(this.btnRestoreDefaults);
            this.getContentPane().add("South", jPanel);
        }

        Options getOptions() {
            return this.optionPane.getOptions();
        }

        void setOptions() {
            this.optionPane.setOptions();
        }

        void reInit() {
            if (!this.optionPane.isInitGui()) {
                this.optionPane.initGui();
                this.pack();
            }
            if (!this.optionPane.isInitModel()) {
                this.optionPane.initModel();
                this.getOptions().addChangeListener(this.parent.getOptionListener());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.btnSetAsDefaults) {
                this.optionPane.save();
            } else if (object == this.btnRestoreDefaults) {
                boolean bl = this.getOptions().getShowStatusBar();
                this.optionPane.load();
                this.optionPane.initModel();
                this.parent.showResults(this.parent.results);
                boolean bl2 = this.getOptions().getShowStatusBar();
                if (bl != bl2) {
                    if (bl2) {
                        this.parent.statusPanel.setVisible(true);
                    } else {
                        this.parent.statusPanel.setVisible(false);
                    }
                    this.parent.setPreferredSize();
                }
            }
        }
    }

    public static interface Activator {
        public AbstractEditorPanel getOwner();

        public PropertyAccessor getPropertyAccessor();

        public JBrowseParser getJBrowseParser();

        public UMLTree getUMLTree();
    }

    class TreePane
    extends JPanel {
        public TreePane(String string) {
            this.setName(string);
            this.setLayout(new BorderLayout());
            URL uRL = this.getClass().getResource("/images/Parse.gif");
            if (uRL == null) {
                JBrowse.this.parseBtn = new JextHighlightButton("Parse");
            } else {
                JBrowse.this.parseBtn = new JextButton(new ImageIcon(uRL));
            }
            uRL = this.getClass().getResource("/images/Resize.gif");
            if (uRL == null) {
                JBrowse.this.resizeBtn = new JextHighlightButton("Resize");
            } else {
                JBrowse.this.resizeBtn = new JextButton(new ImageIcon(uRL));
            }
            uRL = this.getClass().getResource("/images/Config.gif");
            if (uRL == null) {
                JBrowse.this.configBtn = new JextHighlightButton("Config");
            } else {
                JBrowse.this.configBtn = new JextButton(new ImageIcon(uRL));
            }
            Insets insets = new Insets(0, 0, 0, 0);
            JBrowse.this.parseBtn.setMargin(insets);
            JBrowse.this.resizeBtn.setMargin(insets);
            JBrowse.this.configBtn.setMargin(insets);
            JBrowse.this.parseBtn.setToolTipText("Parse the buffer");
            JBrowse.this.resizeBtn.setToolTipText("Adjust width");
            JBrowse.this.configBtn.setToolTipText("Set Options");
            JBrowse.this.parseBtn.addActionListener(JBrowse.this);
            JBrowse.this.resizeBtn.addActionListener(JBrowse.this);
            JBrowse.this.configBtn.addActionListener(JBrowse.this);
            JBrowse.this.errorLabel = new JLabel(UML.Type.ERROR.getIcon());
            JBrowse.this.errorLabel.setIconTextGap(2);
            JBrowse.this.errorLabel.setFont(new Font("Helvetica", 0, 11));
            JPanel jPanel = new JPanel(new FlowLayout(0, 1, 1));
            jPanel.add(JBrowse.this.parseBtn);
            jPanel.add(JBrowse.this.resizeBtn);
            jPanel.add(JBrowse.this.configBtn);
            jPanel.add(JBrowse.this.errorLabel);
            JBrowse.this.topPanel = new JPanel(new BorderLayout(0, 0));
            JBrowse.this.topPanel.add((Component)jPanel, "West");
            this.add((Component)JBrowse.this.topPanel, "North");
            JBrowse.this.scpTreePane = new JScrollPane(JBrowse.this.umlTree);
            this.add((Component)JBrowse.this.scpTreePane, "Center");
        }

        private void init() {
            JBrowse.this.statusPanel = new JPanel(new GridLayout(1, 4, 0, 1));
            JBrowse.this.classLabel = new JLabel(UML.Type.CLASS.getIcon());
            JBrowse.this.interfaceLabel = new JLabel(UML.Type.INTERFACE.getIcon());
            JBrowse.this.attributeLabel = new JLabel(UML.Type.ATTRIBUTE.getIcon());
            JBrowse.this.methodLabel = new JLabel(UML.Type.METHOD.getIcon());
            JBrowse.this.classLabel.setIconTextGap(2);
            JBrowse.this.interfaceLabel.setIconTextGap(2);
            JBrowse.this.attributeLabel.setIconTextGap(2);
            JBrowse.this.methodLabel.setIconTextGap(2);
            JBrowse.this.classLabel.setToolTipText("classes");
            JBrowse.this.interfaceLabel.setToolTipText("interfaces");
            JBrowse.this.attributeLabel.setToolTipText("attributes");
            JBrowse.this.methodLabel.setToolTipText("methods");
            JBrowse.this.classLabel.setBorder(new EtchedBorder());
            JBrowse.this.interfaceLabel.setBorder(new EtchedBorder());
            JBrowse.this.attributeLabel.setBorder(new EtchedBorder());
            JBrowse.this.methodLabel.setBorder(new EtchedBorder());
            Font font = new Font("Monospaced", 0, 11);
            JBrowse.this.classLabel.setFont(font);
            JBrowse.this.interfaceLabel.setFont(font);
            JBrowse.this.attributeLabel.setFont(font);
            JBrowse.this.methodLabel.setFont(font);
            JBrowse.this.statusPanel.add(JBrowse.this.classLabel);
            JBrowse.this.statusPanel.add(JBrowse.this.interfaceLabel);
            JBrowse.this.statusPanel.add(JBrowse.this.attributeLabel);
            JBrowse.this.statusPanel.add(JBrowse.this.methodLabel);
            this.add((Component)JBrowse.this.statusPanel, "South");
            if (JBrowse.this.options.getShowStatusBar()) {
                JBrowse.this.statusPanel.setVisible(true);
            } else {
                JBrowse.this.statusPanel.setVisible(false);
            }
            JBrowse.this.fileName = JBrowse.this.parser.getSourceName();
            if (!(JBrowse.this.parser instanceof JBrowseLineParser && ((JBrowseLineParser)JBrowse.this.parser).usesJavaTokenMarker() || JBrowse.this.fileName.toUpperCase().endsWith(".JAVA"))) {
                JBrowse.this.fileName = JBrowse.this.fileName + " (NON-java file?)";
                JBrowse.this.hasJavaFileExtension = false;
                JBrowse.this.errorLabel.setText("Un-parsed");
                JBrowse.this.topPanel.validate();
            } else {
                JBrowse.this.hasJavaFileExtension = true;
            }
            JBrowse.this.root = new UMLTree.Node(JBrowse.this.fileName);
            JBrowse.this.treeModel = new UMLTree.Model(JBrowse.this.root);
        }
    }
}

