/*
 * Decompiled with CFR 0.152.
 */
package madkit.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import madkit.boot.Madkit;
import madkit.designer.AddDependElement;
import madkit.designer.NewBshAgentDialog;
import madkit.designer.NewJavaAgentDialog;
import madkit.designer.NewJessAgentDialog;
import madkit.designer.NewPluginDialog;
import madkit.designer.NewPythonAgentDialog;
import madkit.designer.NewSchemeAgentDialog;
import madkit.designer.PluginDesignerAgent;
import madkit.designer.PluginNode;
import madkit.designer.PluginTree;
import madkit.kernel.Utils;
import madkit.system.PluginInformation;
import madkit.utils.graphics.GraphicUtils;
import madkit.utils.graphics.LoadDialog;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class PluginDesignerGUI
extends JRootPane
implements ActionListener {
    Map<String, PluginNode> pluginNodes = new HashMap<String, PluginNode>();
    String madkitDir = System.getProperty("madkit.dir");
    Map plugins;
    PluginInformation currentPlugin;
    boolean pluginModified = false;
    DefaultListModel dependListModel = new DefaultListModel();
    DefaultListModel requireListModel = new DefaultListModel();
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane horizSplitPanel = new JSplitPane();
    JTabbedPane tabbedPane = new JTabbedPane();
    PluginTree treePanel = null;
    JToolBar buttonToolBar = new JToolBar();
    JButton bNew;
    JButton bNewJavaAgent;
    JButton bNewPythonAgent;
    JButton bNewSchemeAgent;
    JButton bNewBshAgent;
    JButton bNewJessAgent;
    JPanel generalPanel = new JPanel();
    JPanel dependsPanel = new JPanel();
    JMenuBar project_menubar = new JMenuBar();
    JMenu jproject_menu = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    Border border2;
    JPanel valuePanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel projectNameField = new JLabel();
    GridLayout gridLayout1 = new GridLayout(0, 1);
    JTextField versionNameField = new JTextField();
    JPanel fieldPanel = new JPanel();
    JTextField authorNameField = new JTextField();
    JLabel jarName = new JLabel();
    JLabel dirName = new JLabel();
    JLabel dirLabel = new JLabel("Directory : ");
    JLabel authorLabel = new JLabel("Author(s) name :  ");
    JLabel jarLabel = new JLabel("Jar name : ");
    JLabel nameLabel = new JLabel();
    JPanel labelPanel = new JPanel();
    GridLayout gridLayout2 = new GridLayout(0, 1);
    JLabel versionLabel = new JLabel("Version number :  ");
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JSplitPane splitReqPane = new JSplitPane();
    JPanel projectReqPanel = new JPanel();
    JPanel jarReqPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    Border border3;
    Border border4;
    TitledBorder titledBorder3;
    Border border5;
    JList reqProjectsList;
    JList reqJarList;
    PluginDesignerAgent ag;
    JPanel depButtonPanel = new JPanel();
    JButton depAdd = new JButton();
    JButton depRemove = new JButton();
    JPanel reqButtonPanel = new JPanel();
    JButton reqAdd = new JButton();
    JButton reqRemove = new JButton();
    JPanel genButtonPanel = new JPanel();
    JButton genValidate = new JButton();
    JButton butBuild = new JButton();
    JTextField descrField = new JTextField();
    JLabel descrLabel = new JLabel();
    JTextField catField = new JTextField();
    JLabel catLabel = new JLabel();

    public PluginDesignerGUI(PluginDesignerAgent pluginDesignerAgent) {
        this.ag = pluginDesignerAgent;
        try {
            this.plugins = pluginDesignerAgent.getPlugins();
            this.treePanel = new PluginTree(this, pluginDesignerAgent);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(103, 101, 98), new Color(148, 145, 140)), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Reguired plugins");
        this.border3 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border4 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.titledBorder3 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "Jars required");
        this.border5 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Required jars"), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(this.borderLayout1);
        this.horizSplitPanel.setOrientation(1);
        this.treePanel.setPreferredSize(new Dimension(160, 280));
        this.treePanel.setMinimumSize(new Dimension(160, 10));
        this.bNew = GraphicUtils.addTool((ActionListener)this, (JToolBar)this.buttonToolBar, (String)"new_project", (String)"New project", (String)"/images/pluginagent.gif");
        this.bNewJavaAgent = GraphicUtils.addTool((ActionListener)this, (JToolBar)this.buttonToolBar, (String)"new_java_agent", (String)"New Java agent", (String)"/images/javaagent.gif");
        this.bNewPythonAgent = GraphicUtils.addTool((ActionListener)this, (JToolBar)this.buttonToolBar, (String)"new_python_agent", (String)"New Python agent", (String)"/images/agents/agentPython.gif");
        this.bNewSchemeAgent = GraphicUtils.addTool((ActionListener)this, (JToolBar)this.buttonToolBar, (String)"new_scheme_agent", (String)"New Scheme (Kawa) agent", (String)"/images/agents/schemeAgent.gif");
        this.bNewBshAgent = GraphicUtils.addTool((ActionListener)this, (JToolBar)this.buttonToolBar, (String)"new_bsh_agent", (String)"New BeanShell (Java interpreted) agent", (String)"/images/agents/agentBeanShell.gif");
        this.bNewJessAgent = GraphicUtils.addTool((ActionListener)this, (JToolBar)this.buttonToolBar, (String)"new_jess_agent", (String)"New Jess (Rule based system) agent", (String)"/images/agents/jessAgent.gif");
        this.dependListModel.addElement("madkitkernel");
        this.jMenuItem1.setText("new project");
        this.jMenuItem2.setText("exit");
        this.generalPanel.setLayout(this.borderLayout2);
        this.generalPanel.setBorder(this.border2);
        this.valuePanel.setLayout(this.borderLayout3);
        this.projectNameField.setPreferredSize(new Dimension(51, 21));
        this.projectNameField.setFont(new Font("Dialog", 1, 11));
        this.projectNameField.setText("<project>");
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setHgap(2);
        this.gridLayout1.setRows(7);
        this.gridLayout1.setVgap(5);
        this.versionNameField.setText("1.0");
        this.fieldPanel.setLayout(this.gridLayout1);
        this.fieldPanel.setBorder(null);
        this.authorNameField.setText("<author(s)>");
        this.jarName.setText("<project>.jar");
        this.authorLabel.setFont(new Font("Dialog", 1, 11));
        this.jarLabel.setFont(new Font("Dialog", 1, 11));
        this.nameLabel.setFont(new Font("Dialog", 1, 11));
        this.nameLabel.setText("Project name : ");
        this.dirLabel.setFont(new Font("Dialog", 1, 11));
        this.labelPanel.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setHgap(2);
        this.gridLayout2.setRows(7);
        this.gridLayout2.setVgap(5);
        this.versionLabel.setFont(new Font("Dialog", 1, 11));
        this.dependsPanel.setDebugGraphicsOptions(0);
        this.dependsPanel.setLayout(this.borderLayout4);
        this.splitReqPane.setOrientation(0);
        this.projectReqPanel.setLayout(this.borderLayout5);
        this.jarReqPanel.setLayout(this.borderLayout6);
        this.reqProjectsList = new JList(this.dependListModel);
        this.reqJarList = new JList(this.requireListModel);
        JScrollPane jScrollPane = new JScrollPane(this.reqProjectsList);
        jScrollPane.setPreferredSize(new Dimension(180, 100));
        jScrollPane.setBorder(null);
        this.projectReqPanel.setBorder(this.border3);
        this.jarReqPanel.setBorder(this.border5);
        this.depAdd.setText("Add ...");
        this.depAdd.setActionCommand("add_depend");
        this.depAdd.addActionListener(this);
        this.depRemove.setText("Remove");
        this.depRemove.setActionCommand("remove_depend");
        this.depRemove.addActionListener(this);
        this.reqAdd.setText("Add ...");
        this.reqAdd.setActionCommand("add_require");
        this.reqAdd.addActionListener(this);
        this.reqRemove.setText("Remove");
        this.reqRemove.setActionCommand("remove_require");
        this.reqRemove.addActionListener(this);
        this.genValidate.setText("Validate");
        this.genValidate.setEnabled(false);
        this.butBuild.setText("Build");
        this.butBuild.setEnabled(false);
        this.genValidate.addActionListener(this);
        this.butBuild.addActionListener(this);
        this.tabbedPane.setPreferredSize(new Dimension(200, 280));
        this.descrField.setToolTipText("");
        this.descrField.setText("The (still) unknown project");
        this.descrLabel.setFont(new Font("Dialog", 1, 11));
        this.descrLabel.setText("Description");
        this.catField.setText("demos");
        this.catLabel.setText("Category");
        this.catLabel.setFont(new Font("Dialog", 1, 11));
        this.horizSplitPanel.add((Component)((Object)this.treePanel), "left");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.horizSplitPanel.add((Component)jPanel, "right");
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)this.genButtonPanel, "South");
        this.getContentPane().add((Component)this.buttonToolBar, "North");
        this.getContentPane().add((Component)this.horizSplitPanel, "Center");
        this.tabbedPane.add((Component)this.generalPanel, "General");
        this.tabbedPane.add((Component)this.dependsPanel, "Java build path");
        this.dependsPanel.add((Component)this.splitReqPane, "Center");
        this.splitReqPane.add((Component)this.projectReqPanel, "left");
        this.setMenuBar(this.project_menubar);
        this.project_menubar.add(this.jproject_menu);
        this.jproject_menu.add(this.jMenuItem1);
        this.jproject_menu.add(this.jMenuItem2);
        this.generalPanel.add((Component)this.valuePanel, "Center");
        this.valuePanel.add((Component)this.fieldPanel, "Center");
        this.fieldPanel.add((Component)this.projectNameField, null);
        this.fieldPanel.add((Component)this.jarName, null);
        this.fieldPanel.add((Component)this.authorNameField, null);
        this.fieldPanel.add((Component)this.versionNameField, null);
        this.fieldPanel.add((Component)this.descrField, null);
        this.valuePanel.add((Component)this.labelPanel, "West");
        this.labelPanel.add((Component)this.nameLabel, null);
        this.labelPanel.add((Component)this.jarLabel, null);
        this.labelPanel.add((Component)this.authorLabel, null);
        this.tabbedPane.add((Component)this.contentPanel, "doc");
        this.splitReqPane.add((Component)this.projectReqPanel, "top");
        this.splitReqPane.add((Component)this.jarReqPanel, "bottom");
        this.projectReqPanel.add((Component)jScrollPane, "Center");
        this.projectReqPanel.add((Component)this.depButtonPanel, "South");
        this.jarReqPanel.add((Component)this.reqJarList, "Center");
        this.depButtonPanel.add((Component)this.depAdd, null);
        this.depButtonPanel.add((Component)this.depRemove, null);
        this.jarReqPanel.add((Component)this.reqButtonPanel, "South");
        this.reqButtonPanel.add((Component)this.reqAdd, null);
        this.reqButtonPanel.add((Component)this.reqRemove, null);
        this.genButtonPanel.add((Component)this.genValidate, null);
        this.genButtonPanel.add((Component)this.butBuild, null);
        this.labelPanel.add((Component)this.versionLabel, null);
        this.labelPanel.add((Component)this.descrLabel, null);
        this.fieldPanel.add((Component)this.catField, null);
        this.labelPanel.add((Component)this.catLabel, null);
        this.fieldPanel.add((Component)this.dirName, null);
        this.labelPanel.add((Component)this.dirLabel, null);
    }

    Map getPlugins() {
        return this.plugins;
    }

    void showPlugin(String string) {
        PluginInformation pluginInformation;
        this.currentPlugin = pluginInformation = (PluginInformation)this.plugins.get(string);
        this.genValidate.setEnabled(true);
        this.butBuild.setEnabled(true);
        this.projectNameField.setText(string);
        this.versionNameField.setText(pluginInformation.getVersion().toString());
        this.authorNameField.setText(pluginInformation.getAuthorName());
        this.jarName.setText(string + ".jar");
        this.descrField.setText(pluginInformation.getDescription());
        this.dirName.setText(pluginInformation.getDirectory().toString());
        this.dependListModel.removeAllElements();
        Vector vector = pluginInformation.getDependList();
        for (int i = 0; i < vector.size(); ++i) {
            this.dependListModel.addElement(vector.get(i));
        }
        this.dependsPanel.revalidate();
        this.dependsPanel.repaint();
        this.requireListModel.removeAllElements();
        Vector vector2 = pluginInformation.getRequireList();
        for (int i = 0; i < vector2.size(); ++i) {
            this.requireListModel.addElement(vector2.get(i));
        }
        this.jarReqPanel.revalidate();
        this.jarReqPanel.repaint();
    }

    void addDepends(Object[] objectArray) {
        if (objectArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.dependListModel.contains(objectArray[i])) continue;
                this.dependListModel.addElement(objectArray[i]);
                this.currentPlugin.addDepend((String)objectArray[i]);
                bl = true;
            }
            if (bl) {
                this.pluginModified = true;
                this.dependsPanel.revalidate();
                this.dependsPanel.repaint();
            }
        }
    }

    void removeDepend(Object[] objectArray) {
        if (objectArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.dependListModel.contains(objectArray[i])) continue;
                this.dependListModel.removeElement(objectArray[i]);
                this.currentPlugin.removeDepend((String)objectArray[i]);
                bl = true;
            }
            if (bl) {
                this.pluginModified = true;
                this.dependsPanel.revalidate();
                this.dependsPanel.repaint();
            }
        }
    }

    void addRequire(Object[] objectArray) {
        if (objectArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.requireListModel.contains(objectArray[i])) continue;
                this.requireListModel.addElement(objectArray[i]);
                this.currentPlugin.addRequire((String)objectArray[i]);
                bl = true;
            }
            if (bl) {
                this.pluginModified = true;
                this.jarReqPanel.revalidate();
                this.jarReqPanel.repaint();
            }
        }
    }

    void removeRequire(Object[] objectArray) {
        if (objectArray.length > 0) {
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.requireListModel.contains(objectArray[i])) continue;
                this.requireListModel.removeElement(objectArray[i]);
                this.currentPlugin.removeRequire((String)objectArray[i]);
                bl = true;
            }
            if (bl) {
                this.pluginModified = true;
                this.jarReqPanel.revalidate();
                this.jarReqPanel.repaint();
            }
        }
    }

    void updatePlugin() {
        if (this.currentPlugin == null) {
            System.err.println("No project selected.. Please select a project first");
        }
        this.currentPlugin.setVersion(this.versionNameField.getText());
        this.currentPlugin.setAuthorName(this.authorNameField.getText());
        this.currentPlugin.setDescription(this.descrField.getText());
    }

    void addPlugin(String string, boolean bl) {
        String string2;
        PluginInformation pluginInformation = (PluginInformation)this.plugins.get(string);
        if (pluginInformation == null) {
            System.err.println("Error: not a real madkit plugin: " + string);
        }
        if ((string2 = pluginInformation.getSystem()).equalsIgnoreCase("false")) {
            this.treePanel.addPlugin(string, (PluginInformation)this.plugins.get(string));
            if (bl) {
                this.showPlugin(string);
                this.buildProject(string);
            }
        }
    }

    void buildCurrentProject() {
        if (this.currentPlugin == null) {
            System.err.println("Not project selected.. Please select a project first");
        }
        this.buildProject(this.currentPlugin);
    }

    void buildProject(String string) {
        PluginInformation pluginInformation = (PluginInformation)this.plugins.get(string);
        if (pluginInformation == null) {
            System.err.println("Error: not a correct project ");
        } else {
            this.buildProject(pluginInformation);
        }
    }

    void buildProject(PluginInformation pluginInformation) {
        File file = new File(pluginInformation.getDirectory(), "build.xml");
        if (!file.isFile()) {
            System.err.println("Error: cannot build project, cannot find build.xml file");
            return;
        }
        try {
            Project project = new Project();
            DefaultLogger defaultLogger = new DefaultLogger();
            defaultLogger.setMessageOutputLevel(2);
            defaultLogger.setOutputPrintStream(System.out);
            defaultLogger.setErrorPrintStream(System.err);
            project.addBuildListener((BuildListener)defaultLogger);
            project.init();
            ProjectHelper.configureProject((Project)project, (File)file);
            String string = project.getProperty("system.plugin");
            if (string == null || !"true".equalsIgnoreCase(string)) {
                project.executeTarget(project.getDefaultTarget());
                String string2 = project.getProperty("jar.name");
                String string3 = Madkit.libDirectory + File.separator + string2;
                File file2 = new File(string3);
                if (file2.isFile()) {
                    File[] fileArray = new File[]{file2};
                    Madkit.newMadkitClassLoader((File[])fileArray);
                }
                System.out.println("BUILD SUCCESSFUL");
                this.getPluginNode(pluginInformation.getName()).refresh();
            } else {
                System.out.println("Cannot build the system project : " + pluginInformation.getName());
            }
        }
        catch (BuildException buildException) {
            System.err.println("BUILD FAILED");
            System.err.println(buildException.getMessage());
        }
    }

    void setPluginNode(String string, PluginNode pluginNode) {
        this.pluginNodes.put(string, pluginNode);
    }

    PluginNode getPluginNode(String string) {
        return this.pluginNodes.get(string);
    }

    void createPlugin(String string, String string2) {
        boolean bl = this.ag.createPlugin(string, string2);
        if (bl) {
            this.buildProject(string);
        }
    }

    void createJavaAgent(String string, String string2) {
        boolean bl = this.ag.createJavaAgent(this.currentPlugin.getName(), string, string2);
        if (bl) {
            this.buildCurrentProject();
        }
    }

    void createPythonAgent(String string, String string2) {
        this.ag.createPythonAgent(this.currentPlugin.getName(), string, string2);
    }

    void createJessAgent(String string, String string2) {
        this.ag.createJessAgent(this.currentPlugin.getName(), string, string2);
    }

    void createBshAgent(String string, String string2) {
        this.ag.createBshAgent(this.currentPlugin.getName(), string, string2);
    }

    void createSchemeAgent(String string, String string2) {
        this.ag.createSchemeAgent(this.currentPlugin.getName(), string, string2);
    }

    boolean checkCurrentPlugin() {
        if (this.currentPlugin == null) {
            JOptionPane.showMessageDialog(null, "Select a plugin first", "No plugin selected", 1);
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("new_project")) {
            NewPluginDialog newPluginDialog = new NewPluginDialog(this, "Create new plugin");
            newPluginDialog.show();
        } else if (string.equalsIgnoreCase("new_java_agent")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            NewJavaAgentDialog newJavaAgentDialog = new NewJavaAgentDialog(this, "Create new Java Agent");
            newJavaAgentDialog.show();
        } else if (string.equalsIgnoreCase("new_python_agent")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            NewPythonAgentDialog newPythonAgentDialog = new NewPythonAgentDialog(this, "Create new Python Agent");
            newPythonAgentDialog.show();
        } else if (string.equalsIgnoreCase("new_scheme_agent")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            NewSchemeAgentDialog newSchemeAgentDialog = new NewSchemeAgentDialog(this, "Create new Scheme Agent");
            newSchemeAgentDialog.show();
        } else if (string.equalsIgnoreCase("new_jess_agent")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            NewJessAgentDialog newJessAgentDialog = new NewJessAgentDialog(this, "Create new Jess Agent");
            newJessAgentDialog.show();
        } else if (string.equalsIgnoreCase("new_bsh_agent")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            NewBshAgentDialog newBshAgentDialog = new NewBshAgentDialog(this, "Create new BeanShell Agent");
            newBshAgentDialog.show();
        } else if (string.equalsIgnoreCase("Validate")) {
            this.validate();
        } else if (string.equalsIgnoreCase("Build")) {
            this.buildCurrentProject();
        } else if (string.equalsIgnoreCase("remove_depend")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            if (JOptionPane.showConfirmDialog(Utils.getFrameParent((Container)this), "Do you really want to remove this dependencies?", "Removing dependencies", 0) == 0) {
                Object[] objectArray = this.reqProjectsList.getSelectedValues();
                this.removeDepend(objectArray);
            }
        } else if (string.equalsIgnoreCase("add_depend")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            AddDependElement addDependElement = new AddDependElement(this, Utils.getRealFrameParent((Component)this));
            addDependElement.show();
        } else if (string.equalsIgnoreCase("add_require")) {
            this.addRequireElement();
        } else if (string.equalsIgnoreCase("remove_require")) {
            if (!this.checkCurrentPlugin()) {
                return;
            }
            if (JOptionPane.showConfirmDialog(Utils.getFrameParent((Container)this), "Do you really want to remove this jar?", "Removing external jars", 0) == 0) {
                Object[] objectArray = this.reqJarList.getSelectedValues();
                this.removeRequire(objectArray);
            }
        }
    }

    public void validate() {
        Writer writer;
        Reader reader;
        if (this.currentPlugin == null) {
            System.err.println("Error: select a plugin first");
            return;
        }
        this.updatePlugin();
        File file = this.currentPlugin.getDirectory();
        File file2 = new File(file, "build.xml");
        String string = null;
        if (!file2.isFile()) {
            System.err.println("Error: cannot validate modifs, cannot find build.xml file");
            return;
        }
        try {
            reader = new FileReader(file2);
            writer = new StringWriter();
            Utils.copyToWriter((Reader)reader, (Writer)writer);
            string = writer.toString();
        }
        catch (Exception exception) {
            System.err.println("Error in validating the build.xml file");
        }
        string = this.propertySubst("author", this.currentPlugin.getAuthorName(), string);
        string = this.propertySubst("description", this.currentPlugin.getDescription(), string);
        string = this.propertySubst("depend", this.currentPlugin.getDepends(), string);
        string = this.propertySubst("requires", this.currentPlugin.getRequires(), string);
        string = this.propertySubst("version", this.currentPlugin.getVersion().toString(), string);
        if (this.currentPlugin.getDocFile() != null) {
            string = this.propertySubst("docfile", this.currentPlugin.getDocFile(), string);
        }
        string = this.propertySubst("category", this.currentPlugin.getCategory(), string);
        string = this.classpathSubst(string);
        try {
            reader = new StringReader(string);
            writer = new FileWriter(file2);
            Utils.copyToWriter((Reader)reader, (Writer)writer);
        }
        catch (Exception exception) {
            System.err.println("Error in saving the build.xml file");
        }
        System.out.println("Plugin: " + this.currentPlugin.getName() + " validated");
    }

    String propertySubst(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile("<property name=\"" + string + "\"( +)value=\"(.*)\"/>");
        Matcher matcher = pattern.matcher(string3);
        return matcher.replaceFirst("<property name=\"" + string + "\" value=\"" + string2 + "\"/>");
    }

    String classpathSubst(String string) {
        Pattern pattern = Pattern.compile("<fileset id=\"project.class.path\"(.*)</fileset>", 32);
        Matcher matcher = pattern.matcher(string);
        String string2 = "";
        Vector vector = this.currentPlugin.getDependList();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "\t\t<include name=\"" + vector.get(i) + ".jar\"/>\n";
        }
        Vector vector2 = this.currentPlugin.getRequireList();
        int n2 = vector2.size();
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + "\t\t<include name=\"" + vector2.get(i) + "\"/>\n";
        }
        String string3 = matcher.replaceFirst("<fileset id=\"project.class.path\" dir=\"\\${jars.dir}\">\n" + string2 + "</fileset>");
        return string3;
    }

    void addRequireElement() {
        String string = System.getProperty("madkit.dir") + File.separator + "lib";
        LoadDialog loadDialog = new LoadDialog((Component)this, string, true, "add external jars", "jar");
        if (loadDialog.isFileChoosed()) {
            this.addRequire(new String[]{loadDialog.getFileName()});
        }
    }
}

