/*
 * Decompiled with CFR 0.152.
 */
package madkit.designer;

import java.io.File;
import javax.swing.ImageIcon;
import jsynedit.JSynEditAgent;
import madkit.TreeTools.FileIconDescriptor;
import madkit.TreeTools.FileNode;
import madkit.TreeTools.GenericIconDescriptor;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.messages.ControlMessage;
import madkit.system.EditorAgent;

public class EditableFileNode
extends FileNode {
    AbstractAgent ag;
    static GenericIconDescriptor editableFileNodeDescriptor = new FileIconDescriptor((String[][])new String[][]{{"txt", "/images/text_edit.gif"}, {"xml", "/images/html.png"}, {"java", "/images/javafile.gif"}}, (String[][])new String[][]{{"edit with AgentEditor", "edit"}, {"edit with JSynEdit", "JSynEdit"}, {"properties", "info"}});

    public ImageIcon getLeafIcon() {
        ImageIcon imageIcon = null;
        GenericIconDescriptor genericIconDescriptor = this.getDescriptor();
        if (genericIconDescriptor == null) {
            genericIconDescriptor = EditableFileNode.getFileNodeDescriptor();
        }
        if (this.file != null) {
            imageIcon = genericIconDescriptor.getImage(this.file);
        }
        return imageIcon;
    }

    public EditableFileNode(AbstractAgent abstractAgent, File file) {
        super(file);
        this.ag = abstractAgent;
        this.setDescriptor(editableFileNodeDescriptor);
    }

    public void edit() {
        String string = this.getFile().getAbsolutePath();
        EditorAgent editorAgent = new EditorAgent(string);
        this.ag.launchAgent((AbstractAgent)editorAgent, "Edit : " + string, true);
    }

    public void execute() {
        this.edit();
    }

    public void JSynEdit() {
        String string = this.getFile().getAbsolutePath();
        System.out.println("Editing : " + string);
        AgentAddress agentAddress = this.ag.getAgentWithRole("system", "editor");
        System.out.println("Editor: " + agentAddress);
        if (agentAddress != null) {
            System.out.println("Sending message to " + agentAddress);
            this.ag.sendMessage(agentAddress, (Message)new ControlMessage("edit", this.file.getAbsolutePath()));
        } else {
            try {
                JSynEditAgent jSynEditAgent = new JSynEditAgent(string);
                this.ag.launchAgent((AbstractAgent)jSynEditAgent, "Edit : " + string, true);
            }
            catch (Exception exception) {
                System.err.println("Warning: JSynEdit has not been implemented");
            }
        }
    }

    public void jedit() {
        System.out.println("Warning: for the moment jEdit has not been re-implemented into MadKit");
    }
}

