/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.AntlibDefinition;
import org.apache.tools.ant.taskdefs.MacroInstance;

public class MacroDef
extends AntlibDefinition
implements TaskContainer {
    private UnknownElement nestedTask;
    private String name;
    private List attributes = new ArrayList();
    private Map elements = new HashMap();
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$MacroInstance;

    public void setName(String name) {
        this.name = name;
    }

    public void addTask(Task nestedTask) {
        if (this.nestedTask != null) {
            throw new BuildException("Only one sequential/Parallel allowed");
        }
        UnknownElement ue = (UnknownElement)nestedTask;
        if (!ue.getNamespace().equals("") || !ue.getTag().equals("sequential") && !ue.getTag().equals("parallel")) {
            throw new BuildException("Unsupported tag " + ue.getQName());
        }
        this.nestedTask = ue;
    }

    public UnknownElement getNestedTask() {
        return this.nestedTask;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Map getElements() {
        return this.elements;
    }

    public static boolean isValidNameCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-';
    }

    private static boolean isValidName(String name) {
        if (name.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (!MacroDef.isValidNameCharacter(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addConfiguredAttribute(Attribute attribute) {
        if (attribute.getName() == null) {
            throw new BuildException("the attribute nested element needed a \"name\" attribute");
        }
        this.attributes.add(attribute);
    }

    public void addConfiguredElement(TemplateElement element) {
        if (element.getName() == null) {
            throw new BuildException("the element nested element needed a \"name\" attribute");
        }
        this.elements.put(element.getName(), element);
    }

    public void execute() {
        if (this.nestedTask == null) {
            throw new BuildException("Missing nested element");
        }
        if (this.name == null) {
            throw new BuildException("Name not specified");
        }
        this.name = ProjectHelper.genComponentName(this.getURI(), this.name);
        MyAntTypeDefinition def = new MyAntTypeDefinition(this);
        def.setName(this.name);
        def.setClass(class$org$apache$tools$ant$taskdefs$MacroInstance == null ? (class$org$apache$tools$ant$taskdefs$MacroInstance = MacroDef.class$("org.apache.tools.ant.taskdefs.MacroInstance")) : class$org$apache$tools$ant$taskdefs$MacroInstance);
        ComponentHelper helper = ComponentHelper.getComponentHelper(this.getProject());
        helper.addDataTypeDefinition(def);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MacroDef other = (MacroDef)obj;
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.getURI() == null || this.getURI().equals("") || this.getURI().equals("ant:core") ? other.getURI() != null && !other.getURI().equals("") && !other.getURI().equals("ant:core") : !this.getURI().equals(other.getURI())) {
            return false;
        }
        if (!this.nestedTask.similar(other.nestedTask)) {
            return false;
        }
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        return this.elements.equals(other.elements);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MyAntTypeDefinition
    extends AntTypeDefinition {
        private MacroDef macroDef;

        public MyAntTypeDefinition(MacroDef macroDef) {
            this.macroDef = macroDef;
        }

        public Object create(Project project) {
            Object o = super.create(project);
            if (o == null) {
                return null;
            }
            ((MacroInstance)o).setMacroDef(this.macroDef);
            return o;
        }

        public boolean sameDefinition(AntTypeDefinition other, Project project) {
            if (!super.sameDefinition(other, project)) {
                return false;
            }
            MyAntTypeDefinition otherDef = (MyAntTypeDefinition)other;
            return this.macroDef.equals(otherDef.macroDef);
        }

        public boolean similarDefinition(AntTypeDefinition other, Project project) {
            if (!super.similarDefinition(other, project)) {
                return false;
            }
            MyAntTypeDefinition otherDef = (MyAntTypeDefinition)other;
            return this.macroDef.equals(otherDef.macroDef);
        }
    }

    public static class TemplateElement {
        private String name;
        private boolean optional = false;

        public void setName(String name) {
            if (!MacroDef.isValidName(name)) {
                throw new BuildException("Illegal name [" + name + "] for attribute");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            TemplateElement other = (TemplateElement)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.optional == other.optional;
        }
    }

    public static class Attribute {
        private String name;
        private String defaultValue;

        public void setName(String name) {
            if (!MacroDef.isValidName(name)) {
                throw new BuildException("Illegal name [" + name + "] for attribute");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDefault(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDefault() {
            return this.defaultValue;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Attribute other = (Attribute)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue));
        }
    }
}

