/*
 * Decompiled with CFR 0.152.
 */
package madkit.messages;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import madkit.kernel.Message;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLMessage
extends Message {
    protected Document doccontent = null;
    protected String strcontent = null;

    public XMLMessage(String string) {
        this.strcontent = string;
        this.doccontent = null;
    }

    public XMLMessage(Document document) {
        this.strcontent = null;
        this.doccontent = document;
    }

    public String getString() {
        if (this.strcontent != null) {
            return this.strcontent;
        }
        try {
            OutputFormat outputFormat = new OutputFormat(this.doccontent);
            StringWriter stringWriter = new StringWriter();
            outputFormat.setIndenting(true);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(this.doccontent);
            this.strcontent = stringWriter.toString();
            return this.strcontent;
        }
        catch (Exception exception) {
            System.err.println("XMLMessage Exception " + exception);
            return null;
        }
    }

    public Document getDocument() {
        if (this.doccontent != null) {
            return this.doccontent;
        }
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(new InputSource(new StringReader(this.strcontent)));
            this.doccontent = dOMParser.getDocument();
            return this.doccontent;
        }
        catch (Exception exception) {
            System.err.println("XMLMessage Exception " + exception);
            return null;
        }
    }

    public String toString() {
        if (this.strcontent != null) {
            return this.strcontent;
        }
        return this.doccontent.toString();
    }
}

