/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JPanel;
import madkit.system.AgentEvent;
import madkit.system.AgentSpy;
import madkit.system.GraphicGroupObserverGUIPane;

class GraphicBody
extends JPanel
implements MouseMotionListener,
MouseListener {
    GraphicGroupObserverGUIPane parent;

    public GraphicBody(GraphicGroupObserverGUIPane graphicGroupObserverGUIPane) {
        this.parent = graphicGroupObserverGUIPane;
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 0;
        for (Object object : this.parent.getListAgent()) {
            ((AgentSpy)object).paint(graphics2D, this.parent, n);
            ++n;
        }
        n = 0;
        for (Object object : this.parent.getListEvent()) {
            ((AgentEvent)object).paint(graphics2D, this.parent, n);
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        int n = Math.max(this.parent.getListAgent().size(), 1) * this.parent.getAgentWidth();
        int n2 = Math.max(this.parent.getListEvent().size(), 1) * this.parent.getStaticStep() + 2 * this.parent.getMargeY();
        return new Dimension(n, n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(this.parent.graphicLeft.getWidth(), 0);
        this.parent.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(this.parent.graphicLeft.getWidth(), 0);
        this.parent.mouseReleased(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(this.parent.graphicLeft.getWidth(), 0);
        this.parent.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = 0;
        Iterator iterator = this.parent.getListEvent().iterator();
        while (iterator.hasNext() && !bl) {
            AgentEvent agentEvent = (AgentEvent)iterator.next();
            if (agentEvent.contain(this.parent, n, mouseEvent.getX(), mouseEvent.getY())) {
                bl = true;
                this.parent.setCurrentEvent(agentEvent);
            }
            ++n;
        }
        if (!bl) {
            this.parent.setCurrentEvent(null);
        }
    }
}

