/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.probe;

import java.lang.reflect.Field;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import madkit.simulation.SimulationException;

public class SingleAgentProbe<A extends AbstractAgent, T>
extends Probe<A> {
    private final String fieldName;
    private Field field;
    private A probedAgent;

    public SingleAgentProbe(String community, String group, String role, String fieldName) {
        super(community, group, role);
        this.fieldName = fieldName;
    }

    @Override
    protected void adding(A agent) {
        if (this.field == null) {
            try {
                this.field = SingleAgentProbe.findFieldOn(agent.getClass(), this.fieldName);
                this.probedAgent = agent;
            }
            catch (NoSuchFieldException e) {
                throw new SimulationException(this.toString() + " on " + agent, e);
            }
        }
    }

    @Override
    protected void removing(A agent) {
        super.removing(agent);
        this.field = null;
    }

    public A getProbedAgent() {
        return this.probedAgent;
    }

    public T getPropertyValue() {
        try {
            return (T)this.field.get(this.probedAgent);
        }
        catch (IllegalAccessException e) {
            throw new SimulationException(this.toString() + " on " + this.probedAgent, e);
        }
    }

    @Override
    public String toString() {
        return super.toString() + (String)(this.probedAgent == null ? "" : " : " + this.probedAgent);
    }

    public void setPropertyValue(T value) {
        try {
            this.field.set(this.probedAgent, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SimulationException(this.toString() + " on " + this.probedAgent, e);
        }
    }
}

