/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import madkit.agr.OrganizationSnapshot;
import madkit.gui.AgentStatusPanel;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRSynchro;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelConnection;
import madkit.kernel.KernelServer;
import madkit.kernel.Madkit;
import madkit.kernel.Message;
import madkit.kernel.MultiCastListener;
import madkit.kernel.NetCode;
import madkit.kernel.NetworkMessage;
import madkit.message.EnumMessage;
import madkit.message.ObjectMessage;

final class NetworkAgent
extends Agent {
    private final ConcurrentHashMap<KernelAddress, KernelConnection> peers = new ConcurrentHashMap();
    private KernelServer myServer;
    private MultiCastListener multicastListener;
    private boolean running = true;

    NetworkAgent() {
    }

    @Override
    protected void activate() {
        this.setName(super.getName() + this.getKernelAddress());
        this.getLogger().setLevel(Madkit.LevelOption.networkLogLevel.getValue(this.getMadkitConfig()));
        this.requestRole("local", "network", "net agent");
        AgentAddress kernelAgent = this.getAgentWithRole("local", "network", "manager");
        this.myThread.setPriority(7);
        if (kernelAgent == null) {
            throw new AssertionError((Object)(this + " no kernel agent to work with... Please bug report"));
        }
        this.running = this.launchNetwork();
    }

    private boolean launchNetwork() {
        if (AbstractAgent.ReturnCode.SUCCESS != this.createGroup("NetworK", "MDK_net", true)) {
            return false;
        }
        this.requestRole("NetworK", "MDK_net", "MDK net agent");
        this.myServer = KernelServer.getNewKernelServer();
        if (this.myServer == null) {
            if (this.logger != null) {
                this.logger.warning(() -> "\n\t\t\t\t---- Unable to start the Madkit kernel server ------\n");
            }
            this.stopNetwork();
            return false;
        }
        this.myServer.activate(this);
        if (this.logger != null) {
            this.logger.config(() -> "\n\t\t\t\t----- MaDKit server activated on " + this.myServer + " ------\n");
        }
        try {
            this.multicastListener = MultiCastListener.getNewMultiCastListener(this.myServer.getPort());
            this.multicastListener.activate(this);
            if (this.logger != null) {
                this.logger.config(() -> "\n\t\t\t\t----- MaDKit MulticastListener activated on " + MultiCastListener.ipAddress + " ------\n");
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning(() -> "\n\t\t\t\t---- Unable to start a Multicast Listener " + e.getClass().getName() + " " + e.getMessage() + " ------\n");
            }
            this.stopNetwork();
            return false;
        }
        Message m = null;
        ArrayList<Message> toDoList = new ArrayList<Message>();
        do {
            if (this.logger != null) {
                this.logger.finest("Waiting for some connections first");
            }
            if ((m = this.waitNextMessage(400L)) == null) continue;
            if (m.getSender() == null && m instanceof NetworkMessage && ((NetworkMessage)m).getCode() == NetCode.NEW_PEER_REQUEST) {
                this.newPeerRequest((Socket)((Object[])((NetworkMessage)m).getContent())[0]);
                continue;
            }
            toDoList.add(m);
        } while (m != null);
        if (this.logger != null) {
            this.logger.finest(() -> "Now purge mailbox");
        }
        for (Message message : toDoList) {
            this.handleMessage(message);
        }
        if (this.logger != null) {
            this.logger.finest(() -> "Now activating all connections");
        }
        for (KernelConnection kc : this.peers.values()) {
            if (kc.isActivated()) continue;
            kc.start();
        }
        AgentStatusPanel.updateAll();
        if (this.logger != null) {
            this.logger.info(() -> "\n\t\t\t\t----- " + this.getKernelAddress() + " network started on " + this.myServer + " ------\n");
        }
        return true;
    }

    @Override
    protected void live() {
        while (this.isAlive() && this.running) {
            this.handleMessage(this.waitNextMessage());
        }
    }

    @Override
    protected void end() {
        this.stopNetwork();
    }

    private void stopNetwork() {
        if (this.logger != null) {
            this.logger.info(() -> "\n\t\t\t\t----- " + this.getKernelAddress() + " network closed ------\n");
            this.logger.finer(() -> "Closing all connections : " + this.peers.values());
        }
        for (Map.Entry<KernelAddress, KernelConnection> entry : this.peers.entrySet()) {
            this.peerDeconnected(entry.getKey());
            entry.getValue().closeConnection();
        }
        this.peers.clear();
        if (this.logger != null) {
            this.logger.finer(() -> "Closing multicast listener and kernel server");
        }
        if (this.multicastListener != null) {
            this.multicastListener.stop();
        }
        if (this.myServer != null) {
            this.myServer.stop();
            this.myServer = null;
        }
        this.leaveGroup("NetworK", "MDK_net");
        AgentStatusPanel.updateAll();
    }

    private void handleMessage(Message m) throws ClassCastException {
        AgentAddress sender = m.getSender();
        if (sender == null) {
            this.proceedEnumMessage((EnumMessage)m);
        } else if (sender.isFrom(this.getKernelAddress())) {
            switch (sender.getRole()) {
                case "updater": {
                    this.broadcastUpdate(m);
                    break;
                }
                case "emmiter": {
                    this.sendDistantMessage((ObjectMessage)m);
                    break;
                }
                case "kernel": {
                    this.proceedEnumMessage((EnumMessage)m);
                    break;
                }
                default: {
                    this.getLogger().severeLog("not understood :\n" + m);
                    break;
                }
            }
        } else {
            switch (sender.getRole()) {
                case "updater": {
                    if (this.logger != null) {
                        CGRSynchro synchro = (CGRSynchro)m;
                        this.logger.finer(() -> "Injecting distant CGR " + synchro.getCode() + " on " + synchro.getContent());
                    }
                    this.getMadkitKernel().injectOperation((CGRSynchro)m);
                    break;
                }
                case "emmiter": {
                    if (this.logger != null) {
                        this.logger.finer(() -> "Injecting distant message " + this.getState() + " : " + m);
                    }
                    this.getMadkitKernel().injectMessage((ObjectMessage)m);
                    break;
                }
                default: {
                    this.getLogger().severeLog("not understood :\n" + m);
                }
            }
        }
    }

    private void exit() {
        this.running = false;
    }

    private void peerDeconnected(KernelAddress ka) {
        if (this.peers.remove(ka) != null) {
            if (this.logger != null) {
                this.logger.info(() -> "\n\t\t\t\t----- " + this.getKernelAddress() + " deconnected from " + ka + "------\n");
            }
            this.getMadkitKernel().removeAgentsFromDistantKernel(ka);
        }
    }

    private void newPeerRequest(Socket s) {
        KernelConnection kc;
        if (this.logger != null) {
            this.logger.fine("Contacted by peer " + s + " -> opening kernel connection");
        }
        try {
            kc = new KernelConnection(this, s);
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning(() -> "I give up: Unable to contact peer on " + s + " because " + e.getMessage());
            }
            return;
        }
        if (this.logger != null) {
            this.logger.finer(() -> "KC opened: " + kc + "\n\tsending connection INFO");
        }
        if (this.sendingConnectionInfo(kc)) {
            KernelAddress dka;
            if (this.logger != null) {
                this.logger.fine(() -> "Connection info sent, now waiting reply from " + kc.getDistantKernelSocket() + "...");
            }
            if ((dka = this.gettingConnectionInfo(kc)) != null) {
                this.addConnection(dka, kc, this.getState().equals((Object)AbstractAgent.State.LIVING));
            }
        }
    }

    private void addConnection(KernelAddress ka, KernelConnection kc, boolean startConnection) {
        this.peers.put(ka, kc);
        if (this.logger != null) {
            this.logger.info(() -> "\n\t\t\t\t----- " + this.getKernelAddress() + " now connected with " + kc.getKernelAddress() + "------\n");
        }
        if (startConnection) {
            kc.start();
        }
    }

    private void newPeerDetected(DatagramPacket packet) {
        KernelConnection kc;
        if (this.logger != null) {
            this.logger.fine(() -> "Contacting peer: " + packet.getAddress() + " port = " + packet.getPort() + "\n\t-> opening KernelConnection");
        }
        try {
            kc = new KernelConnection(this, packet.getAddress(), packet.getPort());
            if (this.logger != null) {
                this.logger.finer(() -> "KC created " + kc);
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning(() -> "Unable to contact peer: " + packet.getAddress() + " port = " + packet.getPort() + " because " + e.getMessage());
            }
            return;
        }
        KernelAddress dka = this.gettingConnectionInfo(kc);
        if (dka != null) {
            if (this.logger != null) {
                this.logger.finer(() -> "Now replying to " + dka);
            }
            if (this.sendingConnectionInfo(kc)) {
                this.addConnection(dka, kc, this.getState().equals((Object)AbstractAgent.State.LIVING));
            }
        }
    }

    private void connectToIp(InetAddress ipAddress) throws IOException {
        if (!ipAddress.equals(this.myServer.getIp())) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeLong(System.nanoTime());
            dos.close();
            this.newPeerDetected(new DatagramPacket(bos.toByteArray(), 8, ipAddress, 4444));
        }
    }

    private KernelAddress gettingConnectionInfo(KernelConnection kc) {
        if (this.logger != null) {
            this.logger.finest(() -> "Waiting distant kernel address...");
        }
        KernelAddress dka = null;
        try {
            dka = kc.waitForDistantKernelAddress();
            if (this.logger != null) {
                this.logger.finest("... Distant Kernel Address is " + dka + "\nWaiting distant organization info...");
            }
            this.kernel.getMadkitKernel().importDistantOrg(this.cleanUp(kc.waitForDistantOrg(), dka));
            return dka;
        }
        catch (IOException | ClassNotFoundException e) {
            if (dka == null) {
                this.getLogger().severeLog("I give up: Unable to get distant kernel address info on " + kc, e);
            } else {
                this.getLogger().severeLog("I give up: Unable to get distant organization from " + dka, e);
            }
            return null;
        }
    }

    private boolean sendingConnectionInfo(KernelConnection kc) {
        if (this.logger != null) {
            this.logger.fine(() -> "Sending connection info to " + (kc.getKernelAddress() == null ? kc.getDistantKernelSocket() : kc.getKernelAddress()));
            this.logger.finer(() -> "Local org is\n\n" + this.getOrganizationSnapShot(false) + "\n");
        }
        try {
            kc.sendConnectionInfo(this.getKernelAddress(), this.getOrganizationSnapShot(false));
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning(() -> "I give up: Unable to send connection info to " + (kc.getKernelAddress() == null ? kc.getDistantKernelSocket() : kc.getKernelAddress()) + " because " + e.getMessage());
            }
            return false;
        }
        return true;
    }

    private OrganizationSnapshot cleanUp(OrganizationSnapshot organizationSnapshot, KernelAddress from) {
        Iterator iterator = organizationSnapshot.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry org = iterator.next();
            Iterator iterator2 = ((Map)org.getValue()).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry group = iterator2.next();
                Iterator iterator3 = ((Map)group.getValue()).entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry role = iterator3.next();
                    Iterator iterator4 = ((Set)role.getValue()).iterator();
                    while (iterator4.hasNext()) {
                        KernelAddress dka = ((AgentAddress)iterator4.next()).getKernelAddress();
                        if (from.equals(dka) || this.peers.containsKey(dka)) continue;
                        iterator4.remove();
                    }
                    if (!((Set)role.getValue()).isEmpty()) continue;
                    iterator3.remove();
                }
                if (!((Map)group.getValue()).isEmpty()) continue;
                iterator2.remove();
            }
            if (!((Map)org.getValue()).isEmpty()) continue;
            iterator.remove();
        }
        return organizationSnapshot;
    }

    private void broadcastUpdate(Message message) {
        if (this.logger != null) {
            this.logger.finer(() -> "Local CGR update\nBroadcasting  to " + this.peers.values() + message);
        }
        for (KernelConnection kc : this.peers.values()) {
            kc.sendMessage(message);
        }
    }

    private void sendDistantMessage(ObjectMessage<Message> m) {
        KernelConnection kc;
        if (this.logger != null) {
            this.logger.finer(() -> "sending to " + ((Message)m.getContent()).getReceiver().getKernelAddress() + m);
        }
        if ((kc = this.peers.get(m.getContent().getReceiver().getKernelAddress())) != null) {
            kc.sendMessage(m);
        }
    }

    @Override
    public String getServerInfo() {
        if (this.myServer != null) {
            return this.myServer.toString();
        }
        return "";
    }
}

