/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.Arrays;
import java.util.List;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRNotAvailable;
import madkit.kernel.Gatekeeper;
import madkit.kernel.MadkitKernel;
import madkit.kernel.MadkitWarning;
import madkit.kernel.Message;
import madkit.kernel.OrganizationWarning;
import madkit.kernel.Overlooker;

final class LoggedKernel
extends MadkitKernel {
    LoggedKernel(MadkitKernel k) {
        super(k);
        this.loggedKernel = this;
    }

    @Override
    AbstractAgent.ReturnCode createGroup(AbstractAgent requester, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        AbstractAgent.ReturnCode r = this.kernel.createGroup(requester, community, group, gatekeeper, isDistributed);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            requester.logger.finest(() -> AbstractAgent.Influence.CREATE_GROUP.successString() + I18nUtilities.getCGRString(community, group) + "distribution " + (isDistributed ? "ON" : "OFF") + " with " + (String)(gatekeeper == null ? "no access control " : gatekeeper.toString() + " as gatekeeper "));
        } else {
            requester.handleWarning(AbstractAgent.Influence.CREATE_GROUP, () -> new OrganizationWarning(r, community, group, null));
        }
        return r;
    }

    @Override
    boolean createGroupIfAbsent(AbstractAgent requester, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        requester.logger.finest(() -> "createGroupIfAbsent " + I18nUtilities.getCGRString(community, group) + "distribution " + (isDistributed ? "ON" : "OFF") + " with " + (String)(gatekeeper == null ? "no access control" : gatekeeper.toString() + " for access control"));
        return this.kernel.createGroup(requester, community, group, gatekeeper, isDistributed) == AbstractAgent.ReturnCode.SUCCESS;
    }

    @Override
    AbstractAgent.ReturnCode requestRole(AbstractAgent requester, String community, String group, String role, Object memberCard) {
        AbstractAgent.ReturnCode r = this.kernel.requestRole(requester, community, group, role, memberCard);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            requester.logger.finest(() -> AbstractAgent.Influence.REQUEST_ROLE.successString() + I18nUtilities.getCGRString(community, group, role) + "using " + memberCard + " as passKey");
        } else {
            requester.handleWarning(AbstractAgent.Influence.REQUEST_ROLE, () -> new OrganizationWarning(r, community, group, role));
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode leaveGroup(AbstractAgent requester, String community, String group) {
        AbstractAgent.ReturnCode r = this.kernel.leaveGroup(requester, community, group);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            requester.logger.finest(() -> AbstractAgent.Influence.LEAVE_GROUP.successString() + I18nUtilities.getCGRString(community, group));
        } else {
            requester.handleWarning(AbstractAgent.Influence.LEAVE_GROUP, () -> new OrganizationWarning(r, community, group, null));
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode leaveRole(AbstractAgent requester, String community, String group, String role) {
        AbstractAgent.ReturnCode r = this.kernel.leaveRole(requester, community, group, role);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            requester.logger.finest(() -> AbstractAgent.Influence.LEAVE_ROLE.successString() + I18nUtilities.getCGRString(community, group, role));
        } else {
            requester.handleWarning(AbstractAgent.Influence.LEAVE_ROLE, () -> new OrganizationWarning(r, community, group, role));
        }
        return r;
    }

    @Override
    List<AgentAddress> getAgentsWithRole(AbstractAgent requester, String community, String group, String role, boolean callerIncluded) {
        try {
            List<AgentAddress> result = callerIncluded ? this.kernel.getRole(community, group, role).getAgentAddressesCopy() : this.kernel.getOtherRolePlayers(requester, community, group, role);
            requester.logger.finest(() -> AbstractAgent.Influence.GET_AGENTS_WITH_ROLE + I18nUtilities.getCGRString(community, group, role) + ": " + result);
            return result;
        }
        catch (CGRNotAvailable e) {
            requester.handleWarning(AbstractAgent.Influence.GET_AGENTS_WITH_ROLE, () -> new OrganizationWarning(e.getCode(), community, group, role));
            return null;
        }
    }

    @Override
    AgentAddress getAgentWithRole(AbstractAgent requester, String community, String group, String role) {
        try {
            AgentAddress result = this.kernel.getAnotherRolePlayer(requester, community, group, role);
            requester.logger.finest(() -> AbstractAgent.Influence.GET_AGENT_WITH_ROLE + I18nUtilities.getCGRString(community, group, role) + ": " + result);
            return result;
        }
        catch (CGRNotAvailable e) {
            requester.handleWarning(AbstractAgent.Influence.GET_AGENT_WITH_ROLE, () -> new OrganizationWarning(e.getCode(), community, group, role));
            return null;
        }
    }

    @Override
    AgentAddress getAgentAddressIn(AbstractAgent agent, String community, String group, String role) {
        AgentAddress aa = this.kernel.getAgentAddressIn(agent, community, group, role);
        if (aa == null && this.isRole(community, group, role)) {
            agent.handleWarning(AbstractAgent.Influence.GET_AGENT_ADDRESS_IN, () -> new OrganizationWarning(AbstractAgent.ReturnCode.ROLE_NOT_HANDLED, community, group, role));
        }
        return aa;
    }

    @Override
    AbstractAgent.ReturnCode broadcastMessageWithRole(AbstractAgent requester, String community, String group, String role, Message messageToSend, String senderRole) {
        AbstractAgent.ReturnCode r = this.kernel.broadcastMessageWithRole(requester, community, group, role, messageToSend, senderRole);
        switch (r) {
            case SUCCESS: {
                requester.logger.finest(() -> AbstractAgent.Influence.BROADCAST_MESSAGE + "-> " + I18nUtilities.getCGRString(community, group, role) + (String)(senderRole == null ? "" : " with role " + senderRole) + messageToSend);
                return AbstractAgent.ReturnCode.SUCCESS;
            }
            case NO_RECIPIENT_FOUND: {
                requester.handleWarning(AbstractAgent.Influence.BROADCAST_MESSAGE, () -> new MadkitWarning(r));
                break;
            }
            case ROLE_NOT_HANDLED: {
                requester.handleWarning(AbstractAgent.Influence.BROADCAST_MESSAGE, () -> new OrganizationWarning(r, community, group, senderRole));
                break;
            }
            default: {
                requester.handleWarning(AbstractAgent.Influence.BROADCAST_MESSAGE, () -> new OrganizationWarning(r, community, group, role));
            }
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, AgentAddress receiver, Message messageToSend, String senderRole) {
        AbstractAgent.ReturnCode r = this.kernel.sendMessage(requester, receiver, messageToSend, senderRole);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            requester.logger.finest(() -> AbstractAgent.Influence.SEND_MESSAGE.successString() + " " + messageToSend);
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (r == AbstractAgent.ReturnCode.NOT_IN_GROUP || r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
            requester.handleWarning(AbstractAgent.Influence.SEND_MESSAGE, () -> new OrganizationWarning(r, receiver.getCommunity(), receiver.getGroup(), senderRole));
        } else {
            requester.handleWarning(AbstractAgent.Influence.SEND_MESSAGE, () -> new MadkitWarning(r));
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, String community, String group, String role, Message messageToSend, String senderRole) {
        AbstractAgent.ReturnCode r = this.kernel.sendMessage(requester, community, group, role, messageToSend, senderRole);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            requester.logger.finest(() -> (messageToSend.getReceiver().isFrom(requester.getKernelAddress()) ? AbstractAgent.Influence.SEND_MESSAGE.successString() : AbstractAgent.Influence.SEND_MESSAGE.toString()) + "->" + I18nUtilities.getCGRString(community, group, role) + " " + messageToSend);
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (r == AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND) {
            requester.handleWarning(AbstractAgent.Influence.SEND_MESSAGE, () -> new MadkitWarning(r));
        } else if (r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
            requester.handleWarning(AbstractAgent.Influence.SEND_MESSAGE, () -> new OrganizationWarning(r, community, group, senderRole));
        } else {
            requester.handleWarning(AbstractAgent.Influence.SEND_MESSAGE, () -> new OrganizationWarning(r, community, group, role));
        }
        return r;
    }

    @Override
    List<Message> broadcastMessageWithRoleAndWaitForReplies(AbstractAgent requester, String community, String group, String role, Message message, String senderRole, Integer timeOutMilliSeconds) {
        List<Message> result = this.kernel.broadcastMessageWithRoleAndWaitForReplies(requester, community, group, role, message, senderRole, timeOutMilliSeconds);
        requester.logger.finest(() -> AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT + ": received: " + result);
        return result;
    }

    @Override
    void launchAgentBucketWithRoles(AbstractAgent requester, List<AbstractAgent> bucket, int cpuCoreNb, String ... CGRLocations) {
        requester.logger.finest(() -> "launchAgentBucketWithRoles : " + bucket.size() + " " + (!bucket.isEmpty() ? ((AbstractAgent)bucket.get(0)).getClass().getName() : "agents !!!") + " " + (CGRLocations.length > 0 ? Arrays.deepToString(CGRLocations) : ""));
        this.kernel.launchAgentBucketWithRoles(requester, bucket, cpuCoreNb, CGRLocations);
        requester.logger.finest(() -> "launchAgentBucketWithRoles Done !");
    }

    @Override
    final AbstractAgent.ReturnCode launchAgent(AbstractAgent requester, AbstractAgent agent, int timeOutSeconds, boolean defaultGUI) {
        requester.getLogger().finest(() -> AbstractAgent.Influence.LAUNCH_AGENT + " (" + timeOutSeconds + ")" + agent.getName() + "...");
        AbstractAgent.ReturnCode r = this.kernel.launchAgent(requester, agent, timeOutSeconds, defaultGUI);
        if (r == AbstractAgent.ReturnCode.SUCCESS || r == AbstractAgent.ReturnCode.TIMEOUT) {
            requester.logger.finest(() -> AbstractAgent.Influence.LAUNCH_AGENT.toString() + agent + " " + r);
        } else {
            requester.handleWarning(AbstractAgent.Influence.LAUNCH_AGENT, () -> new MadkitWarning(agent.toString(), r));
        }
        return r;
    }

    @Override
    final AbstractAgent.ReturnCode killAgent(AbstractAgent requester, AbstractAgent target, int timeOutSeconds) {
        requester.logger.finest(() -> AbstractAgent.Influence.KILL_AGENT + " (" + timeOutSeconds + ")" + target + "...");
        AbstractAgent.ReturnCode r = this.kernel.killAgent(requester, target, timeOutSeconds);
        if (r == AbstractAgent.ReturnCode.SUCCESS || r == AbstractAgent.ReturnCode.TIMEOUT) {
            requester.logger.finest(() -> AbstractAgent.Influence.KILL_AGENT + target.getName() + " " + r);
        } else {
            requester.handleWarning(AbstractAgent.Influence.KILL_AGENT, () -> new MadkitWarning(target.toString(), r));
        }
        return r;
    }

    @Override
    boolean isCommunity(AbstractAgent requester, String community) {
        boolean fact = this.kernel.isCommunity(requester, community);
        requester.logger.finest(() -> Words.COMMUNITY + " ? " + I18nUtilities.getCGRString(community) + fact);
        return fact;
    }

    @Override
    boolean isGroup(AbstractAgent requester, String community, String group) {
        boolean fact = this.kernel.isGroup(requester, community, group);
        requester.logger.finest(() -> Words.GROUP + " ? " + I18nUtilities.getCGRString(community, group) + fact);
        return fact;
    }

    @Override
    boolean isRole(AbstractAgent requester, String community, String group, String role) {
        boolean fact = this.kernel.isRole(requester, community, group, role);
        requester.logger.finest(() -> Words.ROLE + " ? " + I18nUtilities.getCGRString(community, group, role) + fact);
        return fact;
    }

    @Override
    MadkitKernel getMadkitKernel() {
        return this.kernel;
    }

    @Override
    synchronized boolean removeOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        boolean added = this.kernel.removeOverlooker(requester, o);
        requester.logger.finest(() -> o.getClass().getSimpleName() + (added ? " removed" : " not added") + o);
        return added;
    }

    @Override
    synchronized boolean addOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        boolean added = this.kernel.addOverlooker(requester, o);
        requester.logger.finest(() -> o.getClass().getSimpleName() + (added ? " OK" : " already added") + o);
        return added;
    }
}

