/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.io.PrintStream;
import madkit.action.KernelAction;
import madkit.gui.AgentFrame;
import madkit.gui.OutputPanel;
import madkit.gui.StreamCapturer;
import madkit.kernel.AbstractAgent;

public class ConsoleAgent
extends AbstractAgent {
    private static final PrintStream systemOut = System.out;
    private static final PrintStream systemErr = System.err;

    public ConsoleAgent() {
        this.createGUIOnStartUp();
    }

    @Override
    public void setupFrame(AgentFrame frame) {
        OutputPanel outP = new OutputPanel(this);
        frame.setContentPane(outP);
        frame.setIconImage(KernelAction.CONSOLE.getActionInfo().getBigIcon().getImage());
        System.setOut(new PrintStream(new StreamCapturer(outP, systemOut)));
        System.setErr(new PrintStream(new StreamCapturer(outP, systemErr)));
        frame.setSize(800, 500);
    }

    @Override
    protected void end() {
        System.setErr(systemErr);
        System.setOut(systemOut);
    }
}

