/*
 * Decompiled with CFR 0.152.
 */
package madkit.bees;

import java.awt.Point;
import java.util.Random;
import madkit.bees.BeeEnvironment;
import madkit.bees.BeeInformation;
import madkit.kernel.AbstractAgent;

public abstract class AbstractBee
extends AbstractAgent {
    protected static final Random generator = new Random(System.currentTimeMillis());
    protected int dX;
    protected int dY;
    protected BeeEnvironment beeWorld;
    protected BeeInformation myInformation = new BeeInformation();

    public void setEnvironment(BeeEnvironment environment) {
        this.beeWorld = environment;
        Point myLocation = this.myInformation.getCurrentPosition();
        if (myLocation.x > this.beeWorld.getWidth() || myLocation.y > this.beeWorld.getHeight() || myLocation.x <= 0 || myLocation.y <= 0) {
            myLocation.setLocation(generator.nextInt(this.beeWorld.getWidth() - 20) + 10, generator.nextInt(this.beeWorld.getHeight() - 20) + 10);
            this.myInformation.getPreviousPosition().setLocation(myLocation);
        }
        int beeMAcceleration = this.beeWorld.getBeeAcceleration().getValue();
        this.dX = this.randomFromRange(beeMAcceleration);
        this.dY = this.randomFromRange(beeMAcceleration);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " on " + this.beeWorld + " " + this.myInformation;
    }

    protected void buzz() {
        Point location = this.myInformation.getCurrentPosition();
        this.myInformation.getPreviousPosition().setLocation(location);
        this.computeNewVelocities();
        this.normalizeVelocities(this.getMaxVelocity());
        location.x += this.dX;
        location.y += this.dY;
    }

    protected abstract int getMaxVelocity();

    protected abstract void computeNewVelocities();

    private void normalizeVelocities(int maxVelocity) {
        if (this.dX > maxVelocity) {
            this.dX = maxVelocity;
        } else if (this.dX < -maxVelocity) {
            this.dX = -maxVelocity;
        }
        if (this.dY > maxVelocity) {
            this.dY = maxVelocity;
        } else if (this.dY < -maxVelocity) {
            this.dY = -maxVelocity;
        }
    }

    public int randomFromRange(int val) {
        return generator.nextInt((val /= 2) * 2 + 1) - val;
    }
}

