/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JOptionPane;
import madkit.action.ActionInfo;
import madkit.action.KernelAction;
import madkit.action.MDKAbstractAction;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.message.GUIMessage;
import madkit.message.KernelMessage;

public enum GUIManagerAction {
    CONNECT_TO_IP(78),
    ICONIFY_ALL(77),
    DEICONIFY_ALL(73),
    KILL_AGENTS(71),
    SETUP_AGENT_GUI(515),
    DISPOSE_AGENT_GUI(515);

    private static final ResourceBundle messages;
    private final int keyEvent;
    private ActionInfo actionInfo;

    private GUIManagerAction(int keyEvent) {
        this.keyEvent = keyEvent;
    }

    public Action getActionFor(final AbstractAgent agent, final Object ... commandOptions) {
        if (this == CONNECT_TO_IP) {
            return new MDKAbstractAction(this.getActionInfo()){
                private static final long serialVersionUID = -5716094161691491218L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (agent.isAlive()) {
                        try {
                            String ip = JOptionPane.showInputDialog(null, (Object)(GUIManagerAction.this.getActionInfo().getName() + " : "));
                            if (ip != null) {
                                agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.CONNECT_TO_IP, InetAddress.getByName(ip)));
                            }
                        }
                        catch (HeadlessException e1) {
                            e1.printStackTrace();
                        }
                        catch (UnknownHostException e1) {
                            JOptionPane.showMessageDialog(null, e1, Words.FAILED.toString(), 2);
                        }
                    }
                }
            };
        }
        return new MDKAbstractAction(this.getActionInfo()){
            private static final long serialVersionUID = 2231685794614332333L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (agent.isAlive()) {
                    GUIMessage m = new GUIMessage(GUIManagerAction.this, commandOptions);
                    AgentAddress guiManager = agent.getAgentWithRole("local", "gui", "manager");
                    if (guiManager != null) {
                        agent.sendMessage(guiManager, m);
                    } else {
                        agent.receiveMessage(m);
                    }
                }
            }
        };
    }

    public ActionInfo getActionInfo() {
        if (this.actionInfo == null) {
            this.actionInfo = new ActionInfo(this, this.keyEvent, messages);
        }
        return this.actionInfo;
    }

    static {
        messages = I18nUtilities.getResourceBundle(GUIManagerAction.class.getSimpleName());
    }
}

