/*
 * Decompiled with CFR 0.152.
 */
package madkit.pingpong;

import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JPanel;
import madkit.gui.AgentFrame;
import madkit.gui.OutputPanel;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Madkit;
import madkit.message.ObjectMessage;

public class PingPong
extends Agent {
    private AgentAddress currentPartner = null;
    private ObjectMessage<Color> ball = null;
    private JPanel myPanel;
    private JFrame myFrame;

    @Override
    public void activate() {
        this.createGroupIfAbsent("ping-pong", "room", true, null);
        this.requestRole("ping-pong", "room", "player", null);
    }

    @Override
    public void live() {
        while (this.isAlive()) {
            this.searching();
            this.playing();
        }
    }

    private void searching() {
        this.currentPartner = null;
        this.changeGUIColor(Color.WHITE);
        this.ball = null;
        while (this.currentPartner == null) {
            this.ball = (ObjectMessage)this.waitNextMessage(1000L);
            if (this.ball != null) {
                this.currentPartner = this.ball.getSender();
                continue;
            }
            this.currentPartner = this.getAgentWithRole("ping-pong", "room", "player");
        }
        this.getLogger().info("I found someone to play with : " + this.currentPartner + " !!! ");
    }

    private void playing() {
        Color ballColor;
        if (this.ball == null) {
            ballColor = this.getRandomColor();
            this.ball = (ObjectMessage)this.sendMessageAndWaitForReply(this.currentPartner, new ObjectMessage<Color>(ballColor), 1300);
            if (this.ball == null) {
                this.getLogger().info(this.currentPartner + " did not reply to me :( !! ");
                this.currentPartner = null;
                return;
            }
        } else {
            ballColor = this.ball.getContent();
        }
        this.changeGUIColor(ballColor);
        ObjectMessage<Color> ballMessage = new ObjectMessage<Color>(ballColor);
        for (int i = 0; i < 10; ++i) {
            this.ball = (ObjectMessage)this.sendReplyAndWaitForReply(this.ball, ballMessage, 1300);
            if (this.ball == null) {
                this.getLogger().info(this.currentPartner + " is gone :( !! ");
                break;
            }
            this.getLogger().info(" Playing :) with " + this.currentPartner + " ball nb is " + i);
            this.pause((int)(Math.random() * 1000.0));
        }
        this.purgeMailbox();
    }

    @Override
    public void setupFrame(AgentFrame frame) {
        this.myPanel = new OutputPanel(this);
        frame.add(this.myPanel);
        this.myFrame = frame;
    }

    private void changeGUIColor(Color c) {
        if (this.myPanel != null) {
            this.myPanel.setBackground(c);
        }
    }

    public void setFrameLocation(int x, int y) {
        if (this.myFrame != null) {
            this.myFrame.setLocation(x, y);
        }
    }

    private Color getRandomColor() {
        return new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
    }

    public static void main(String[] args) {
        String[] argss = new String[]{"--network", "--launchAgents", PingPong.class.getName(), ",true"};
        Madkit.main(argss);
    }
}

