/*
 * Decompiled with CFR 0.152.
 */
package madkit.message;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import madkit.kernel.Message;

public class ObjectMessage<T>
extends Message {
    private static final long serialVersionUID = 2061462024105569662L;
    private final T content;

    public ObjectMessage(T content) {
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public static <T, M extends ObjectMessage<T>> M max(Collection<M> messageCollection) {
        Iterator<M> i = messageCollection.iterator();
        ObjectMessage candidate = (ObjectMessage)i.next();
        while (i.hasNext()) {
            ObjectMessage next = (ObjectMessage)i.next();
            if (((Comparable)next.getContent()).compareTo(candidate.getContent()) <= 0) continue;
            candidate = next;
        }
        return (M)candidate;
    }

    public static <T, M extends ObjectMessage<T>> M min(Collection<M> messageCollection) {
        Iterator<M> i = messageCollection.iterator();
        ObjectMessage candidate = (ObjectMessage)i.next();
        while (i.hasNext()) {
            ObjectMessage next = (ObjectMessage)i.next();
            if (((Comparable)next.getContent()).compareTo(candidate.getContent()) >= 0) continue;
            candidate = next;
        }
        return (M)candidate;
    }

    public static <T, M extends ObjectMessage<T>> void sort(List<M> list) {
        Object[] a = list.toArray();
        Arrays.sort(a);
        ListIterator<M> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set((ObjectMessage)a[j]);
        }
    }

    @Override
    public String toString() {
        Object s = super.toString();
        s = (String)s + "\n" + (this.getClass().getSimpleName() + this.getConversationID()).replaceAll(".", " ");
        return (String)s + "    content: {" + this.content + "}";
    }
}

