/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import madkit.agr.OrganizationSnapshot;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;
import madkit.kernel.NetCode;
import madkit.kernel.NetworkAgent;
import madkit.kernel.NetworkMessage;

final class KernelConnection
extends Thread {
    private final Socket distantKernelSocket;
    private boolean activated = false;
    private final NetworkAgent myNetAgent;
    private KernelAddress distantKernelAddress;
    private final ObjectOutputStream oos;
    private final ObjectInputStream ois;

    boolean isActivated() {
        return this.activated;
    }

    Socket getDistantKernelSocket() {
        return this.distantKernelSocket;
    }

    KernelAddress getKernelAddress() {
        return this.distantKernelAddress;
    }

    public KernelConnection(NetworkAgent netAgent, InetAddress address, int port) throws IOException {
        this(netAgent, new Socket(address, port));
    }

    public KernelConnection(NetworkAgent netAgent, Socket kernelClient) throws IOException {
        this.myNetAgent = netAgent;
        this.distantKernelSocket = kernelClient;
        this.oos = new ObjectOutputStream(this.distantKernelSocket.getOutputStream());
        this.ois = new ObjectInputStream(this.distantKernelSocket.getInputStream());
    }

    OrganizationSnapshot waitForDistantOrg() throws IOException, ClassNotFoundException {
        return (OrganizationSnapshot)this.ois.readObject();
    }

    KernelAddress waitForDistantKernelAddress() throws IOException, ClassNotFoundException {
        this.distantKernelAddress = (KernelAddress)this.ois.readObject();
        return this.distantKernelAddress;
    }

    void sendConnectionInfo(KernelAddress myKA, OrganizationSnapshot map) throws IOException {
        this.oos.writeObject(myKA);
        this.oos.writeObject(map);
    }

    @Override
    public void run() {
        this.activated = true;
        while (this.distantKernelSocket.isConnected()) {
            try {
                this.myNetAgent.receiveMessage((Message)this.ois.readObject());
            }
            catch (ClassNotFoundException e) {
                this.myNetAgent.getLogger().log(Level.SEVERE, "Unable to deserialize object", e);
            }
            catch (IOException e) {
                this.logIOException(e);
                break;
            }
        }
        this.myNetAgent.receiveMessage(new NetworkMessage(NetCode.PEER_DECONNECTED, this.distantKernelAddress));
        this.closeConnection();
    }

    private void logIOException(IOException e) {
        if (e instanceof SocketException || e instanceof EOFException) {
            this.myNetAgent.getLogger().log(Level.FINEST, " socket closed on " + this.distantKernelAddress, e);
        } else {
            this.myNetAgent.getLogger().severeLog("io problem", e);
        }
    }

    synchronized void sendMessage(Message m) {
        try {
            this.oos.writeObject(m);
        }
        catch (IOException e) {
            this.logIOException(e);
        }
    }

    synchronized void closeConnection() {
        try {
            this.oos.close();
            this.ois.close();
            this.distantKernelSocket.close();
        }
        catch (IOException e) {
            this.myNetAgent.getLogger().log(Level.FINE, "", e);
        }
    }

    @Override
    public String toString() {
        return this.getInetAddress().getHostAddress() + " dka = " + (Serializable)(this.distantKernelAddress == null ? "NA" : this.distantKernelAddress);
    }

    public int getPort() {
        return this.distantKernelSocket.getPort();
    }

    public InetAddress getInetAddress() {
        return this.distantKernelSocket.getInetAddress();
    }
}

