/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.action.SchedulingAction;
import madkit.gui.AgentFrame;
import madkit.gui.SwingUtil;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.ActivatorComparator;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.SimulationTimeJLabel;
import madkit.message.SchedulingMessage;

public class Scheduler
extends Agent {
    private static final Preferences SCHEDULER_UI_PREFERENCES = Preferences.userRoot().node(Scheduler.class.getName());
    private final List<Activator<? extends AbstractAgent>> activators = new ArrayList<Activator<? extends AbstractAgent>>();
    private static final ActivatorComparator activatorComparator = new ActivatorComparator();
    private SimulationState simulationState = SimulationState.PAUSED;
    private Action run;
    private Action step;
    private Action speedUp;
    private Action speedDown;
    private int delay;
    private final DefaultBoundedRangeModel speedModel = new DefaultBoundedRangeModel(400, 0, 0, 400){

        @Override
        public void setValue(int n) {
            super.setValue(n);
            Scheduler.this.delay = 400 - this.getValue();
            SCHEDULER_UI_PREFERENCES.putInt(Scheduler.this.getName() + "speed", this.getValue());
        }
    };
    private SimulationTimeModel gvtModel;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.speedModel.setValue(this.speedModel.getMaximum() - delay);
    }

    public double getGVT() {
        return this.getSimulationTime().getCurrentTick().doubleValue();
    }

    public void setGVT(double value) {
        this.getSimulationTime().setCurrentTick(value);
    }

    public Scheduler() {
        this.setSimulationTime(new TickBasedTime());
        this.buildActions();
    }

    public Scheduler(double endTick) {
        this();
        this.getSimulationTime().setEndTick(BigDecimal.valueOf(endTick));
    }

    public Scheduler(LocalDateTime initialDate) {
        this();
        this.setSimulationTime(new DateBasedTime(initialDate));
    }

    @Override
    public void setupFrame(AgentFrame frame) {
        super.setupFrame(frame);
        frame.add((Component)this.getSchedulerToolBar(), "First");
        frame.add((Component)this.getSchedulerStatusLabel(), "Last");
        frame.getJMenuBar().add((Component)this.getSchedulerMenu(), 2);
        this.speedModel.setValue(SCHEDULER_UI_PREFERENCES.getInt(this.getName() + "speed", this.speedModel.getValue()));
        this.setSimulationState(SCHEDULER_UI_PREFERENCES.getBoolean(this.getName() + "autostart", false) ? SimulationState.RUNNING : SimulationState.PAUSED);
    }

    public void addActivator(Activator<? extends AbstractAgent> activator) {
        activator.setSimulationTime(this.getSimulationTime());
        if (this.kernel.addOverlooker(this, activator)) {
            if (activator.getPriority() == null) {
                this.setActivatorPriority(activator, this.activators.size());
            }
            this.activators.add(activator);
            Collections.sort(this.activators, activatorComparator);
        }
        this.getLogger().fine(() -> "Activator added: " + activator);
    }

    public void setActivatorPriority(Activator<? extends AbstractAgent> activator, int priority) {
        activator.setPriority(priority);
        if (this.activators.contains(activator)) {
            Collections.sort(this.activators, activatorComparator);
        }
    }

    public void removeActivator(Activator<? extends AbstractAgent> activator) {
        this.kernel.removeOverlooker(this, activator);
        this.activators.remove(activator);
        this.getLogger().fine(() -> "Activator removed: " + activator);
    }

    public void doSimulationStep() {
        this.logActivationStep();
        for (Activator<? extends AbstractAgent> activator : this.activators) {
            this.executeAndLog(activator, new Object[0]);
        }
        this.getSimulationTime().addOneTimeUnit();
    }

    public void logActivationStep() {
        this.getLogger().finer(() -> "Current simulation step -> " + this.getSimulationTime());
    }

    public void executeAndLog(Activator<? extends AbstractAgent> activator, Object ... args) {
        this.getLogger().finer(() -> "Activating--> " + activator);
        activator.execute(args);
    }

    @Override
    protected void end() {
        this.simulationState = SimulationState.PAUSED;
        this.getLogger().fine(() -> "Simulation stopped at time = " + this.getSimulationTime());
    }

    public SimulationState getSimulationState() {
        return this.simulationState;
    }

    protected void setSimulationState(SimulationState newState) {
        if (this.simulationState != newState) {
            this.simulationState = newState;
            switch (this.simulationState) {
                case STEP: {
                    this.run.setEnabled(true);
                    break;
                }
                case PAUSED: {
                    this.run.setEnabled(true);
                    break;
                }
                case RUNNING: {
                    this.run.setEnabled(false);
                    break;
                }
                case SHUTDOWN: {
                    this.run.setEnabled(false);
                    break;
                }
                default: {
                    this.logLifeException(new Exception("state not handle : " + newState.toString()));
                }
            }
        }
    }

    @Override
    protected void live() {
        block6: while (this.isAlive()) {
            if (this.getSimulationTime().hasReachedEndTime()) {
                this.getLogger().info(() -> "Simulation has reached end time -> " + this.getSimulationTime());
                return;
            }
            this.pause(this.delay);
            this.checkMail(this.nextMessage());
            switch (this.simulationState) {
                case RUNNING: {
                    this.doSimulationStep();
                    continue block6;
                }
                case PAUSED: {
                    this.paused();
                    continue block6;
                }
                case STEP: {
                    this.simulationState = SimulationState.PAUSED;
                    this.doSimulationStep();
                    continue block6;
                }
                case SHUTDOWN: {
                    return;
                }
            }
            this.getLogger().severeLog("state not handled " + this.simulationState);
        }
    }

    protected void checkMail(Message m) {
        if (m != null) {
            try {
                SchedulingAction code = (SchedulingAction)((Object)((SchedulingMessage)m).getCode());
                switch (code) {
                    case RUN: {
                        this.setSimulationState(SimulationState.RUNNING);
                        break;
                    }
                    case STEP: {
                        this.setSimulationState(SimulationState.STEP);
                        break;
                    }
                    case PAUSE: {
                        this.setSimulationState(SimulationState.PAUSED);
                        break;
                    }
                    case SHUTDOWN: {
                        this.setSimulationState(SimulationState.SHUTDOWN);
                        break;
                    }
                    case SPEED_UP: {
                        this.speedModel.setValue(this.speedModel.getValue() - 50);
                        break;
                    }
                    case SPEED_DOWN: {
                        this.speedModel.setValue(this.speedModel.getValue() + 50);
                    }
                }
                if (m.getSender() != null) {
                    this.sendReply(m, m);
                }
            }
            catch (ClassCastException e) {
                this.getLogger().warning(() -> "I received a message that I cannot understand" + m);
            }
        }
    }

    protected void paused() {
        this.checkMail(this.waitNextMessage(1000L));
    }

    @Override
    final void terminate() {
        this.removeAllActivators();
        super.terminate();
    }

    public void removeAllActivators() {
        for (Activator<? extends AbstractAgent> a : this.activators) {
            this.kernel.removeOverlooker(this, a);
        }
        this.activators.clear();
    }

    @Deprecated
    public void setSimulationDuration(double endTime) {
        this.getSimulationTime().setEndTick(BigDecimal.valueOf(endTime));
    }

    public double getSimulationDuration() {
        return this.getSimulationTime().getEndTick().doubleValue();
    }

    private void buildActions() {
        this.run = SchedulingAction.RUN.getActionFor(this, new Object[0]);
        this.step = SchedulingAction.STEP.getActionFor(this, new Object[0]);
        this.speedUp = SchedulingAction.SPEED_UP.getActionFor(this, new Object[0]);
        this.speedDown = SchedulingAction.SPEED_DOWN.getActionFor(this, new Object[0]);
    }

    public JToolBar getSchedulerToolBar() {
        JToolBar toolBar = new JToolBar("scheduler toolbar");
        toolBar.add(this.run);
        toolBar.add(this.step);
        final JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("speed"));
        final JSlider sp = new JSlider(this.speedModel);
        sp.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int move = -e.getWheelRotation();
                if (sp.getValue() < 398) {
                    move *= 10;
                }
                move = move + sp.getValue() > sp.getMaximum() ? sp.getMaximum() : move + sp.getValue();
                sp.setValue(move);
                sp.getChangeListeners()[0].stateChanged(new ChangeEvent(this));
            }
        });
        sp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Scheduler.this.updateToolTip(p, sp);
            }
        });
        this.updateToolTip(p, sp);
        p.add(sp);
        toolBar.add(p);
        SwingUtil.scaleAllAbstractButtonIconsOf(toolBar, 24);
        return toolBar;
    }

    private void updateToolTip(JPanel p, JSlider sp) {
        String text = "pause = " + this.getDelay() + " ms";
        sp.setToolTipText(text);
        p.setToolTipText(text);
    }

    public JMenu getSchedulerMenu() {
        JMenu myMenu = new JMenu("Scheduling");
        myMenu.setMnemonic(83);
        myMenu.add(this.run);
        myMenu.add(this.step);
        myMenu.add(this.speedUp);
        myMenu.add(this.speedDown);
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("autostart", SCHEDULER_UI_PREFERENCES.getBoolean(this.getName() + "autostart", false));
        menuItem.addChangeListener(e -> SCHEDULER_UI_PREFERENCES.putBoolean(this.getName() + "autostart", menuItem.isSelected()));
        myMenu.add(menuItem);
        return myMenu;
    }

    public JLabel getSchedulerStatusLabel() {
        if (this.gvtModel == null) {
            this.gvtModel = new SimulationTimeModel();
        }
        SimulationTimeJLabel timer = new SimulationTimeJLabel(){

            @Override
            public void update(Observable o, Object arg) {
                this.setText(arg + "\t\t\t  -  " + Scheduler.this.simulationState);
            }
        };
        this.gvtModel.addObserver(timer);
        timer.setBorder(new EmptyBorder(4, 4, 4, 4));
        timer.setHorizontalAlignment(10);
        return timer;
    }

    public JLabel getGVTLabel() {
        if (this.gvtModel == null) {
            this.gvtModel = new SimulationTimeModel();
        }
        SimulationTimeJLabel timer = new SimulationTimeJLabel();
        this.gvtModel.addObserver(timer);
        timer.setBorder(new EmptyBorder(4, 4, 4, 4));
        timer.setHorizontalAlignment(10);
        return timer;
    }

    public static interface SimulationTime {
        public static final String TICK_BASED_MODE_REQUIRED = "This can only be used in a tick-based simulation. See Scheduler constructors doc";
        public static final String DATE_BASED_MODE_REQUIRED = "This can only be used in a date-based simulation. See Scheduler constructors doc";

        default public void setCurrentTick(BigDecimal value) {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public void setCurrentTick(double value) {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public void setCurrentDate(LocalDateTime date) {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }

        default public BigDecimal getCurrentTick() {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public LocalDateTime getCurrentDate() {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }

        public void addOneTimeUnit();

        public boolean hasReachedEndTime();

        default public void incrementCurrentTick(BigDecimal delta) {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public void incrementCurrentTick(double delta) {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public void incrementCurrentDate(long amountToAdd, ChronoUnit unit) {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }

        default public void incrementCurrentDate(long amountToAdd) {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }

        default public void setDefaultTemporalUnit(ChronoUnit unit) {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }

        default public ChronoUnit getDefaultTemporalUnit() {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }

        default public BigDecimal getEndTick() {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public void setEndTick(BigDecimal endTick) {
            throw new UnsupportedOperationException(TICK_BASED_MODE_REQUIRED);
        }

        default public void setEndDate(LocalDateTime endDate) {
            throw new UnsupportedOperationException(DATE_BASED_MODE_REQUIRED);
        }
    }

    public static enum SimulationState {
        RUNNING,
        STEP,
        PAUSED,
        SHUTDOWN;

    }

    final class TickBasedTime
    extends SimuTime {
        private BigDecimal currentTick;
        private BigDecimal endTick;

        TickBasedTime() {
            this.currentTick = BigDecimal.ZERO;
            this.endTick = BigDecimal.valueOf(Double.MAX_VALUE);
        }

        @Override
        public void setCurrentTick(BigDecimal value) {
            this.currentTick = value;
            this.updateUIs();
        }

        @Override
        public void incrementCurrentTick(double delta) {
            this.incrementCurrentTick(BigDecimal.valueOf(delta));
        }

        @Override
        public void incrementCurrentTick(BigDecimal delta) {
            this.setCurrentTick(this.getCurrentTick().add(delta));
        }

        @Override
        public BigDecimal getCurrentTick() {
            return this.currentTick;
        }

        @Override
        public void setEndTick(BigDecimal endTick) {
            this.endTick = endTick;
        }

        @Override
        public boolean hasReachedEndTime() {
            return this.endTick.compareTo(this.currentTick) < 0;
        }

        @Override
        public void setCurrentTick(double value) {
            this.setCurrentTick(BigDecimal.valueOf(value));
        }

        public void addDeltaTime(BigDecimal delta) {
            this.setCurrentTick(this.getCurrentTick().add(delta));
        }

        @Override
        public BigDecimal getEndTick() {
            return this.endTick;
        }

        public String toString() {
            return this.currentTick.toString();
        }

        @Override
        public void addOneTimeUnit() {
            this.addDeltaTime(BigDecimal.ONE);
        }
    }

    final class DateBasedTime
    extends SimuTime {
        private LocalDateTime currentDate;
        private LocalDateTime endDate;
        private ChronoUnit defaultUnit;

        DateBasedTime(LocalDateTime initialDate) {
            this.currentDate = initialDate;
            this.endDate = LocalDateTime.MAX;
            this.defaultUnit = ChronoUnit.SECONDS;
        }

        DateBasedTime() {
            this(LocalDateTime.of(1, 1, 1, 0, 0));
        }

        @Override
        public void setCurrentDate(LocalDateTime date) {
            this.currentDate = date;
            this.updateUIs();
        }

        @Override
        public LocalDateTime getCurrentDate() {
            return this.currentDate;
        }

        @Override
        public void setEndDate(LocalDateTime endDate) {
            this.endDate = endDate;
        }

        @Override
        public boolean hasReachedEndTime() {
            return this.endDate.compareTo(this.currentDate) < 0;
        }

        @Override
        public void incrementCurrentDate(long amountToAdd, ChronoUnit unit) {
            this.setCurrentDate(this.getCurrentDate().plus(amountToAdd, unit));
        }

        @Override
        public void incrementCurrentDate(long amountToAdd) {
            this.incrementCurrentDate(amountToAdd, this.defaultUnit);
        }

        public String toString() {
            return this.currentDate.toString();
        }

        @Override
        public void setDefaultTemporalUnit(ChronoUnit unit) {
            this.defaultUnit = unit;
        }

        @Override
        public ChronoUnit getDefaultTemporalUnit() {
            return this.defaultUnit;
        }

        @Override
        public void addOneTimeUnit() {
            this.incrementCurrentDate(1L, this.defaultUnit);
        }
    }

    final class SimulationTimeModel
    extends Observable {
        SimulationTimeModel() {
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }

    abstract class SimuTime
    implements SimulationTime {
        SimuTime() {
        }

        protected void updateUIs() {
            if (Scheduler.this.gvtModel != null) {
                Scheduler.this.gvtModel.notifyObservers(this);
            }
        }
    }
}

