/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitWarning;

final class OrganizationWarning
extends MadkitWarning {
    private static final long serialVersionUID = -1096664441558015062L;
    private final String community;
    private final String group;
    private final String role;

    public OrganizationWarning(AbstractAgent.ReturnCode code, String community, String group, String role) {
        super(code);
        this.community = community;
        this.group = group;
        this.role = role;
    }

    @Override
    public String getMessage() {
        String msg = this.code + " : ";
        switch (this.code) {
            case NOT_GROUP: 
            case NOT_IN_GROUP: 
            case ALREADY_GROUP: 
            case ACCESS_DENIED: {
                return msg + I18nUtilities.getCGRString(this.community, this.group, null);
            }
            case NOT_COMMUNITY: {
                return msg + I18nUtilities.getCGRString(this.community, null, null);
            }
            case ROLE_NOT_HANDLED: 
            case NOT_ROLE: 
            case ROLE_ALREADY_HANDLED: 
            case IGNORED: {
                return msg + I18nUtilities.getCGRString(this.community, this.group, this.role);
            }
        }
        System.err.println("\n\n************** " + this.code.name() + " result not handled ");
        new Exception().printStackTrace();
        return null;
    }
}

