/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import madkit.kernel.Watcher;

public abstract class SwingViewer
extends Watcher {
    private JPanel displayPane = new JPanel(){

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            SwingViewer.this.render(g);
        }
    };
    private boolean synchronousPainting = false;
    private boolean rendering = true;
    private JFrame frame;

    public SwingViewer() {
        this.displayPane.setBackground(Color.WHITE);
        this.createGUIOnStartUp();
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public void setRendering(boolean activate) {
        this.rendering = activate;
    }

    public JPanel getDisplayPane() {
        return this.displayPane;
    }

    public void setDisplayPane(JPanel displayPane) {
        this.displayPane = displayPane;
    }

    protected void observe() {
        if (this.rendering && this.isAlive()) {
            if (this.synchronousPainting) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SwingViewer.this.displayPane.paintImmediately(0, 0, SwingViewer.this.displayPane.getWidth(), SwingViewer.this.displayPane.getHeight());
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                this.displayPane.repaint();
            }
        }
    }

    protected abstract void render(Graphics var1);

    public boolean isSynchronousPainting() {
        return this.synchronousPainting;
    }

    public void setSynchronousPainting(boolean synchronousPainting) {
        this.synchronousPainting = synchronousPainting;
    }

    @Override
    public void setupFrame(JFrame frame) {
        this.displayPane.setSize(frame.getSize());
        frame.add(this.displayPane);
        this.setFrame(frame);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }
}

