/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.activator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.simulation.SimulationException;

public class GenericBehaviorActivator<A extends AbstractAgent>
extends Activator<A> {
    private final Map<Class<? extends A>, Method> methods = new HashMap<Class<? extends A>, Method>();
    private String methodName;

    public GenericBehaviorActivator(String community, String group, String role, String theBehaviorToActivate) {
        super(community, group, role);
        this.methodName = theBehaviorToActivate;
    }

    public String getBehaviorName() {
        return this.methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<A> agents) {
        Method cachedM = null;
        Class<?> cachedC = null;
        for (AbstractAgent a : agents) {
            if (!a.isAlive()) continue;
            Class<?> agentClass = a.getClass();
            if (agentClass != cachedC) {
                cachedC = agentClass;
                cachedM = this.methods.get(agentClass);
                if (cachedM == null) {
                    try {
                        cachedM = this.findMethodOn(agentClass, this.methodName);
                    }
                    catch (NoSuchMethodException e) {
                        throw new SimulationException(this.toString(), e);
                    }
                    Map<Class<? extends A>, Method> e = this.methods;
                    synchronized (e) {
                        this.methods.put(agentClass, cachedM);
                    }
                }
            }
            try {
                cachedM.invoke((Object)a, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SimulationException(this.toString(), e);
            }
            catch (InvocationTargetException e) {
                throw new SimulationException(this.toString() + " on " + cachedM + " " + a, e.getCause());
            }
        }
    }
}

