/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import madkit.action.SchedulingAction;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.message.SchedulingMessage;

public class Scheduler
extends Agent {
    private static final long serialVersionUID = -2224235651899852429L;
    private SimulationState simulationState = SimulationState.PAUSED;
    private final Set<Activator<? extends AbstractAgent>> activators = new LinkedHashSet<Activator<? extends AbstractAgent>>();
    private Action run;
    private Action step;
    private Action speedUp;
    private Action speedDown;
    private JLabel timer;
    private JSlider speedSlider;
    private DefaultBoundedRangeModel speedModel = new DefaultBoundedRangeModel(0, 50, 0, 1001);
    private double GVT = 0.0;
    private double simulationDuration;

    public int getDelay() {
        return this.speedModel.getValue();
    }

    public void setDelay(int delay) {
        this.speedModel.setValue(delay);
    }

    public double getGVT() {
        return this.GVT;
    }

    public void setGVT(double GVT) {
        this.GVT = GVT;
        if (this.timer != null) {
            this.timer.setText("Simulation " + (Object)((Object)this.simulationState) + ", time is " + GVT);
        }
    }

    public Scheduler() {
        this(Double.MAX_VALUE);
    }

    public Scheduler(double endTime) {
        this.buildActions();
        this.setSimulationDuration(endTime);
    }

    @Override
    public void setupFrame(JFrame frame) {
        super.setupFrame(frame);
        frame.add((Component)this.getSchedulerToolBar(), "First");
        frame.add((Component)this.getSchedulerStatusLabel(), "Last");
        this.setGVT(this.GVT);
        frame.validate();
        frame.getJMenuBar().add(this.getSchedulerMenu());
    }

    public void addActivator(Activator<? extends AbstractAgent> activator) {
        if (this.kernel.addOverlooker(this, activator)) {
            this.activators.add(activator);
        }
        if (this.logger != null) {
            this.logger.fine("Activator added: " + activator);
        }
    }

    public void removeActivator(Activator<? extends AbstractAgent> activator) {
        this.kernel.removeOverlooker(this, activator);
        this.activators.remove(activator);
        if (this.logger != null) {
            this.logger.fine("Activator removed: " + activator);
        }
    }

    public void doSimulationStep() {
        if (this.logger != null) {
            this.logger.finer("Doing simulation step " + this.GVT);
        }
        for (Activator<? extends AbstractAgent> activator : this.activators) {
            if (this.logger != null) {
                this.logger.finer("Activating\n--------> " + activator);
            }
            activator.execute();
        }
        this.setGVT(this.GVT + 1.0);
    }

    @Override
    protected void end() {
        this.simulationState = SimulationState.PAUSED;
        if (this.logger != null) {
            this.logger.info("Simulation stopped !");
        }
    }

    public SimulationState getSimulationState() {
        return this.simulationState;
    }

    protected void setSimulationState(SimulationState newState) {
        if (this.simulationState != newState) {
            this.simulationState = newState;
            switch (this.simulationState) {
                case STEP: {
                    this.run.setEnabled(true);
                    break;
                }
                case PAUSED: {
                    this.run.setEnabled(true);
                    break;
                }
                case RUNNING: {
                    this.run.setEnabled(false);
                    break;
                }
                case SHUTDOWN: {
                    this.run.setEnabled(false);
                    break;
                }
                default: {
                    this.logLifeException(new Exception("state not handle : " + newState.toString()));
                }
            }
        }
    }

    @Override
    protected void live() {
        block6: while (this.isAlive()) {
            if (this.GVT > this.simulationDuration) {
                if (this.logger != null) {
                    this.logger.info("Quitting: Simulation has reached end time " + this.simulationDuration);
                }
                return;
            }
            if (this.getDelay() == 0) {
                Thread.yield();
            } else {
                this.pause(this.getDelay());
            }
            this.checkMail(this.nextMessage());
            switch (this.simulationState) {
                case RUNNING: {
                    this.doSimulationStep();
                    continue block6;
                }
                case PAUSED: {
                    this.paused();
                    continue block6;
                }
                case STEP: {
                    this.simulationState = SimulationState.PAUSED;
                    this.doSimulationStep();
                    continue block6;
                }
                case SHUTDOWN: {
                    return;
                }
            }
            this.getLogger().severe("state not handled " + (Object)((Object)this.simulationState));
        }
    }

    protected void checkMail(Message m) {
        block12: {
            if (m != null) {
                try {
                    SchedulingAction code = (SchedulingAction)((Object)((SchedulingMessage)m).getCode());
                    switch (code) {
                        case RUN: {
                            this.setSimulationState(SimulationState.RUNNING);
                            break;
                        }
                        case STEP: {
                            this.setSimulationState(SimulationState.STEP);
                            break;
                        }
                        case PAUSE: {
                            this.setSimulationState(SimulationState.PAUSED);
                            break;
                        }
                        case SHUTDOWN: {
                            this.setSimulationState(SimulationState.SHUTDOWN);
                            break;
                        }
                        case SPEED_UP: {
                            this.speedModel.setValue(this.speedModel.getValue() - 50);
                            break;
                        }
                        case SPEED_DOWN: {
                            this.speedModel.setValue(this.speedModel.getValue() + 50);
                        }
                    }
                    if (m.getSender() != null) {
                        this.sendReply(m, m);
                    }
                }
                catch (ClassCastException e) {
                    if (this.logger == null) break block12;
                    this.logger.info("I received a message that I cannot understand" + m);
                }
            }
        }
    }

    protected void paused() {
        this.checkMail(this.waitNextMessage(1000L));
    }

    @Override
    final void terminate() {
        this.removeAllActivators();
        super.terminate();
    }

    public void removeAllActivators() {
        for (Activator<? extends AbstractAgent> a : this.activators) {
            this.kernel.removeOverlooker(this, a);
        }
        this.activators.clear();
    }

    public void setSimulationDuration(double simulationDuration) {
        this.simulationDuration = simulationDuration;
    }

    public double getSimulationDuration() {
        return this.simulationDuration;
    }

    private void buildActions() {
        this.run = SchedulingAction.RUN.getActionFor(this, new Object[0]);
        this.step = SchedulingAction.STEP.getActionFor(this, new Object[0]);
        this.speedUp = SchedulingAction.SPEED_UP.getActionFor(this, new Object[0]);
        this.speedDown = SchedulingAction.SPEED_DOWN.getActionFor(this, new Object[0]);
    }

    public JToolBar getSchedulerToolBar() {
        JToolBar toolBar = new JToolBar("scheduler toolbar");
        toolBar.add(this.run);
        toolBar.add(this.step);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder("speed"));
        this.setSpeedSlider(new JSlider(this.speedModel));
        this.getSpeedSlider().setPaintTicks(true);
        this.getSpeedSlider().setPaintLabels(false);
        this.getSpeedSlider().setMajorTickSpacing(this.speedModel.getMaximum() / 2);
        this.getSpeedSlider().setMinorTickSpacing(100);
        this.getSpeedSlider().setInverted(true);
        this.getSpeedSlider().setSnapToTicks(false);
        this.getSpeedSlider().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Scheduler.this.getSpeedSlider().setValue(e.getWheelRotation() * 50 + Scheduler.this.getSpeedSlider().getValue());
            }
        });
        p.setPreferredSize(new Dimension(150, 50));
        p.add(this.getSpeedSlider());
        toolBar.addSeparator();
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(p);
        return toolBar;
    }

    public JMenu getSchedulerMenu() {
        JMenu myMenu = new JMenu("Scheduling");
        myMenu.setMnemonic(83);
        myMenu.add(this.run);
        myMenu.add(this.step);
        myMenu.add(this.speedUp);
        myMenu.add(this.speedDown);
        return myMenu;
    }

    public JLabel getSchedulerStatusLabel() {
        this.timer = new JLabel();
        this.timer.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.timer.setHorizontalAlignment(10);
        return this.timer;
    }

    private void setSpeedSlider(JSlider speedSlider) {
        this.speedSlider = speedSlider;
    }

    public JSlider getSpeedSlider() {
        return this.speedSlider;
    }

    public static enum SimulationState {
        RUNNING,
        STEP,
        PAUSED,
        SHUTDOWN;

    }
}

