/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Group;
import madkit.kernel.KernelAddress;
import madkit.kernel.MadkitKernel;
import madkit.kernel.Overlooker;

class Role
implements Serializable {
    private static final long serialVersionUID = 4447153943733812916L;
    protected final transient List<AbstractAgent> players;
    private transient List<AbstractAgent> tmpReferenceableAgents;
    private transient Set<AgentAddress> agentAddresses;
    private transient boolean modified = true;
    private final transient Set<Overlooker<? extends AbstractAgent>> overlookers;
    protected final transient Group myGroup;
    private final transient Logger logger;
    private final transient KernelAddress kernelAddress;
    private final String communityName;
    private final String groupName;
    private final String roleName;

    KernelAddress getKernelAddress() {
        return this.kernelAddress;
    }

    Role(Group groupObject, String roleName) {
        this.players = new ArrayList<AbstractAgent>();
        this.tmpReferenceableAgents = new ArrayList<AbstractAgent>();
        this.communityName = groupObject.getCommunityObject().getName();
        this.groupName = groupObject.getName();
        this.roleName = roleName;
        MadkitKernel k = groupObject.getCommunityObject().getMyKernel();
        this.logger = groupObject.getCommunityObject().getLogger();
        this.myGroup = groupObject;
        this.kernelAddress = k.getKernelAddress();
        if (this.logger != null) {
            this.logger.finer(this.toString() + " created");
        }
        this.overlookers = new LinkedHashSet<Overlooker<? extends AbstractAgent>>();
        this.initializeOverlookers();
    }

    private synchronized void initializeOverlookers() {
        for (Overlooker<? extends AbstractAgent> o : this.myGroup.getCommunityObject().getMyKernel().getOperatingOverlookers()) {
            if (!o.getRole().equals(this.roleName) || !o.getGroup().equals(this.groupName) || !o.getCommunity().equals(this.communityName)) continue;
            this.addOverlooker(o);
        }
    }

    Role(String community, String group) {
        this.communityName = community;
        this.groupName = group;
        this.roleName = null;
        this.players = null;
        this.overlookers = null;
        this.myGroup = null;
        this.logger = null;
        this.kernelAddress = null;
    }

    List<AbstractAgent> getPlayers() {
        return this.players;
    }

    Group getMyGroup() {
        return this.myGroup;
    }

    final String getCommunityName() {
        return this.communityName;
    }

    final String getGroupName() {
        return this.groupName;
    }

    final void addOverlooker(Overlooker<? extends AbstractAgent> o) {
        this.overlookers.add(o);
        o.setOverlookedRole(this);
    }

    final void removeOverlooker(Overlooker<? extends AbstractAgent> o) {
        this.overlookers.remove(o);
        o.setOverlookedRole(null);
    }

    final String getRoleName() {
        return this.roleName;
    }

    public String toString() {
        return I18nUtilities.getCGRString(this.communityName, this.groupName, this.roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addMember(AbstractAgent requester) {
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            if (this.players.contains(requester)) {
                return false;
            }
            this.players.add(requester);
            if (this.logger != null) {
                this.logger.finest(requester.getName() + " is now playing " + I18nUtilities.getCGRString(this.communityName, this.groupName, this.roleName));
            }
            if (this.agentAddresses != null) {
                this.agentAddresses.add(new AgentAddress(requester, this, this.kernelAddress));
            }
            this.modified = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addMembers(List<AbstractAgent> bucket, boolean roleJustCreated) {
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            this.players.addAll(bucket);
            if (this.agentAddresses != null) {
                HashSet<AgentAddress> addresses = new HashSet<AgentAddress>(bucket.size() + this.agentAddresses.size(), 0.9f);
                for (AbstractAgent a : bucket) {
                    addresses.add(new AgentAddress(a, this, this.kernelAddress));
                }
                addresses.addAll(this.agentAddresses);
                this.agentAddresses = addresses;
            }
            this.modified = true;
        }
        if (roleJustCreated) {
            this.initializeOverlookers();
        } else {
            this.addToOverlookers(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDistantMember(AgentAddress content) {
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            content.setRoleObject(this);
            this.buildAndGetAddresses().add(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode removeMember(AbstractAgent requester) {
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            if (!this.players.remove(requester)) {
                if (this.myGroup.isIn(requester)) {
                    return AbstractAgent.ReturnCode.ROLE_NOT_HANDLED;
                }
                return AbstractAgent.ReturnCode.NOT_IN_GROUP;
            }
            if (this.agentAddresses != null) {
                Role.removeAgentAddressOf(requester, this.agentAddresses).setRoleObject(null);
            }
            if (this.logger != null) {
                this.logger.finest(requester.getName() + " has leaved role " + I18nUtilities.getCGRString(this.communityName, this.groupName, this.roleName) + "\n");
            }
            this.modified = true;
        }
        this.removeFromOverlookers(requester);
        this.checkEmptyness();
        return AbstractAgent.ReturnCode.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeMembers(List<AbstractAgent> bucket) {
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            this.players.removeAll(bucket);
            if (this.agentAddresses != null) {
                Iterator<AgentAddress> i = this.agentAddresses.iterator();
                while (i.hasNext()) {
                    AgentAddress aa = i.next();
                    AbstractAgent agent = aa.getAgent();
                    if (agent == null || !bucket.remove(agent)) continue;
                    i.remove();
                    aa.setRoleObject(null);
                }
            }
            this.modified = true;
        }
        this.removeFromOverlookers(bucket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDistantMember(AgentAddress content) {
        if (this.agentAddresses != null) {
            List<AbstractAgent> list = this.players;
            synchronized (list) {
                this.removeAgentAddress(content);
                this.checkEmptyness();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<AgentAddress> buildAndGetAddresses() {
        if (this.agentAddresses == null) {
            this.agentAddresses = new HashSet<AgentAddress>(this.players.size(), 0.8f);
            List<AbstractAgent> list = this.players;
            synchronized (list) {
                for (AbstractAgent a : this.players) {
                    this.agentAddresses.add(new AgentAddress(a, this, this.kernelAddress));
                }
            }
        }
        return this.agentAddresses;
    }

    private final void removeAgentAddress(AgentAddress aa) {
        if (this.agentAddresses.remove(aa)) {
            if (this.logger != null) {
                this.logger.finest(aa + " has leaved role " + I18nUtilities.getCGRString(this.communityName, this.groupName, this.roleName) + "\n");
            }
            aa.setRoleObject(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAgentsFromDistantKernel(KernelAddress kernelAddress2) {
        if (this.agentAddresses != null) {
            if (this.logger != null) {
                this.logger.finest("Removing all agents from distant kernel " + kernelAddress2 + " in" + this);
            }
            List<AbstractAgent> list = this.players;
            synchronized (list) {
                Iterator<AgentAddress> iterator = this.buildAndGetAddresses().iterator();
                while (iterator.hasNext()) {
                    AgentAddress aa = iterator.next();
                    if (!aa.getKernelAddress().equals(kernelAddress2)) continue;
                    iterator.remove();
                    aa.setRoleObject(null);
                }
                this.checkEmptyness();
            }
        }
    }

    private final void checkEmptyness() {
        if ((this.players == null || this.players.isEmpty()) && (this.agentAddresses == null || this.agentAddresses.isEmpty())) {
            this.cleanAndRemove();
        }
    }

    private void cleanAndRemove() {
        for (Overlooker<? extends AbstractAgent> o : this.overlookers) {
            o.setOverlookedRole(null);
        }
        this.myGroup.removeRole(this.roleName);
        this.tmpReferenceableAgents = null;
        this.agentAddresses = null;
    }

    final void destroy() {
        if (this.agentAddresses != null) {
            for (AgentAddress aa : this.agentAddresses) {
                aa.setRoleObject(null);
            }
        }
        this.cleanAndRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<AgentAddress> getAgentAddressesCopy() {
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            return new ArrayList<AgentAddress>(this.buildAndGetAddresses());
        }
    }

    static AgentAddress removeAgentAddressOf(AbstractAgent requester, Collection<AgentAddress> agentAddresses2) {
        Iterator<AgentAddress> iterator = agentAddresses2.iterator();
        while (iterator.hasNext()) {
            try {
                AgentAddress aa = iterator.next();
                if (aa.getAgent() != requester) continue;
                iterator.remove();
                return aa;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    final AgentAddress getAgentAddressInGroup(AbstractAgent abstractAgent) {
        AgentAddress aa = this.getAgentAddressOf(abstractAgent);
        if (aa != null) {
            return aa;
        }
        return this.myGroup.getAgentAddressOf(abstractAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<AbstractAgent> getAgentsList() {
        if (this.modified) {
            List<AbstractAgent> list = this.players;
            synchronized (list) {
                this.modified = false;
                this.tmpReferenceableAgents = new ArrayList<AbstractAgent>(this.players);
            }
        }
        return this.tmpReferenceableAgents;
    }

    final void addToOverlookers(AbstractAgent a) {
        for (Overlooker<? extends AbstractAgent> o : this.overlookers) {
            o.addAgent(a);
        }
    }

    private final void addToOverlookers(List<AbstractAgent> l) {
        for (Overlooker<? extends AbstractAgent> o : this.overlookers) {
            o.addAgents(l);
        }
    }

    final void removeFromOverlookers(AbstractAgent a) {
        for (Overlooker<? extends AbstractAgent> o : this.overlookers) {
            o.removeAgent(a);
        }
    }

    private final void removeFromOverlookers(List<AbstractAgent> l) {
        for (Overlooker<? extends AbstractAgent> o : this.overlookers) {
            o.removeAgents(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importDistantOrg(Set<AgentAddress> list) {
        List<AbstractAgent> list2 = this.players;
        synchronized (list2) {
            this.buildAndGetAddresses();
            for (AgentAddress aa : list) {
                aa.setRoleObject(this);
                this.agentAddresses.add(aa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentAddress getAgentAddressOf(AbstractAgent a) {
        int hash = a.hashCode();
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            for (AgentAddress aa : this.buildAndGetAddresses()) {
                if (aa.hashCode() != hash || aa.getAgent() == null) continue;
                return aa;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent getAbstractAgentWithAddress(AgentAddress aa) {
        int hash = aa.hashCode();
        List<AbstractAgent> list = this.players;
        synchronized (list) {
            for (AbstractAgent agent : this.players) {
                if (agent.hashCode() != hash) continue;
                return agent;
            }
        }
        return null;
    }

    final boolean contains(AbstractAgent agent) {
        return this.players.contains(agent);
    }
}

