/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import madkit.gui.AgentStatusPanel;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRSynchro;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelConnection;
import madkit.kernel.KernelServer;
import madkit.kernel.Madkit;
import madkit.kernel.Message;
import madkit.kernel.MultiCastListener;
import madkit.kernel.NetCode;
import madkit.kernel.NetworkMessage;
import madkit.message.EnumMessage;
import madkit.message.ObjectMessage;

final class NetworkAgent
extends Agent {
    private static final long serialVersionUID = 6961163274458902519L;
    private final ConcurrentHashMap<KernelAddress, KernelConnection> peers = new ConcurrentHashMap();
    private KernelServer myServer;
    private MultiCastListener multicastListener;
    private boolean running = true;
    private AgentAddress kernelAgent;

    NetworkAgent() {
    }

    @Override
    protected void activate() {
        this.setName(super.getName() + this.getKernelAddress());
        this.setLogLevel(Madkit.LevelOption.networkLogLevel.getValue(this.getMadkitConfig()));
        this.requestRole("local", "network", "net agent");
        this.kernelAgent = this.getAgentWithRole("local", "network", "manager");
        this.myThread.setPriority(7);
        if (this.kernelAgent == null) {
            throw new AssertionError((Object)(this + " no kernel agent to work with... Please bug report"));
        }
        this.running = this.launchNetwork();
    }

    private boolean launchNetwork() {
        if (AbstractAgent.ReturnCode.SUCCESS != this.createGroup("Cloud", "net", true)) {
            return false;
        }
        this.requestRole("Cloud", "net", "net agent");
        this.myServer = KernelServer.getNewKernelServer();
        if (this.myServer == null) {
            if (this.logger != null) {
                this.logger.warning("\n\t\t\t\t---- Unable to start the Madkit kernel server ------\n");
            }
            this.stopNetwork();
            return false;
        }
        this.myServer.activate(this);
        if (this.logger != null) {
            this.logger.config("\n\t\t\t\t----- MaDKit server activated on " + this.myServer.getIp() + " port " + this.myServer.getPort() + " ------\n");
        }
        try {
            this.multicastListener = MultiCastListener.getNewMultiCastListener(this.myServer.getPort());
            this.multicastListener.activate(this);
            if (this.logger != null) {
                this.logger.config("\n\t\t\t\t----- MaDKit MulticastListener activated on " + MultiCastListener.ipAddress + " ------\n");
                this.logger.finest("Broadcasting existence ");
            }
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning("\n\t\t\t\t---- Unable to start a Multicast Listener " + e.getClass().getName() + " " + e.getMessage() + " ------\n");
            }
            this.stopNetwork();
            return false;
        }
        Message m = null;
        ArrayList<Message> toDoList = new ArrayList<Message>();
        do {
            if (this.logger != null) {
                this.logger.finest("Waiting for some connections first");
            }
            if ((m = this.waitNextMessage(400L)) == null) continue;
            if (m.getSender() == null && m instanceof NetworkMessage && ((NetworkMessage)m).getCode() == NetCode.NEW_PEER_REQUEST) {
                this.newPeerRequest((Socket)((Object[])((NetworkMessage)m).getContent())[0]);
                continue;
            }
            toDoList.add(m);
        } while (m != null);
        if (this.logger != null) {
            this.logger.finest("Now purge mailbox");
        }
        for (Message message : toDoList) {
            this.handleMessage(message);
        }
        if (this.logger != null) {
            this.logger.finest("Now activating all connections");
        }
        for (KernelConnection kc : this.peers.values()) {
            if (kc.isActivated()) continue;
            kc.start();
        }
        AgentStatusPanel.updateAll();
        if (this.logger != null) {
            this.logger.info("\n\t\t\t\t----- Network has been started on " + this.getKernelAddress() + " ------\n");
        }
        return true;
    }

    @Override
    protected void live() {
        while (this.running) {
            this.handleMessage(this.waitNextMessage());
        }
    }

    @Override
    protected void end() {
        this.stopNetwork();
    }

    private void stopNetwork() {
        if (this.logger != null) {
            this.logger.info("\n\t\t\t\t----- Network is being closed on " + this.getKernelAddress() + " ------\n");
            this.logger.finer("Closing all connections : " + this.peers.values());
        }
        for (Map.Entry<KernelAddress, KernelConnection> entry : this.peers.entrySet()) {
            this.peerDeconnected(entry.getKey());
            entry.getValue().closeConnection();
        }
        this.peers.clear();
        if (this.logger != null) {
            this.logger.finer("Closing multicast listener and kernel server");
        }
        if (this.multicastListener != null) {
            this.multicastListener.stop();
        }
        if (this.myServer != null) {
            this.myServer.stop();
        }
        this.leaveGroup("Cloud", "net");
        AgentStatusPanel.updateAll();
    }

    private void handleMessage(Message m) throws ClassCastException {
        AgentAddress sender = m.getSender();
        if (sender == null) {
            this.proceedEnumMessage((EnumMessage)m);
        } else if (sender.isLocal()) {
            String senderRole = sender.getRole();
            if (senderRole.equals("updater")) {
                this.broadcastUpdate(m);
            } else if (senderRole.equals("emmiter")) {
                this.sendDistantMessage((ObjectMessage)m);
            } else if (senderRole.equals("kernel")) {
                this.proceedEnumMessage((EnumMessage)m);
            }
        } else if (sender.getRole().equals("updater")) {
            if (this.logger != null) {
                CGRSynchro synchro = (CGRSynchro)m;
                this.logger.finer("Injecting distant CGR " + (Object)((Object)synchro.getCode()) + " on " + synchro.getContent());
            }
            this.kernel.injectOperation((CGRSynchro)m);
        } else {
            if (this.logger != null) {
                this.logger.finer("Injecting distant message " + (Object)((Object)this.getState()) + " : " + m);
            }
            this.kernel.injectMessage((ObjectMessage)m);
        }
    }

    private void exit() {
        this.running = false;
    }

    private void peerDeconnected(KernelAddress ka) {
        if (this.peers.remove(ka) == null) {
            return;
        }
        if (this.logger != null) {
            this.logger.info("\n\t\t\t\t----- " + this.getKernelAddress() + " deconnected from MaDKit kernel " + ka + "------\n");
        }
        this.kernel.removeAgentsFromDistantKernel(ka);
    }

    private void newPeerRequest(Socket s) {
        KernelAddress dka;
        if (this.logger != null) {
            this.logger.fine("Contacted by peer " + s + " -> opening kernel connection");
        }
        KernelConnection kc = null;
        try {
            kc = new KernelConnection(this, s);
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning("I give up: Unable to contact peer on " + s + " because " + e.getMessage());
            }
            return;
        }
        if (this.logger != null) {
            this.logger.finer("KC opened: " + kc + "\n\tsending connection INFO");
        }
        if (!this.sendingConnectionInfo(kc)) {
            return;
        }
        if (this.logger != null) {
            this.logger.fine("Connection info sent, now waiting reply from " + kc.getDistantKernelSocket() + "...");
        }
        if ((dka = this.gettingConnectionInfo(kc)) == null) {
            return;
        }
        this.addConnection(dka, kc, this.getState().equals((Object)AbstractAgent.State.LIVING));
    }

    private void addConnection(KernelAddress ka, KernelConnection kc, boolean startConnection) {
        this.peers.put(ka, kc);
        if (this.logger != null) {
            this.logger.info("\n\t\t\t\t----- " + this.getKernelAddress() + " now connected with MaDKit kernel " + kc.getKernelAddress() + "------\n");
        }
        if (startConnection) {
            kc.start();
        }
    }

    private void newPeerDetected(DatagramPacket packet) {
        if (this.logger != null) {
            this.logger.fine("New peer detected on " + packet.getAddress() + " port = " + packet.getPort() + "\n\t-> opening KernelConnection");
        }
        KernelConnection kc = null;
        try {
            kc = new KernelConnection(this, packet.getAddress(), packet.getPort());
            if (this.logger != null) {
                this.logger.finer("KC created " + kc);
            }
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.warning("I give up: Unable to contact peer on " + packet.getAddress() + " port = " + packet.getPort() + " because " + e.getMessage());
            }
            return;
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning("I give up: Unable to contact peer on " + packet.getAddress() + " port = " + packet.getPort() + " because " + e.getMessage());
            }
            return;
        }
        KernelAddress dka = this.gettingConnectionInfo(kc);
        if (dka == null) {
            return;
        }
        if (this.logger != null) {
            this.logger.finer("Now replying to " + dka);
        }
        if (!this.sendingConnectionInfo(kc)) {
            return;
        }
        this.addConnection(dka, kc, this.getState().equals((Object)AbstractAgent.State.LIVING));
    }

    private KernelAddress gettingConnectionInfo(KernelConnection kc) {
        if (this.logger != null) {
            this.logger.finest("Waiting distant kernel address...");
        }
        KernelAddress dka = null;
        try {
            dka = kc.waitForDistantKernelAddress();
            if (this.logger != null) {
                this.logger.finest("... Distant Kernel Address is " + dka + "\nWaiting distant organization info...");
            }
            this.kernel.importDistantOrg(kc.waitForDistantOrg());
            return dka;
        }
        catch (IOException e) {
            if (dka == null) {
                this.getLogger().severeLog("I give up: Unable to get distant kernel address info on " + kc.getInetAddress() + " port = " + kc.getPort(), e);
            } else {
                this.getLogger().severeLog("I give up: Unable to get distant organization from " + dka, e);
            }
        }
        catch (ClassNotFoundException e) {
            if (dka == null) {
                this.getLogger().severeLog("I give up: Unable to get distant kernel address info on " + kc.getInetAddress() + " port = " + kc.getPort(), e);
            }
            this.getLogger().severeLog("I give up: Unable to get distant organization from " + dka, e);
        }
        return null;
    }

    private boolean sendingConnectionInfo(KernelConnection kc) {
        if (this.logger != null) {
            this.logger.fine("Sending connection info to " + (kc.getKernelAddress() == null ? kc.getDistantKernelSocket() : kc.getKernelAddress()));
            this.logger.finer("Local org is\n\n" + this.getOrganizationSnapShot(false) + "\n");
        }
        try {
            kc.sendConnectionInfo(this.getKernelAddress(), this.getOrganizationSnapShot(false));
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning("I give up: Unable to send connection info to " + (kc.getKernelAddress() == null ? kc.getDistantKernelSocket() : kc.getKernelAddress()) + " because " + e.getMessage());
            }
            return false;
        }
        return true;
    }

    private void broadcastUpdate(Message message) {
        if (this.logger != null) {
            this.logger.finer("Local CGR update\nBroadcasting  to " + this.peers.values() + message);
            this.logger.finest("Local org is\n\n" + this.getOrganizationSnapShot(false) + "\n");
        }
        for (KernelConnection kc : this.peers.values()) {
            kc.sendMessage(message);
        }
    }

    private boolean sendDistantMessage(ObjectMessage<Message> m) {
        KernelConnection kc;
        if (this.logger != null) {
            this.logger.finer("sending to " + m.getContent().getReceiver().getKernelAddress() + m);
        }
        if ((kc = this.peers.get(m.getContent().getReceiver().getKernelAddress())) == null) {
            return false;
        }
        kc.sendMessage(m);
        return true;
    }
}

