/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import madkit.action.KernelAction;
import madkit.kernel.NetCode;
import madkit.kernel.NetworkAgent;
import madkit.kernel.NetworkMessage;
import madkit.message.KernelMessage;

final class MultiCastListener {
    static InetAddress ipAddress;
    private final MulticastSocket ms;
    private final DatagramSocket ds;
    private boolean running = true;

    private MultiCastListener(MulticastSocket ms2, DatagramSocket ds2) {
        this.ms = ms2;
        this.ds = ds2;
    }

    static MultiCastListener getNewMultiCastListener(int localPort) throws IOException, UnknownHostException {
        MulticastSocket ms = null;
        DatagramSocket ds = null;
        int multiCastPort = 9999;
        if (ipAddress == null) {
            ipAddress = InetAddress.getByName("224.2.2.3");
        }
        ms = new MulticastSocket(9999);
        ms.joinGroup(ipAddress);
        ms.setLoopbackMode(true);
        ds = new DatagramSocket(localPort);
        return new MultiCastListener(ms, ds);
    }

    void activate(final NetworkAgent networkAgent) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        final long onlineTime = System.nanoTime();
        dos.writeLong(onlineTime);
        dos.close();
        final byte[] data = bos.toByteArray();
        this.ds.send(new DatagramPacket(data, 8, ipAddress, 9999));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (MultiCastListener.this.running) {
                    try {
                        DatagramPacket peerRequest = new DatagramPacket(data, 8);
                        MultiCastListener.this.ms.receive(peerRequest);
                        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
                        if (onlineTime >= dis.readLong()) continue;
                        networkAgent.receiveMessage(new NetworkMessage(NetCode.NEW_PEER_DETECTED, peerRequest));
                    }
                    catch (IOException e) {
                        if (!MultiCastListener.this.running) break;
                        networkAgent.receiveMessage(new KernelMessage(KernelAction.EXIT, new Object[0]));
                        break;
                    }
                }
                MultiCastListener.this.stop();
            }
        });
        t.setName("MCL " + networkAgent.getName());
        t.start();
    }

    void stop() {
        this.running = false;
        this.ms.close();
        this.ds.close();
    }
}

