/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import madkit.action.ActionInfo;
import madkit.action.KernelAction;
import madkit.gui.ConsoleAgent;
import madkit.gui.MASModel;
import madkit.i18n.ErrorMessages;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentExecutor;
import madkit.kernel.AgentLogger;
import madkit.kernel.AgentThreadFactory;
import madkit.kernel.AgentsJob;
import madkit.kernel.CGRNotAvailable;
import madkit.kernel.CGRSynchro;
import madkit.kernel.CandidateAgentAddress;
import madkit.kernel.Gatekeeper;
import madkit.kernel.Group;
import madkit.kernel.KernelAddress;
import madkit.kernel.KilledException;
import madkit.kernel.LoggedKernel;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitWarning;
import madkit.kernel.Message;
import madkit.kernel.NetworkAgent;
import madkit.kernel.Organization;
import madkit.kernel.OrganizationWarning;
import madkit.kernel.Overlooker;
import madkit.kernel.Role;
import madkit.message.KernelMessage;
import madkit.message.ObjectMessage;
import madkit.message.hook.AgentLifeEvent;
import madkit.message.hook.EventMessage;
import madkit.message.hook.HookMessage;
import madkit.message.hook.MessageEvent;
import madkit.message.hook.OrganizationEvent;

class MadkitKernel
extends Agent {
    private static final long serialVersionUID = 3999398692543480834L;
    private static final ThreadGroup SYSTEM = new ThreadGroup("MK_SYSTEM"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.err.println("\n------------uncaught exception on " + t);
        }
    };
    private static final ThreadPoolExecutor serviceExecutor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 2L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(SYSTEM, r);
            t.setPriority(10);
            t.setName(SYSTEM.getName());
            t.setDaemon(true);
            return t;
        }
    });
    private final ThreadPoolExecutor lifeExecutor;
    private final ConcurrentHashMap<String, Organization> organizations;
    private final Set<Overlooker<? extends AbstractAgent>> operatingOverlookers;
    private final Madkit platform;
    private final KernelAddress kernelAddress;
    protected MadkitKernel loggedKernel;
    private volatile boolean shuttedDown = false;
    private final AgentThreadFactory normalAgentThreadFactory;
    private final AgentThreadFactory daemonAgentThreadFactory;
    private AgentAddress netAgent;
    private AgentAddress netUpdater;
    private AgentAddress netEmmiter;
    private AgentAddress kernelRole;
    private final Set<Agent> threadedAgents;
    private boolean bucketMode = false;
    private EnumMap<HookMessage.AgentActionEvent, Set<AbstractAgent>> hooks;

    static final ExecutorService getMadkitServiceExecutor() {
        return serviceExecutor;
    }

    MadkitKernel(Madkit m) {
        super(true);
        this.platform = m;
        this.kernel = this;
        this.threadedAgents = new HashSet<Agent>(20);
        this.setLogLevel(Madkit.LevelOption.kernelLogLevel.getValue(this.getMadkitConfig()));
        this.kernelAddress = new KernelAddress();
        this.organizations = new ConcurrentHashMap();
        this.operatingOverlookers = new LinkedHashSet<Overlooker<? extends AbstractAgent>>();
        this.loggedKernel = new LoggedKernel(this);
        this.normalAgentThreadFactory = new AgentThreadFactory(this.kernelAddress, false);
        this.daemonAgentThreadFactory = new AgentThreadFactory(this.kernelAddress, true);
        this.lifeExecutor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(MadkitKernel.this.normalAgentThreadFactory.getThreadGroup(), r);
                return t;
            }
        });
        this.lifeExecutor.prestartAllCoreThreads();
        this.lifeExecutor.allowCoreThreadTimeOut(true);
    }

    MadkitKernel() {
        super(null);
        this.kernel = this;
        this.threadedAgents = null;
        this.loggedKernel = this;
        this.platform = null;
        this.kernelAddress = null;
        this.organizations = null;
        this.operatingOverlookers = null;
        this.normalAgentThreadFactory = null;
        this.daemonAgentThreadFactory = null;
        this.lifeExecutor = null;
    }

    MadkitKernel(MadkitKernel k) {
        super(null);
        this.threadedAgents = null;
        this.platform = k.platform;
        this.kernelAddress = k.kernelAddress;
        this.organizations = k.organizations;
        this.operatingOverlookers = k.operatingOverlookers;
        this.normalAgentThreadFactory = null;
        this.daemonAgentThreadFactory = null;
        this.lifeExecutor = null;
        this.kernel = k;
    }

    @Override
    protected void activate() {
        if (this.logger != null) {
            this.logger.setWarningLogLevel(Level.INFO);
        }
        this.createGroup("local", "system", false, new Gatekeeper(){

            @Override
            public boolean allowAgentToTakeRole(String roleName, Object memberCard) {
                return false;
            }
        });
        this.createGroup("local", "network", false);
        this.requestRole("local", "network", "kernel", null);
        this.requestRole("local", "network", "updater", null);
        this.requestRole("local", "network", "emmiter", null);
        this.netUpdater = this.getAgentAddressIn("local", "network", "updater");
        this.netEmmiter = this.getAgentAddressIn("local", "network", "emmiter");
        this.kernelRole = this.getAgentAddressIn("local", "network", "kernel");
        this.myThread.setPriority(6);
        if (Madkit.BooleanOption.loadLocalDemos.isActivated(this.getMadkitConfig())) {
            this.loadLocalDemos();
        }
        this.launchGuiManagerAgent();
        if (Madkit.BooleanOption.console.isActivated(this.getMadkitConfig())) {
            this.launchAgent(new ConsoleAgent());
        }
        this.launchNetworkAgent();
    }

    private void startSession() {
        this.launchConfigAgents();
    }

    @Override
    protected void live() {
        if (Madkit.BooleanOption.autoConnectMadkitWebsite.isActivated(this.getMadkitConfig())) {
            this.addWebRepository();
        }
        this.startSession();
        while (!this.shuttedDown) {
            this.handleMessage(this.waitNextMessage());
        }
    }

    @Override
    public boolean isAlive() {
        return super.isAlive() && !this.shuttedDown;
    }

    @Override
    protected void end() {
        if (Madkit.LevelOption.madkitLogLevel.getValue(this.platform.getConfigOption()) != Level.OFF) {
            System.err.println("\n\t---------------------------------------\n\t         MaDKit Kernel " + this.kernelAddress + " \n\t        is shutting down, Bye !" + "\n\t---------------------------------------\n");
        }
    }

    private final void launchGuiManagerAgent() {
        if (this.logger != null) {
            this.logger.fine("\n\t****** Launching GUI Manager ******\n");
        }
        try {
            Constructor<?> c = this.getMadkitClassLoader().loadClass("madkit.gui.GUIManagerAgent").getDeclaredConstructor(Boolean.TYPE);
            c.setAccessible(true);
            AbstractAgent a = (AbstractAgent)c.newInstance(!Madkit.BooleanOption.desktop.isActivated(this.getMadkitConfig()));
            a.setLogLevel(Madkit.LevelOption.guiLogLevel.getValue(this.getMadkitConfig()));
            this.launchAgent(a);
            this.threadedAgents.remove(a);
            if (this.logger != null) {
                this.logger.fine("\n\t****** GUI Manager launched ******\n");
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReport(e);
        }
        catch (SecurityException e) {
            this.bugReport(e);
        }
        catch (NoSuchMethodException e) {
            this.bugReport(e);
        }
        catch (IllegalArgumentException e) {
            this.bugReport(e);
        }
        catch (InstantiationException e) {
            this.bugReport(e);
        }
        catch (IllegalAccessException e) {
            this.bugReport(e);
        }
        catch (InvocationTargetException e) {
            this.bugReport(e);
        }
    }

    private void loadJarFile(URL url) {
        this.platform.getMadkitClassLoader().addToClasspath(url);
    }

    private void copy() {
        this.startSession(false);
    }

    private void restart() {
        this.copy();
        this.exit();
    }

    private void addWebRepository() {
        block4: {
            String repoLocation = this.getMadkitConfig().getProperty("madkit.repository.url");
            if (this.logger != null) {
                this.logger.fine("** CONNECTING WEB REPO **" + repoLocation);
            }
            try {
                Properties p = new Properties();
                p.load(new URL(repoLocation + "repo.properties").openStream());
                for (Map.Entry<Object, Object> object : p.entrySet()) {
                    this.platform.getMadkitClassLoader().addToClasspath(new URL(repoLocation + object.getValue() + "/" + object.getKey() + ".agents.jar"));
                }
            }
            catch (IOException e) {
                if (this.logger == null) break block4;
                this.logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_CONNECT) + ": madkit.net " + repoLocation + "\n" + e.getMessage());
            }
        }
    }

    private void loadLocalDemos() {
        File f;
        if (this.logger != null) {
            this.logger.fine("** LOADING DEMO DIRECTORY **");
        }
        if ((f = this.lookForMadkitDemoHome()) != null && f.isDirectory()) {
            this.platform.getMadkitClassLoader().loadJarsFromPath(f.getAbsolutePath());
        } else if (this.logger != null) {
            this.logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_FIND) + " demo " + (Object)((Object)Words.DIRECTORY) + "\n");
        }
    }

    private File lookForMadkitDemoHome() {
        for (URL url : this.getMadkitClassLoader().getURLs()) {
            if (!url.getProtocol().equals("file") || !url.getPath().contains(this.platform.getConfigOption().getProperty("madkit.jar.name"))) continue;
            try {
                return new File(new File(url.toURI()).getParentFile(), "demos");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void launchMas(MASModel dm) {
        if (this.logger != null) {
            this.logger.finer("** LAUNCHING SESSION " + dm.getName());
        }
        Properties mkCfg = this.platform.getConfigOption();
        Properties currentConfig = new Properties();
        currentConfig.putAll((Map<?, ?>)mkCfg);
        mkCfg.putAll((Map<?, ?>)this.platform.buildConfigFromArgs(dm.getSessionArgs()));
        this.startSession();
        mkCfg.putAll((Map<?, ?>)currentConfig);
    }

    private void console() {
        this.launchAgent(ConsoleAgent.class.getName());
    }

    private void jconsole() {
        String jconsolePath = KernelAction.findJconsole();
        if (jconsolePath != null) {
            String pid = ManagementFactory.getRuntimeMXBean().getName();
            try {
                Runtime.getRuntime().exec(jconsolePath + " " + pid.substring(0, pid.indexOf(64)));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            this.getLogger().severe("jconsole unavailable");
        }
    }

    private void launchConfigAgents() {
        String agentsTolaunch;
        ExecutorService startExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        if (this.logger != null) {
            this.logger.fine("** LAUNCHING CONFIG AGENTS **");
        }
        if (!(agentsTolaunch = this.platform.getConfigOption().getProperty(Madkit.Option.launchAgents.name())).equals("null")) {
            String[] agentsClasses;
            for (String classNameAndOption : agentsClasses = agentsTolaunch.split(";")) {
                String[] classAndOptions = classNameAndOption.split(",");
                final String className = classAndOptions[0].trim();
                final boolean withGUI = classAndOptions.length > 1 ? Boolean.parseBoolean(classAndOptions[1].trim()) : false;
                int number = 1;
                if (classAndOptions.length > 2) {
                    try {
                        number = Integer.parseInt(classAndOptions[2].trim());
                    }
                    catch (NumberFormatException e) {
                        this.getLogger().severeLog(ErrorMessages.OPTION_MISUSED.toString() + Madkit.Option.launchAgents.toString() + " " + agentsTolaunch + " " + e.getClass().getName() + " !!!\n", null);
                    }
                }
                if (this.logger != null) {
                    this.logger.finer("Launching " + number + " instance(s) of " + className + " with GUI = " + withGUI);
                }
                for (int i = 0; i < number; ++i) {
                    startExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!MadkitKernel.this.shuttedDown) {
                                try {
                                    MadkitKernel.this.launchAgent((AbstractAgent)MadkitKernel.this.getMadkitClassLoader().loadClass(className).newInstance(), 1, withGUI);
                                }
                                catch (InstantiationException e) {
                                    MadkitKernel.this.cannotLaunchAgent(className, e, null);
                                }
                                catch (IllegalAccessException e) {
                                    MadkitKernel.this.cannotLaunchAgent(className, e, null);
                                }
                                catch (ClassNotFoundException e) {
                                    MadkitKernel.this.cannotLaunchAgent(className, e, null);
                                }
                                catch (Exception e) {
                                    MadkitKernel.this.cannotLaunchAgent(className, e, null);
                                }
                            }
                        }
                    });
                }
            }
            startExecutor.shutdown();
        }
    }

    private void startSession(boolean externalVM) {
        if (this.logger != null) {
            this.logger.config("starting new MaDKit session with " + Arrays.deepToString(this.platform.args));
        }
        if (externalVM) {
            try {
                String args = "";
                for (String s : this.platform.args) {
                    args = args + s + " ";
                }
                Runtime.getRuntime().exec(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java -cp " + System.getProperty("java.class.path") + " " + this.platform.getConfigOption().getProperty("madkit.main.class") + " " + args);
            }
            catch (IOException e) {
                this.bugReport(e);
            }
        } else {
            new Madkit(this.platform.args);
        }
    }

    private void stopNetwork() {
        if (this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.STOP_NETWORK, new Object[0]), this.kernelRole) == AbstractAgent.ReturnCode.SUCCESS) {
            if (this.logger != null) {
                this.logger.fine("\n\t****** Network stopped ******\n");
            }
        } else if (this.logger != null) {
            this.logger.fine("\n\t****** Network already down ******\n");
        }
    }

    private void handleMessage(Message m) {
        if (m instanceof KernelMessage) {
            this.proceedEnumMessage((KernelMessage)m);
        } else if (m instanceof HookMessage) {
            this.handleHookRequest((HookMessage)m);
        } else if (this.logger != null) {
            this.logger.warning("I received a message that I do not understand. Discarding " + m);
        }
    }

    private void handleHookRequest(HookMessage m) {
        Set<AbstractAgent> l;
        if (this.hooks == null) {
            this.hooks = new EnumMap(HookMessage.AgentActionEvent.class);
        }
        if ((l = this.hooks.get(m.getCode())) == null) {
            l = new HashSet<AbstractAgent>();
            this.hooks.put((HookMessage.AgentActionEvent)((Object)m.getCode()), l);
        }
        AbstractAgent requester = m.getSender().getAgent();
        this.getLogger().setLevel(Level.INFO);
        if (!l.add(requester)) {
            l.remove(requester);
            if (l.isEmpty()) {
                this.hooks.remove(m.getCode());
                if (this.hooks.isEmpty()) {
                    this.hooks = null;
                }
            }
        }
    }

    private void launchNetworkAgent() {
        if (Madkit.BooleanOption.network.isActivated(this.getMadkitConfig())) {
            this.launchNetwork();
        } else if (this.logger != null) {
            this.logger.fine("** Networking is off: No Net Agent **\n");
        }
    }

    final MadkitKernel getLoggedKernel() {
        return this.loggedKernel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode createGroup(AbstractAgent creator, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        if (this.bucketMode) {
            return AbstractAgent.ReturnCode.IGNORED;
        }
        if (group == null) {
            throw new NullPointerException(ErrorMessages.G_NULL.toString());
        }
        Organization organization = new Organization(community, this);
        Organization tmpOrg = this.organizations.putIfAbsent(community, organization);
        if (tmpOrg != null) {
            organization = tmpOrg;
        }
        Organization organization2 = organization;
        synchronized (organization2) {
            if (!organization.addGroup(creator, group, gatekeeper, isDistributed)) {
                return AbstractAgent.ReturnCode.ALREADY_GROUP;
            }
        }
        if (isDistributed) {
            try {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.CREATE_GROUP, this.getRole(community, group, "manager").getAgentAddressOf(creator)), this.netUpdater);
            }
            catch (CGRNotAvailable e) {
                this.getLogger().severeLog("Please bug report", e);
            }
        }
        if (this.logger != null) {
            this.informHooks(HookMessage.AgentActionEvent.CREATE_GROUP, creator.getName(), community, group, isDistributed);
        }
        return AbstractAgent.ReturnCode.SUCCESS;
    }

    void informHooks(HookMessage.AgentActionEvent action, Object ... parameters) {
        Set<AbstractAgent> l;
        if (this.hooks != null && (l = this.hooks.get((Object)action)) != null) {
            EventMessage hm = null;
            switch (action) {
                case CREATE_GROUP: 
                case REQUEST_ROLE: 
                case LEAVE_GROUP: 
                case LEAVE_ROLE: {
                    hm = new OrganizationEvent(action, parameters);
                    break;
                }
                case BROADCAST_MESSAGE: 
                case SEND_MESSAGE: {
                    hm = new MessageEvent(action, parameters);
                    break;
                }
                case AGENT_STARTED: 
                case AGENT_TERMINATED: {
                    hm = new AgentLifeEvent(action, parameters);
                    break;
                }
            }
            for (AbstractAgent a : l) {
                a.receiveMessage(hm);
            }
        }
    }

    AbstractAgent.ReturnCode requestRole(AbstractAgent requester, String community, String group, String role, Object memberCard) {
        Group g;
        if (this.bucketMode) {
            return AbstractAgent.ReturnCode.IGNORED;
        }
        try {
            g = this.getGroup(community, group);
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
        AbstractAgent.ReturnCode result = g.requestRole(requester, role, memberCard);
        if (result == AbstractAgent.ReturnCode.SUCCESS) {
            if (g.isDistributed()) {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.REQUEST_ROLE, ((Role)g.get(role)).getAgentAddressOf(requester)), this.netUpdater);
            }
            if (this.logger != null) {
                this.informHooks(HookMessage.AgentActionEvent.REQUEST_ROLE, requester.getName(), community, group, role);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode leaveGroup(AbstractAgent requester, String community, String group) {
        List<Role> affectedRoles;
        Group g;
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            try {
                g = this.getGroup(community, group);
            }
            catch (CGRNotAvailable e) {
                return e.getCode();
            }
            affectedRoles = g.leaveGroup(requester);
        }
        if (affectedRoles != null) {
            for (Role role : affectedRoles) {
                role.removeFromOverlookers(requester);
            }
            if (g.isDistributed()) {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.LEAVE_GROUP, new AgentAddress(requester, new Role(community, group), this.kernelAddress)), this.netUpdater);
            }
            if (this.logger != null) {
                this.informHooks(HookMessage.AgentActionEvent.LEAVE_GROUP, community, group);
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        return AbstractAgent.ReturnCode.NOT_IN_GROUP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode leaveRole(AbstractAgent requester, String community, String group, String role) {
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            AbstractAgent.ReturnCode rc;
            Role r;
            try {
                r = this.getRole(community, group, role);
            }
            catch (CGRNotAvailable e) {
                return e.getCode();
            }
            if (r.getMyGroup().isDistributed()) {
                AgentAddress leaver = r.getAgentAddressOf(requester);
                if (leaver == null) {
                    return AbstractAgent.ReturnCode.ROLE_NOT_HANDLED;
                }
                rc = r.removeMember(requester);
                if (rc != AbstractAgent.ReturnCode.SUCCESS) {
                    throw new AssertionError((Object)("cannot remove " + requester + " from " + r.buildAndGetAddresses()));
                }
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.LEAVE_ROLE, leaver), this.netUpdater);
            } else {
                rc = r.removeMember(requester);
            }
            if (rc == AbstractAgent.ReturnCode.SUCCESS) {
                r.removeFromOverlookers(requester);
                if (this.logger != null) {
                    this.informHooks(HookMessage.AgentActionEvent.LEAVE_ROLE, community, group, role);
                }
            }
            return rc;
        }
    }

    List<AgentAddress> getAgentsWithRole(AbstractAgent requester, String community, String group, String role, boolean callerIncluded) {
        try {
            if (callerIncluded) {
                return this.getRole(community, group, role).getAgentAddressesCopy();
            }
            return this.getOtherRolePlayers(requester, community, group, role);
        }
        catch (CGRNotAvailable e) {
            return null;
        }
    }

    AgentAddress getAgentWithRole(AbstractAgent requester, String community, String group, String role) {
        try {
            return this.getAnotherRolePlayer(requester, community, group, role);
        }
        catch (CGRNotAvailable e) {
            return null;
        }
    }

    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, String community, String group, String role, Message message, String senderRole) {
        try {
            AgentAddress receiver = this.getAnotherRolePlayer(requester, community, group, role);
            if (receiver == null) {
                return AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND;
            }
            return this.buildAndSendMessage(this.getSenderAgentAddress(requester, receiver, senderRole), receiver, message);
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, AgentAddress receiver, Message message, String senderRole) {
        if (!receiver.exists()) {
            return AbstractAgent.ReturnCode.INVALID_AGENT_ADDRESS;
        }
        try {
            return this.buildAndSendMessage(this.getSenderAgentAddress(requester, receiver, senderRole), receiver, message);
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    AbstractAgent.ReturnCode broadcastMessageWithRole(AbstractAgent requester, String community, String group, String role, Message messageToSend, String senderRole) {
        try {
            List<AgentAddress> receivers = this.getOtherRolePlayers(requester, community, group, role);
            if (receivers == null) {
                return AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND;
            }
            messageToSend.setSender(this.getSenderAgentAddress(requester, receivers.get(0), senderRole));
            this.broadcasting(receivers, messageToSend);
            if (this.logger != null) {
                this.informHooks(HookMessage.AgentActionEvent.BROADCAST_MESSAGE, community, group, role, messageToSend, senderRole);
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    List<Message> broadcastMessageWithRoleAndWaitForReplies(AbstractAgent requester, String community, String group, String role, Message message, String senderRole, Integer timeOutMilliSeconds) {
        try {
            List<AgentAddress> receivers = this.getOtherRolePlayers(requester, community, group, role);
            if (receivers == null) {
                return null;
            }
            message.setSender(this.getSenderAgentAddress(requester, receivers.get(0), senderRole));
            this.broadcasting(receivers, message);
            return requester.waitAnswers(message, receivers.size(), timeOutMilliSeconds);
        }
        catch (CGRNotAvailable e) {
            if (requester.getKernel() != this && requester.isWarningOn()) {
                AbstractAgent.ReturnCode r = e.getCode();
                if (r == AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND) {
                    requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT, new MadkitWarning(r));
                } else if (r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
                    requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT, new OrganizationWarning(r, community, group, senderRole));
                } else {
                    requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT, new OrganizationWarning(r, community, group, role));
                }
            }
            return null;
        }
    }

    private void broadcasting(Collection<AgentAddress> receivers, Message m) {
        for (AgentAddress agentAddress : receivers) {
            if (agentAddress == null) continue;
            m = m.clone();
            m.setReceiver(agentAddress);
            this.sendMessage(m, agentAddress.getAgent());
        }
    }

    private final AbstractAgent.ReturnCode sendMessage(Message m, AbstractAgent target) {
        if (target == null) {
            return this.sendNetworkMessageWithRole(new ObjectMessage<Message>(m), this.netEmmiter);
        }
        target.receiveMessage(m);
        return AbstractAgent.ReturnCode.SUCCESS;
    }

    private final AbstractAgent.ReturnCode sendNetworkMessageWithRole(Message m, AgentAddress role) {
        this.updateNetworkAgent();
        if (this.netAgent != null) {
            m.setSender(role);
            m.setReceiver(this.netAgent);
            this.netAgent.getAgent().receiveMessage(m);
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        return AbstractAgent.ReturnCode.SEVERE;
    }

    private void updateNetworkAgent() {
        if (this.netAgent == null || !this.netAgent.exists()) {
            this.netAgent = this.getAgentWithRole("local", "network", "net agent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launchAgentBucketWithRoles(final AbstractAgent requester, List<AbstractAgent> bucket, String ... cgrLocations) {
        AgentsJob aj = new AgentsJob(){

            @Override
            void proceedAgent(AbstractAgent a) {
                a.state.set(AbstractAgent.State.ACTIVATED);
                a.setKernel(MadkitKernel.this);
                a.getAlive().set(true);
                a.logger = null;
            }
        };
        this.doMulticore(serviceExecutor, aj.getJobs(bucket));
        aj = new AgentsJob(){

            @Override
            void proceedAgent(AbstractAgent a) {
                try {
                    a.activate();
                }
                catch (Throwable e) {
                    requester.cannotLaunchAgent(a != null ? a.getClass().getName() : "launchAgentBucketWithRoles : list contains null", e, null);
                }
            }
        };
        if (cgrLocations != null && cgrLocations.length != 0) {
            for (String cgrLocation : cgrLocations) {
                String[] cgr = cgrLocation.split(";");
                if (cgr.length != 3) {
                    throw new IllegalArgumentException(cgrLocation);
                }
                this.createGroup(requester, cgr[0], cgr[1], null, false);
                Group g = null;
                try {
                    g = this.getGroup(cgr[0], cgr[1]);
                }
                catch (CGRNotAvailable e) {
                    throw new AssertionError((Object)e);
                }
                boolean roleCreated = false;
                Role r = (Role)g.get(cgr[2]);
                if (r == null) {
                    r = g.createRole(cgr[2]);
                    g.put(r.getRoleName(), r);
                    roleCreated = true;
                }
                r.addMembers(bucket, roleCreated);
            }
            MadkitKernel madkitKernel = this;
            synchronized (madkitKernel) {
                this.bucketMode = true;
                this.doMulticore(serviceExecutor, aj.getJobs(bucket));
                this.bucketMode = false;
            }
        }
        this.doMulticore(serviceExecutor, aj.getJobs(bucket));
    }

    final List<AbstractAgent> createBucket(String agentClass, int bucketSize) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int i;
        if (this.shuttedDown) {
            return null;
        }
        final Class<?> constructor = this.getMadkitClassLoader().loadClass(agentClass);
        int cpuCoreNb = Runtime.getRuntime().availableProcessors();
        ArrayList<AbstractAgent> result = new ArrayList<AbstractAgent>(bucketSize);
        final int nbOfAgentsPerTask = bucketSize / cpuCoreNb;
        ExecutorCompletionService<List<AbstractAgent>> ecs = new ExecutorCompletionService<List<AbstractAgent>>(serviceExecutor);
        for (i = 0; i < cpuCoreNb; ++i) {
            ecs.submit(new Callable<List<AbstractAgent>>(){

                @Override
                public List<AbstractAgent> call() throws InvocationTargetException, InstantiationException, IllegalAccessException {
                    ArrayList<AbstractAgent> list = new ArrayList<AbstractAgent>(nbOfAgentsPerTask);
                    for (int j = nbOfAgentsPerTask; j > 0; --j) {
                        list.add((AbstractAgent)constructor.newInstance());
                    }
                    return list;
                }
            });
        }
        for (i = bucketSize - nbOfAgentsPerTask * cpuCoreNb; i > 0; --i) {
            result.add((AbstractAgent)constructor.newInstance());
        }
        for (i = 0; i < cpuCoreNb; ++i) {
            try {
                result.addAll((Collection)ecs.take().get());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void doMulticore(Executor e, ArrayList<AgentsJob> arrayList) {
        ExecutorCompletionService<Void> ecs = new ExecutorCompletionService<Void>(e);
        for (AgentsJob s : arrayList) {
            ecs.submit(s);
        }
        for (int i = arrayList.size(); i > 0; --i) {
            try {
                ecs.take();
                continue;
            }
            catch (InterruptedException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    AbstractAgent.ReturnCode launchAgent(AbstractAgent requester, final AbstractAgent agent, int timeOutSeconds, final boolean defaultGUI) {
        try {
            if (this.logger != null) {
                this.logger.finest(requester + " launching " + agent + " by " + Thread.currentThread());
            }
            return this.lifeExecutor.submit(new Callable<AbstractAgent.ReturnCode>(){

                @Override
                public AbstractAgent.ReturnCode call() {
                    return MadkitKernel.this.launchingAgent(agent, defaultGUI);
                }
            }).get(timeOutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            requester.handleInterruptedException();
            return AbstractAgent.ReturnCode.TIMEOUT;
        }
        catch (ExecutionException e) {
            this.bugReport("Launching task failed on " + agent, e);
            return AbstractAgent.ReturnCode.SEVERE;
        }
        catch (TimeoutException e) {
            return AbstractAgent.ReturnCode.TIMEOUT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractAgent.ReturnCode launchingAgent(final AbstractAgent agent, boolean defaultGUI) {
        AgentExecutor ae;
        if (!agent.state.compareAndSet(AbstractAgent.State.NOT_LAUNCHED, AbstractAgent.State.INITIALIZING) || this.shuttedDown) {
            return AbstractAgent.ReturnCode.ALREADY_LAUNCHED;
        }
        if (this.hooks != null) {
            this.informHooks(HookMessage.AgentActionEvent.AGENT_STARTED, agent.getName());
        }
        agent.setKernel(this);
        if (defaultGUI) {
            agent.createGUIOnStartUp();
        }
        Level defaultLevel = Madkit.LevelOption.agentLogLevel.getValue(this.getMadkitConfig());
        AgentLogger agentLogger = agent.logger;
        if (agentLogger == AgentLogger.defaultAgentLogger) {
            if (defaultLevel == Level.OFF) {
                agent.logger = null;
            } else {
                agent.setLogLevel(defaultLevel);
                agent.getLogger().setWarningLogLevel(Madkit.LevelOption.warningLogLevel.getValue(this.getMadkitConfig()));
            }
        }
        if ((ae = agent.getAgentExecutor()) == null) {
            AbstractAgent.ReturnCode r = AbstractAgent.ReturnCode.AGENT_CRASH;
            Future<Boolean> activationAttempt = this.lifeExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return agent.activation();
                }
            });
            try {
                r = activationAttempt.get() != false ? AbstractAgent.ReturnCode.SUCCESS : AbstractAgent.ReturnCode.AGENT_CRASH;
            }
            catch (ExecutionException e) {
                this.bugReport(agent + " activation task failed using " + Thread.currentThread(), e);
            }
            catch (InterruptedException e) {
                this.bugReport(agent + " activation task failed using " + Thread.currentThread(), e);
            }
            if (r != AbstractAgent.ReturnCode.SUCCESS) {
                AtomicReference<AbstractAgent.State> atomicReference = agent.state;
                synchronized (atomicReference) {
                    agent.state.notify();
                }
            } else if (agent.isAlive()) {
                agent.state.set(AbstractAgent.State.LIVING);
            }
            return r;
        }
        try {
            Agent a = (Agent)agent;
            Set<Agent> set = this.threadedAgents;
            synchronized (set) {
                this.threadedAgents.add(a);
            }
            ae.setThreadFactory(a.isDaemon() ? this.daemonAgentThreadFactory : this.normalAgentThreadFactory);
            if (!this.shuttedDown && ae.start().get().booleanValue()) {
                return AbstractAgent.ReturnCode.SUCCESS;
            }
            return AbstractAgent.ReturnCode.AGENT_CRASH;
        }
        catch (InterruptedException e) {
            if (!this.shuttedDown) {
                this.bugReport(e);
                return AbstractAgent.ReturnCode.SEVERE;
            }
        }
        catch (ExecutionException e) {
            if (!this.shuttedDown) {
                this.bugReport(e);
                return AbstractAgent.ReturnCode.SEVERE;
            }
        }
        catch (CancellationException e) {
            return AbstractAgent.ReturnCode.AGENT_CRASH;
        }
        return AbstractAgent.ReturnCode.TIMEOUT;
    }

    AbstractAgent.ReturnCode killAgent(AbstractAgent requester, final AbstractAgent target, final int timeOutSeconds) {
        if (target.getState().compareTo(AbstractAgent.State.ACTIVATED) < 0) {
            return AbstractAgent.ReturnCode.NOT_YET_LAUNCHED;
        }
        Future<AbstractAgent.ReturnCode> killAttempt = serviceExecutor.submit(new Callable<AbstractAgent.ReturnCode>(){

            @Override
            public AbstractAgent.ReturnCode call() {
                return MadkitKernel.this.killingAgent(target, timeOutSeconds);
            }
        });
        try {
            return killAttempt.get();
        }
        catch (InterruptedException e) {
            requester.handleInterruptedException();
            return AbstractAgent.ReturnCode.TIMEOUT;
        }
        catch (ExecutionException e) {
            this.bugReport("Kill failed: " + target, e);
            return AbstractAgent.ReturnCode.SEVERE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractAgent.ReturnCode killingAgent(AbstractAgent target, int timeOutSeconds) {
        AtomicReference<AbstractAgent.State> atomicReference = target.state;
        synchronized (atomicReference) {
            if (!target.getAlive().compareAndSet(true, false)) {
                return AbstractAgent.ReturnCode.ALREADY_KILLED;
            }
        }
        AgentExecutor ae = target.getAgentExecutor();
        if (ae != null) {
            return this.killThreadedAgent((Agent)target, ae, timeOutSeconds);
        }
        this.stopAbstractAgentProcess(AbstractAgent.State.ACTIVATED, target);
        return this.startEndBehavior(target, timeOutSeconds, false);
    }

    private void stopAbstractAgentProcess(AbstractAgent.State s, AbstractAgent target) {
        ThreadGroup group = this.normalAgentThreadFactory.getThreadGroup();
        Thread[] list = new Thread[group.activeCount()];
        group.enumerate(list);
        String threadName = target.getAgentThreadName(s);
        for (Thread t : list) {
            if (t == null || !t.getName().equals(threadName)) continue;
            this.stopAgentProcess(s, target, t);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopAgentProcess(AbstractAgent.State s, AbstractAgent target, Thread t) {
        AtomicReference<AbstractAgent.State> atomicReference = target.state;
        synchronized (atomicReference) {
            if (target.getState() == s && t.getName().equals(target.getAgentThreadName(s))) {
                if (this.logger != null) {
                    this.logger.finer("Hard kill on " + target + " " + t.getName());
                }
                t.stop(new KilledException("brutal kill"));
                if (this.logger != null) {
                    this.logger.finer("now waiting for " + (Object)((Object)s) + " to end on " + target);
                }
                try {
                    target.state.wait();
                }
                catch (InterruptedException e) {
                    this.bugReport(e);
                }
                return true;
            }
        }
        if (this.logger != null) {
            this.logger.finer((Object)((Object)s) + " already done on " + target);
        }
        return false;
    }

    final AbstractAgent.ReturnCode startEndBehavior(final AbstractAgent target, int timeOutSeconds, boolean asDaemon) {
        ThreadPoolExecutor executor;
        AbstractAgent.ReturnCode r = AbstractAgent.ReturnCode.SUCCESS;
        ThreadPoolExecutor threadPoolExecutor = executor = asDaemon ? serviceExecutor : this.lifeExecutor;
        if (timeOutSeconds != 0) {
            Future<Boolean> endAttempt = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return target.ending();
                }
            });
            try {
                endAttempt.get(timeOutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("----------------------\n\n---------------------------------------------");
            }
            catch (ExecutionException e) {
                this.bugReport("Killing task failed on " + target, e);
            }
            catch (TimeoutException e) {
                r = AbstractAgent.ReturnCode.TIMEOUT;
                this.stopAbstractAgentProcess(AbstractAgent.State.ENDING, target);
            }
        }
        if (target.getAgentExecutor() == null) {
            target.terminate();
        }
        return r;
    }

    private final AbstractAgent.ReturnCode killThreadedAgent(Agent target, AgentExecutor ae, int timeOutSeconds) {
        Future<?> end = ae.getEndProcess();
        if (timeOutSeconds == 0) {
            end.cancel(false);
        }
        ae.getLiveProcess().cancel(false);
        ae.getActivate().cancel(false);
        Thread.yield();
        target.myThread.setPriority(1);
        AbstractAgent.ReturnCode result = AbstractAgent.ReturnCode.SUCCESS;
        if (!this.stopAgentProcess(AbstractAgent.State.ACTIVATED, target, target.myThread)) {
            this.stopAgentProcess(AbstractAgent.State.LIVING, target, target.myThread);
        }
        if (timeOutSeconds != 0) {
            try {
                end.get(timeOutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (CancellationException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                this.bugReport("kill task failed on " + target, e);
            }
            catch (TimeoutException e) {
                result = AbstractAgent.ReturnCode.TIMEOUT;
            }
        }
        this.stopAgentProcess(AbstractAgent.State.ENDING, target, target.myThread);
        try {
            ae.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.bugReport(e);
        }
        return result;
    }

    private final Organization getCommunity(String community) throws CGRNotAvailable {
        Organization org = this.organizations.get(community);
        if (org == null) {
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_COMMUNITY);
        }
        return org;
    }

    final Group getGroup(String community, String group) throws CGRNotAvailable {
        Group g = (Group)this.getCommunity(community).get(group);
        if (g == null) {
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_GROUP);
        }
        return g;
    }

    final Role getRole(String community, String group, String role) throws CGRNotAvailable {
        Role r = (Role)this.getGroup(community, group).get(role);
        if (r == null) {
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_ROLE);
        }
        return r;
    }

    final List<AgentAddress> getOtherRolePlayers(AbstractAgent abstractAgent, String community, String group, String role) throws CGRNotAvailable {
        List<AgentAddress> result = this.getRole(community, group, role).getAgentAddressesCopy();
        Role.removeAgentAddressOf(abstractAgent, result);
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    final AgentAddress getAnotherRolePlayer(AbstractAgent abstractAgent, String community, String group, String role) throws CGRNotAvailable {
        List<AgentAddress> others = this.getOtherRolePlayers(abstractAgent, community, group, role);
        if (others != null) {
            return others.get((int)(Math.random() * (double)others.size()));
        }
        return null;
    }

    private AbstractAgent.ReturnCode buildAndSendMessage(AgentAddress sender, AgentAddress receiver, Message m) {
        m.setSender(sender);
        m.setReceiver(receiver);
        AbstractAgent.ReturnCode r = this.sendMessage(m, receiver.getAgent());
        if (this.logger != null && r == AbstractAgent.ReturnCode.SUCCESS) {
            this.informHooks(HookMessage.AgentActionEvent.SEND_MESSAGE, m);
        }
        return r;
    }

    private final AgentAddress getSenderAgentAddress(AbstractAgent sender, AgentAddress receiver, String senderRole) throws CGRNotAvailable {
        AgentAddress senderAA = null;
        Role targetedRole = receiver.getRoleObject();
        if (senderRole == null) {
            senderAA = targetedRole.getAgentAddressInGroup(sender);
            if (senderAA == null) {
                if (targetedRole.getRoleName().equals("manager")) {
                    return new CandidateAgentAddress(sender, targetedRole, this.kernelAddress);
                }
                throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_IN_GROUP);
            }
            return senderAA;
        }
        Role senderRoleObject = (Role)targetedRole.getMyGroup().get(senderRole);
        if (senderRoleObject != null) {
            senderAA = senderRoleObject.getAgentAddressOf(sender);
        }
        if (senderAA == null) {
            if (senderRole.equals("candidate") && targetedRole.getRoleName().equals("manager")) {
                return new CandidateAgentAddress(sender, targetedRole, this.kernelAddress);
            }
            if (targetedRole.getAgentAddressInGroup(sender) == null) {
                throw new CGRNotAvailable(AbstractAgent.ReturnCode.NOT_IN_GROUP);
            }
            throw new CGRNotAvailable(AbstractAgent.ReturnCode.ROLE_NOT_HANDLED);
        }
        return senderAA;
    }

    synchronized boolean addOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        if (this.operatingOverlookers.add(o)) {
            try {
                this.getRole(o.getCommunity(), o.getGroup(), o.getRole()).addOverlooker(o);
            }
            catch (CGRNotAvailable cGRNotAvailable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    synchronized boolean removeOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        Role r = o.getOverlookedRole();
        if (r != null) {
            r.removeOverlooker(o);
        }
        return this.operatingOverlookers.remove(o);
    }

    void removeCommunity(String community) {
        this.organizations.remove(community);
    }

    @Override
    public KernelAddress getKernelAddress() {
        return this.kernelAddress;
    }

    Set<Overlooker<? extends AbstractAgent>> getOperatingOverlookers() {
        return this.operatingOverlookers;
    }

    void removeAgentFromOrganizations(AbstractAgent theAgent) {
        for (Organization org : this.organizations.values()) {
            for (String groupName : org.removeAgentFromAllGroups(theAgent)) {
                this.sendNetworkMessageWithRole(new CGRSynchro(CGRSynchro.Code.LEAVE_GROUP, new AgentAddress(theAgent, new Role(org.getName(), groupName), this.kernelAddress)), this.netUpdater);
            }
        }
    }

    @Override
    public Properties getMadkitConfig() {
        return this.platform.getConfigOption();
    }

    @Override
    MadkitKernel getMadkitKernel() {
        return this;
    }

    boolean isCommunity(AbstractAgent requester, String community) {
        try {
            return this.getCommunity(community) != null;
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    boolean isGroup(AbstractAgent requester, String community, String group) {
        try {
            return this.getGroup(community, group) != null;
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    boolean isRole(AbstractAgent requester, String community, String group, String role) {
        try {
            return this.getRole(community, group, role) != null;
        }
        catch (CGRNotAvailable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void importDistantOrg(Map<String, Map<String, Map<String, Set<AgentAddress>>>> distantOrg) {
        if (this.logger != null) {
            this.logger.finer("Importing org..." + distantOrg);
        }
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            for (String communityName : distantOrg.keySet()) {
                Organization org;
                Organization previous = this.organizations.putIfAbsent(communityName, org = new Organization(communityName, this));
                if (previous != null) {
                    org = previous;
                }
                org.importDistantOrg(distantOrg.get(communityName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Map<String, Map<String, Set<AgentAddress>>>> getOrganizationSnapShot(boolean global) {
        TreeMap<String, Map<String, Map<String, Set<AgentAddress>>>> export = new TreeMap<String, Map<String, Map<String, Set<AgentAddress>>>>();
        ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, Organization> org : this.organizations.entrySet()) {
                Map<String, Map<String, Set<AgentAddress>>> currentOrg = org.getValue().getOrgMap(global);
                if (currentOrg.isEmpty()) continue;
                export.put(org.getKey(), org.getValue().getOrgMap(global));
            }
        }
        return export;
    }

    @Override
    public MadkitClassLoader getMadkitClassLoader() {
        return this.platform.getMadkitClassLoader();
    }

    final void injectMessage(ObjectMessage<Message> m) {
        Message toInject = m.getContent();
        AgentAddress receiver = toInject.getReceiver();
        AgentAddress sender = toInject.getSender();
        try {
            Role receiverRole = this.kernel.getRole(receiver.getCommunity(), receiver.getGroup(), receiver.getRole());
            receiver.setRoleObject(receiverRole);
            if (receiverRole != null) {
                AbstractAgent target = receiverRole.getAbstractAgentWithAddress(receiver);
                if (target != null) {
                    sender.setRoleObject(this.kernel.getRole(sender.getCommunity(), sender.getGroup(), sender.getRole()));
                    target.receiveMessage(toInject);
                } else if (this.logger != null) {
                    this.logger.finer(m + " received but the agent address is no longer valid !! Current distributed org is " + this.getOrganizationSnapShot(false));
                }
            }
        }
        catch (CGRNotAvailable e) {
            this.kernel.bugReport("Cannot inject " + m + "\n" + this.getOrganizationSnapShot(false), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void injectOperation(CGRSynchro m) {
        block14: {
            Role r = ((AgentAddress)m.getContent()).getRoleObject();
            if (r == null) {
                if (this.logger != null) {
                    this.logger.log(Level.FINE, "distant CGR " + (Object)((Object)m.getCode()) + " update failed on " + m.getContent());
                }
                return;
            }
            String communityName = r.getCommunityName();
            String groupName = r.getGroupName();
            String roleName = r.getRoleName();
            try {
                ConcurrentHashMap<String, Organization> concurrentHashMap = this.organizations;
                synchronized (concurrentHashMap) {
                    switch (m.getCode()) {
                        case CREATE_GROUP: {
                            Organization organization = this.getCommunity(communityName);
                            if (organization == null) {
                                organization = new Organization(communityName, this);
                                this.organizations.put(communityName, organization);
                            }
                            if (organization.putIfAbsent(groupName, new Group(communityName, groupName, (AgentAddress)m.getContent(), null, organization)) != null || this.logger == null) break;
                            this.informHooks(HookMessage.AgentActionEvent.CREATE_GROUP, communityName, groupName, m.getContent());
                            break;
                        }
                        case REQUEST_ROLE: {
                            this.getGroup(communityName, groupName).addDistantMember((AgentAddress)m.getContent());
                            if (this.logger == null) break;
                            this.informHooks(HookMessage.AgentActionEvent.REQUEST_ROLE, communityName, groupName, roleName, m.getContent());
                            break;
                        }
                        case LEAVE_ROLE: {
                            this.getRole(communityName, groupName, roleName).removeDistantMember((AgentAddress)m.getContent());
                            if (this.logger == null) break;
                            this.informHooks(HookMessage.AgentActionEvent.LEAVE_ROLE, communityName, groupName, roleName, m.getContent());
                            break;
                        }
                        case LEAVE_GROUP: {
                            this.getGroup(communityName, groupName).removeDistantMember((AgentAddress)m.getContent());
                            if (this.logger == null) break;
                            this.informHooks(HookMessage.AgentActionEvent.LEAVE_GROUP, communityName, groupName, m.getContent());
                            break;
                        }
                        default: {
                            this.bugReport(new UnsupportedOperationException("case not treated in injectOperation"));
                        }
                    }
                }
            }
            catch (CGRNotAvailable e) {
                if (this.logger == null) break block14;
                this.logger.log(Level.FINE, "distant CGR " + (Object)((Object)m.getCode()) + " update failed on " + m.getContent(), e);
            }
        }
    }

    private void exit() {
        if (ActionInfo.javawsIsOn) {
            System.exit(0);
        }
        this.shuttedDown = true;
        this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.EXIT, new Object[0]), this.kernelRole);
        this.broadcastMessageWithRole(this, "local", "gui", "manager", new KernelMessage(KernelAction.EXIT, new Object[0]), null);
        if (this.logger != null) {
            this.logger.finer("***** SHUTINGDOWN MADKIT ********\n");
        }
        this.killAgents(true);
    }

    private void launchNetwork() {
        this.updateNetworkAgent();
        if (this.netAgent == null) {
            NetworkAgent na = new NetworkAgent();
            AbstractAgent.ReturnCode r = this.launchAgent(na);
            this.threadedAgents.remove(na);
            if (r == AbstractAgent.ReturnCode.SUCCESS) {
                if (this.logger != null) {
                    this.logger.fine("\n\t****** Network agent launched ******\n");
                }
            } else if (this.logger != null) {
                this.logger.severe("\n\t****** Problem launching network agent ******\n");
            }
        } else if (this.sendNetworkMessageWithRole(new KernelMessage(KernelAction.LAUNCH_NETWORK, new Object[0]), this.kernelRole) == AbstractAgent.ReturnCode.SUCCESS) {
            if (this.logger != null) {
                this.logger.fine("\n\t****** Network agent up ******\n");
            }
        } else if (this.logger != null) {
            this.logger.fine("\n\t****** Problem relaunching network ******\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAgents(boolean untilEmpty) {
        ArrayList<Agent> l;
        this.threadedAgents.remove(this);
        Set<Agent> set = this.threadedAgents;
        synchronized (set) {
            l = new ArrayList<Agent>(this.threadedAgents);
        }
        do {
            for (Agent a : l) {
                this.killAgent(this, a, 0);
            }
        } while (untilEmpty && !this.threadedAgents.isEmpty());
    }

    boolean createGroupIfAbsent(AbstractAgent abstractAgent, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        return this.createGroup(abstractAgent, community, group, gatekeeper, isDistributed) == AbstractAgent.ReturnCode.SUCCESS;
    }

    private void bugReport(Throwable e) {
        this.bugReport("", e);
    }

    private void bugReport(String m, Throwable e) {
        this.getMadkitKernel().getLogger().severeLog("********************** KERNEL PROBLEM, please bug report " + m, e);
    }

    final synchronized void removeAgentsFromDistantKernel(KernelAddress kernelAddress2) {
        for (Organization org : this.organizations.values()) {
            org.removeAgentsFromDistantKernel(kernelAddress2);
        }
    }

    synchronized AbstractAgent.ReturnCode destroyCommunity(AbstractAgent abstractAgent, String community) {
        try {
            this.getCommunity(community).destroy();
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    synchronized AbstractAgent.ReturnCode destroyGroup(AbstractAgent abstractAgent, String community, String group) {
        try {
            this.getGroup(community, group).destroy();
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    synchronized AbstractAgent.ReturnCode destroyRole(AbstractAgent abstractAgent, String community, String group, String role) {
        try {
            this.getRole(community, group, role).destroy();
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        catch (CGRNotAvailable e) {
            return e.getCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThreadedAgent(Agent myAgent) {
        Set<Agent> set = this.threadedAgents;
        synchronized (set) {
            this.threadedAgents.remove(myAgent);
            if (this.logger != null) {
                this.logger.finest(this.threadedAgents.toString());
            }
        }
    }

    AgentAddress getAgentAddressIn(AbstractAgent agent, String community, String group, String role) {
        try {
            return this.getRole(community, group, role).getAgentAddressOf(agent);
        }
        catch (CGRNotAvailable e) {
            if (agent.isWarningOn()) {
                agent.setAgentStackTrace(e);
                agent.handleException(AbstractAgent.Influence.GET_AGENT_ADDRESS_IN, new OrganizationWarning(e.getCode(), community, group, role));
            }
            return null;
        }
    }

    final boolean isHooked() {
        return this.hooks != null;
    }

    static {
        serviceExecutor.prestartAllCoreThreads();
        serviceExecutor.allowCoreThreadTimeOut(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AgentLogger.resetLoggers();
            }
        });
    }
}

