/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import madkit.gui.MASModel;
import madkit.gui.menu.LaunchAgentsMenu;
import madkit.gui.menu.LaunchMAS;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentLogger;
import madkit.kernel.Madkit;

public final class MadkitClassLoader
extends URLClassLoader {
    private Collection<String> classesToReload;
    private final Madkit madkit;
    private Set<String> agentClasses = new TreeSet<String>();
    private Set<MASModel> demos = new HashSet<MASModel>();
    private Set<URL> scannedURLs = new HashSet<URL>();

    MadkitClassLoader(Madkit m, URL[] urls, ClassLoader parent, Collection<String> toReload) {
        super(urls, parent);
        if (toReload != null) {
            this.classesToReload = new HashSet<String>(toReload);
        }
        this.madkit = m;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (this.classesToReload != null && this.classesToReload.contains(name)) {
            c = this.findLoadedClass(name);
            if (c == null) {
                this.addUrlAndloadClasses(name);
                this.classesToReload = null;
                return this.loadClass(name, resolve);
            }
            AgentLogger l = this.madkit.getKernel().logger;
            if (l != null) {
                l.log(Level.FINE, "Already defined " + name + " : NEED NEW MCL");
            }
            MadkitClassLoader mcl = new MadkitClassLoader(this.madkit, this.getURLs(), (ClassLoader)this, this.classesToReload);
            mcl.scannedURLs = this.scannedURLs;
            mcl.agentClasses = this.agentClasses;
            mcl.demos = this.demos;
            this.classesToReload.remove(name);
            this.madkit.setMadkitClassLoader(mcl);
            c = mcl.loadClass(name, resolve);
        } else {
            c = this.findLoadedClass(name);
        }
        if (c == null) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public boolean reloadClass(String name) throws ClassNotFoundException {
        if (this.getResource(name.replace('.', '/') + ".class") == null) {
            throw new ClassNotFoundException(name);
        }
        if (this.classesToReload == null) {
            this.classesToReload = new HashSet<String>();
        }
        this.classesToReload.add(name);
        return true;
    }

    public Class<?> getNewestClassVersion(String className) throws ClassNotFoundException {
        return this.loadClass(className);
    }

    void loadJarsFromPath(String path) {
        File demoDir = new File(path);
        if (demoDir.isDirectory()) {
            for (File f : demoDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar");
                }
            })) {
                try {
                    this.addToClasspath(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addUrlAndloadClasses(String name) {
        URL url = this.getResource("/" + name.replace('.', '/') + ".class");
        if (url != null) {
            String packageName = MadkitClassLoader.getClassPackageName(name);
            packageName = packageName == null ? "" : packageName + '.';
            int deepness = packageName.split("\\.").length;
            String urlPath = url.getPath();
            File packageDir = new File(urlPath.substring(0, urlPath.lastIndexOf(47)));
            File cpDir = new File(urlPath.substring(0, urlPath.lastIndexOf(47)));
            for (int i = 0; i < deepness; ++i) {
                cpDir = cpDir.getParentFile();
            }
            for (String fileName : packageDir.list()) {
                if (!fileName.endsWith(".class")) continue;
                try {
                    this.findClass(packageName + fileName.substring(0, fileName.length() - 6));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getClassPackageName(String classFullName) {
        int index = classFullName.lastIndexOf(46);
        return index > 0 ? classFullName.substring(0, index) : null;
    }

    public static String getClassSimpleName(String classFullName) {
        int index = classFullName.lastIndexOf(46);
        return index > 0 ? classFullName.substring(index + 1, classFullName.length()) : classFullName;
    }

    private void scanClassPathForAgentClasses() {
        if (this.scannedURLs == null) {
            this.scannedURLs = new HashSet<URL>();
            this.agentClasses = new TreeSet<String>();
        }
        for (URL dir : this.getURLs()) {
            if (!this.scannedURLs.add(dir)) continue;
            if (dir.toString().contains("rsrc")) {
                if (!dir.toString().contains("jar:rsrc:")) continue;
                File f = new File(this.madkit.getConfigOption().getProperty("Project-Code-Name") + "-" + this.madkit.getConfigOption().getProperty("Project-Version") + ".jar");
                if (f.exists()) {
                    try {
                        dir = new URL(f.toURI().toURL().toString());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (dir.toString().endsWith(".jar")) {
                try {
                    JarFile jarFile = ((JarURLConnection)new URL("jar:" + dir + "!/").openConnection()).getJarFile();
                    this.scanJarFileForLaunchConfig(jarFile);
                    this.agentClasses.addAll(this.scanJarFileForAgentClasses(jarFile));
                }
                catch (IOException e) {}
                continue;
            }
            this.agentClasses.addAll(this.scanFolderForAgentClasses(new File(dir.getFile()), null));
        }
    }

    public void addToClasspath(URL url) {
        this.addURL(url);
        LaunchAgentsMenu.updateAllMenus();
        LaunchMAS.updateAllMenus();
    }

    public Set<MASModel> getAvailableConfigurations() {
        this.scanClassPathForAgentClasses();
        if (this.demos != null) {
            return new HashSet<MASModel>(this.demos);
        }
        return Collections.emptySet();
    }

    public Set<String> getAllAgentClasses() {
        this.scanClassPathForAgentClasses();
        return new TreeSet<String>(this.agentClasses);
    }

    void addMASConfig(MASModel session) {
        this.demos.add(session);
    }

    private void scanJarFileForLaunchConfig(JarFile jarFile) {
        Attributes projectInfo = null;
        try {
            projectInfo = jarFile.getManifest().getAttributes("MaDKit-Project-Info");
        }
        catch (IOException e) {
            return;
        }
        if (projectInfo != null) {
            MASModel mas = new MASModel(projectInfo.getValue("Project-Name").trim(), projectInfo.getValue("MaDKit-Args").split(" "), projectInfo.getValue("Description").trim());
            if (this.demos == null) {
                this.demos = new HashSet<MASModel>();
            }
            this.demos.add(mas);
            Logger l = this.madkit.getLogger();
            if (l != null) {
                l.finest("found MAS config info " + mas);
            }
        }
    }

    private List<String> scanJarFileForAgentClasses(JarFile jarFile) {
        ArrayList<String> l = new ArrayList<String>(50);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String className;
            JarEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class") || !this.isAgentClass(className = this.fileNameToClassName(entry.getName(), null))) continue;
            l.add(this.fileNameToClassName(entry.getName(), null));
        }
        return l;
    }

    private List<String> scanFolderForAgentClasses(File file, String pckName) {
        File[] files = file.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> l = new ArrayList<String>();
        for (File f : files) {
            String className;
            if (f.isDirectory()) {
                l.addAll(this.scanFolderForAgentClasses(f, pckName == null ? f.getName() : pckName + "." + f.getName()));
                continue;
            }
            if (!f.getName().endsWith(".class") || !this.isAgentClass(className = (pckName == null ? "" : pckName + ".") + f.getName().replace(".class", ""))) continue;
            l.add(className);
        }
        return l;
    }

    private boolean isAgentClass(String className) {
        try {
            Class<?> cl = this.loadClass(className);
            if (cl != null && AbstractAgent.class.isAssignableFrom(cl) && cl.getConstructor(null) != null && !Modifier.isAbstract(cl.getModifiers()) && Modifier.isPublic(cl.getModifiers())) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private String fileNameToClassName(String file, String classPathRoot) {
        if (classPathRoot != null) {
            file = file.replace(classPathRoot, "");
        }
        return file.substring(0, file.length() - 6).replace(File.separatorChar, '.');
    }
}

