/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import madkit.action.ActionInfo;
import madkit.action.KernelAction;
import madkit.gui.MASModel;
import madkit.i18n.ErrorMessages;
import madkit.i18n.Words;
import madkit.kernel.AgentLogger;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitKernel;
import madkit.kernel.MadkitOption;
import madkit.message.KernelMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Madkit {
    private static final String MDK_LOGGER_NAME = "[* MADKIT*] ";
    static final Properties defaultConfig = new Properties();
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    public static final String VERSION;
    public static final String BUILD_ID;
    private final Properties madkitConfig = new Properties();
    private Element madkitXMLConfigFile = null;
    private final MadkitKernel myKernel;
    private Logger logger;
    private MadkitClassLoader madkitClassLoader;
    String[] args;

    MadkitClassLoader getMadkitClassLoader() {
        return this.madkitClassLoader;
    }

    public static void main(String[] options) {
        new Madkit(options);
    }

    public void doAction(KernelAction action, Object ... parameters) {
        if (this.myKernel.isAlive()) {
            this.myKernel.receiveMessage(new KernelMessage(action, parameters));
        } else if (this.logger != null) {
            this.logger.severe("my kernel is terminated...");
        }
    }

    public Madkit(String ... options) {
        if (options != null && options.length == 1 && options[0].contains(" ")) {
            options = options[0].trim().split(" ");
        }
        String[] stringArray = this.args = options != null && options.length != 0 ? options : null;
        if (ActionInfo.javawsIsOn) {
            Policy.setPolicy(this.getAllPermissionPolicy());
        }
        this.madkitConfig.putAll((Map<?, ?>)defaultConfig);
        Properties fromArgs = this.buildConfigFromArgs(this.args);
        this.madkitConfig.putAll((Map<?, ?>)fromArgs);
        this.initMadkitLogging();
        if (this.logger != null) {
            this.logger.finer("command line args : " + fromArgs);
        }
        this.loadJarFileArguments();
        this.loadConfigFile();
        if (this.logger != null) {
            this.logger.fine("** OVERRIDING WITH COMMAND LINE ARGUMENTS **");
        }
        this.madkitConfig.putAll((Map<?, ?>)fromArgs);
        if (this.madkitConfig.get(Option.launchAgents.name()).equals("null")) {
            if (this.logger != null) {
                this.logger.fine(Option.launchAgents.name() + " null : Activating desktop");
            }
            this.madkitConfig.setProperty(BooleanOption.desktop.name(), "true");
        }
        String logDirKey = Option.logDirectory.name();
        this.madkitConfig.setProperty(logDirKey, this.madkitConfig.getProperty(logDirKey) + File.separator + dateFormat.format(new Date()));
        this.myKernel = new MadkitKernel(this);
        if (this.logger != null) {
            this.logger.finer("**  MADKIT KERNEL CREATED **");
        }
        this.printWelcomeString();
        this.buildMadkitClassLoader();
        this.logSessionConfig(this.madkitConfig, Level.FINER);
        if (this.madkitClassLoader.getAvailableConfigurations().isEmpty() && !this.madkitConfig.get(Option.launchAgents.name()).equals("null")) {
            this.madkitClassLoader.addMASConfig(new MASModel(Words.INITIAL_CONFIG.toString(), this.args, "desc"));
        }
        this.startKernel();
    }

    private Policy getAllPermissionPolicy() {
        Policy policy = new Policy(){
            private PermissionCollection m_permissionCollection;

            @Override
            public PermissionCollection getPermissions(CodeSource p_codesource) {
                return this.getAllPermissionCollection();
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain p_domain) {
                return this.getAllPermissionCollection();
            }

            private PermissionCollection getAllPermissionCollection() {
                if (this.m_permissionCollection == null) {
                    this.m_permissionCollection = new AllPermission().newPermissionCollection();
                    this.m_permissionCollection.add(new AllPermission());
                }
                return this.m_permissionCollection;
            }
        };
        return policy;
    }

    private void loadJarFileArguments() {
        Object[] options = null;
        if (this.logger != null) {
            this.logger.fine("** LOADING JAR FILE ARGUMENTS **");
        }
        try {
            Enumeration<URL> urls = Madkit.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                Manifest manifest = new Manifest(urls.nextElement().openStream());
                Attributes projectInfo = manifest.getAttributes("MaDKit-Project-Info");
                if (projectInfo == null) continue;
                if (this.logger != null) {
                    this.logger.finest("found project info \n\t" + projectInfo.keySet() + "\n\t" + projectInfo.values());
                }
                options = projectInfo.getValue("MaDKit-Args").split(" ");
                if (this.logger != null) {
                    this.logger.finer(Arrays.deepToString(options) + options.length);
                }
                HashMap<String, String> projectInfos = new HashMap<String, String>();
                projectInfos.put("Project-Code-Name", projectInfo.getValue("Project-Code-Name"));
                projectInfos.put("Project-Version", projectInfo.getValue("Project-Version"));
                this.madkitConfig.putAll((Map<?, ?>)this.buildConfigFromArgs((String[])options));
                this.madkitConfig.putAll((Map<?, ?>)projectInfos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildMadkitClassLoader() {
        ClassLoader systemCL;
        if (this.logger != null) {
            this.logger.finer("** BUILDING MADKIT CLASS LOADER **");
        }
        this.madkitClassLoader = (systemCL = this.getClass().getClassLoader()) instanceof URLClassLoader ? new MadkitClassLoader(this, ((URLClassLoader)systemCL).getURLs(), systemCL, null) : new MadkitClassLoader(this, new URL[0], systemCL, null);
        if (this.logger != null) {
            this.logger.finer("ClassPath is:\n" + this.madkitClassLoader);
            this.logger.fine("** MADKIT CLASS LOADER INITIALIZED **");
        }
    }

    private void initMadkitLogging() {
        Level l = LevelOption.madkitLogLevel.getValue(this.madkitConfig);
        if (l != Level.OFF) {
            this.logger = Logger.getLogger(MDK_LOGGER_NAME);
            this.logger.setUseParentHandlers(false);
            this.logger.setLevel(l);
            ConsoleHandler cs = new ConsoleHandler();
            cs.setLevel(this.logger.getLevel());
            cs.setFormatter(AgentLogger.AGENT_FORMATTER);
            this.logger.addHandler(cs);
            this.logger.fine("** LOGGING INITIALIZED **");
        }
    }

    private void loadConfigFile() {
        block14: {
            InputStream url;
            String fileName = this.madkitConfig.getProperty(Option.configFile.name());
            if (fileName.equals("null")) {
                return;
            }
            if (this.logger != null) {
                this.logger.fine("** Loading config file " + fileName + " **");
            }
            if ((url = this.getClass().getClassLoader().getResourceAsStream(fileName)) != null) {
                try {
                    this.madkitXMLConfigFile = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(url).getDocumentElement();
                    NodeList madkitOptionNodes = this.madkitXMLConfigFile.getElementsByTagName("madkitOptions");
                    for (int i = 0; i < madkitOptionNodes.getLength(); ++i) {
                        NamedNodeMap options = madkitOptionNodes.item(i).getAttributes();
                        for (int j = 0; j < options.getLength(); ++j) {
                            this.madkitConfig.put(options.item(j).getNodeName(), options.item(j).getNodeValue());
                        }
                    }
                    if (this.logger != null) {
                        this.logger.fine("** Config file " + fileName + " successfully loaded **\n");
                    }
                    break block14;
                }
                catch (SAXException e) {
                    if (this.logger != null) {
                        this.logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_LOAD) + " configuration " + fileName, e);
                    }
                    break block14;
                }
                catch (IOException e) {
                    if (this.logger != null) {
                        this.logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_LOAD) + " configuration " + fileName, e);
                    }
                    break block14;
                }
                catch (ParserConfigurationException e) {
                    if (this.logger != null) {
                        this.logger.log(Level.WARNING, (Object)((Object)ErrorMessages.CANT_LOAD) + " configuration " + fileName, e);
                    }
                    break block14;
                }
            }
            if (this.logger != null) {
                this.logger.warning((Object)((Object)ErrorMessages.CANT_FIND) + " configuration " + fileName);
            }
        }
    }

    private void startKernel() {
        if (this.logger != null) {
            this.logger.fine("** LAUNCHING KERNEL AGENT **");
        }
        this.myKernel.launchAgent(this.myKernel, this.myKernel, Integer.MAX_VALUE, false);
    }

    private void printWelcomeString() {
        if (LevelOption.madkitLogLevel.getValue(this.madkitConfig) != Level.OFF) {
            System.err.println("\n\t---------------------------------------\n\t                MaDKit\n\t           version: " + defaultConfig.getProperty("madkit.version") + "\n\t        build-id: " + defaultConfig.getProperty("build.id") + "\n\t       MaDKit Team (c) 1997-" + Calendar.getInstance().get(1) + "\n\t---------------------------------------\n");
        }
    }

    private void logSessionConfig(Properties session, Level lvl) {
        if (this.logger != null) {
            String message = "MaDKit current configuration is\n\n";
            message = message + "\t--- MaDKit regular options ---\n";
            for (String option : defaultConfig.stringPropertyNames()) {
                message = message + "\t" + String.format("%-30s", option) + session.getProperty(option) + "\n";
            }
            HashSet<Object> tmp = new HashSet<Object>(session.keySet());
            tmp.removeAll(defaultConfig.keySet());
            if (tmp.size() > 0) {
                message = message + "\n\t--- Additional non MaDKit options ---\n";
                for (Object e : tmp) {
                    message = message + "\t" + String.format("%-25s", e) + session.get(e) + "\n";
                }
            }
            this.logger.log(lvl, message);
        }
    }

    Properties buildConfigFromArgs(String[] options) {
        Properties currentMap = new Properties();
        if (options != null && options.length > 0) {
            String parameters = "";
            String currentOption = null;
            for (int i = 0; i < options.length; ++i) {
                if (options[i].trim().isEmpty()) continue;
                if (options[i].startsWith("--")) {
                    currentOption = options[i].substring(2);
                    currentMap.put(currentOption, "true");
                    if (this.logger != null) {
                        this.logger.finest("found option -- " + currentOption);
                    }
                    parameters = "";
                    continue;
                }
                parameters = parameters + options[i] + " ";
                if (i + 1 != options.length && !options[i + 1].startsWith("--")) continue;
                currentMap.put(currentOption, parameters.trim());
                if (this.logger == null) continue;
                this.logger.finest("found option -- " + currentOption + " -- value -- " + parameters.trim());
            }
            if (this.logger != null) {
                this.logger.finest("build temp map is " + currentMap);
            }
        }
        return currentMap;
    }

    Logger getLogger() {
        return this.logger;
    }

    Properties getConfigOption() {
        return this.madkitConfig;
    }

    MadkitKernel getKernel() {
        return this.myKernel;
    }

    final void setMadkitClassLoader(MadkitClassLoader madkitClassLoader) {
        this.madkitClassLoader = madkitClassLoader;
    }

    static {
        try {
            defaultConfig.load(Madkit.class.getResourceAsStream("madkit.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VERSION = defaultConfig.getProperty("madkit.version");
        BUILD_ID = defaultConfig.getProperty("build.id");
    }

    public static enum BooleanOption implements MadkitOption
    {
        desktop,
        autoConnectMadkitWebsite,
        network,
        createLogFiles,
        noAgentConsoleLog,
        console,
        loadLocalDemos;


        public boolean isActivated(Properties session) {
            return Boolean.parseBoolean(session.getProperty(this.name()));
        }

        @Override
        public String toString() {
            return "--" + this.name();
        }
    }

    public static enum LevelOption implements MadkitOption
    {
        agentLogLevel,
        kernelLogLevel,
        guiLogLevel,
        madkitLogLevel,
        warningLogLevel,
        networkLogLevel;


        Level getValue(Properties session) {
            try {
                return Level.parse(session.getProperty(this.name()));
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(Madkit.MDK_LOGGER_NAME).log(Level.SEVERE, ErrorMessages.OPTION_MISUSED.toString() + " " + this.name() + " : " + session.getProperty(this.name()), e);
                return Level.ALL;
            }
        }

        @Override
        public String toString() {
            return "--" + this.name();
        }
    }

    public static enum Option implements MadkitOption
    {
        launchAgents,
        logDirectory,
        configFile;


        @Override
        public String toString() {
            return "--" + this.name();
        }
    }
}

