/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRNotAvailable;
import madkit.kernel.Gatekeeper;
import madkit.kernel.MadkitKernel;
import madkit.kernel.MadkitWarning;
import madkit.kernel.Message;
import madkit.kernel.OrganizationWarning;
import madkit.kernel.Overlooker;

final class LoggedKernel
extends MadkitKernel {
    private static final long serialVersionUID = 8002356811073647875L;

    LoggedKernel(MadkitKernel k) {
        super(k);
        this.loggedKernel = this;
    }

    @Override
    AbstractAgent.ReturnCode createGroup(AbstractAgent requester, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        AbstractAgent.ReturnCode r = this.kernel.createGroup(requester, community, group, gatekeeper, isDistributed);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, AbstractAgent.Influence.CREATE_GROUP.successString() + I18nUtilities.getCGRString(community, group) + "distribution " + (isDistributed ? "ON" : "OFF") + " with " + (gatekeeper == null ? "no access control " : gatekeeper.toString() + " as gatekeeper "));
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            requester.handleException(AbstractAgent.Influence.CREATE_GROUP, new OrganizationWarning(r, community, group, null));
        }
        return r;
    }

    @Override
    boolean createGroupIfAbsent(AbstractAgent requester, String community, String group, Gatekeeper gatekeeper, boolean isDistributed) {
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, "createGroupIfAbsent" + I18nUtilities.getCGRString(community, group) + "distribution " + (isDistributed ? "ON" : "OFF") + " with " + (gatekeeper == null ? "no access control" : gatekeeper.toString() + " for access control"));
        }
        return this.kernel.createGroup(requester, community, group, gatekeeper, isDistributed) == AbstractAgent.ReturnCode.SUCCESS;
    }

    @Override
    AbstractAgent.ReturnCode requestRole(AbstractAgent requester, String community, String group, String role, Object memberCard) {
        AbstractAgent.ReturnCode r = this.kernel.requestRole(requester, community, group, role, memberCard);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, AbstractAgent.Influence.REQUEST_ROLE.successString() + I18nUtilities.getCGRString(community, group, role) + "using " + memberCard + " as passKey");
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            requester.handleException(AbstractAgent.Influence.REQUEST_ROLE, new OrganizationWarning(r, community, group, role));
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode leaveGroup(AbstractAgent requester, String community, String group) {
        AbstractAgent.ReturnCode r = this.kernel.leaveGroup(requester, community, group);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, "leaveGroup" + I18nUtilities.getCGRString(community, group));
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            requester.handleException(AbstractAgent.Influence.LEAVE_GROUP, new OrganizationWarning(r, community, group, null));
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode leaveRole(AbstractAgent requester, String community, String group, String role) {
        AbstractAgent.ReturnCode r = this.kernel.leaveRole(requester, community, group, role);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, "leaveRole" + I18nUtilities.getCGRString(community, group, role));
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            requester.handleException(AbstractAgent.Influence.LEAVE_ROLE, new OrganizationWarning(r, community, group, role));
        }
        return r;
    }

    @Override
    List<AgentAddress> getAgentsWithRole(AbstractAgent requester, String community, String group, String role, boolean callerIncluded) {
        try {
            List<AgentAddress> result = callerIncluded ? this.kernel.getRole(community, group, role).getAgentAddressesCopy() : this.kernel.getOtherRolePlayers(requester, community, group, role);
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.GET_AGENTS_WITH_ROLE) + I18nUtilities.getCGRString(community, group, role) + ": " + result);
            }
            return result;
        }
        catch (CGRNotAvailable e) {
            if (requester.isWarningOn()) {
                requester.handleException(AbstractAgent.Influence.GET_AGENTS_WITH_ROLE, new OrganizationWarning(e.getCode(), community, group, role));
            }
            return null;
        }
    }

    @Override
    AgentAddress getAgentWithRole(AbstractAgent requester, String community, String group, String role) {
        try {
            AgentAddress result = this.kernel.getAnotherRolePlayer(requester, community, group, role);
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.GET_AGENT_WITH_ROLE) + I18nUtilities.getCGRString(community, group, role) + ": " + result);
            }
            return result;
        }
        catch (CGRNotAvailable e) {
            if (requester.isWarningOn()) {
                requester.handleException(AbstractAgent.Influence.GET_AGENT_WITH_ROLE, new OrganizationWarning(e.getCode(), community, group, role));
            }
            return null;
        }
    }

    @Override
    AgentAddress getAgentAddressIn(AbstractAgent agent, String community, String group, String role) {
        AgentAddress aa = this.kernel.getAgentAddressIn(agent, community, group, role);
        if (aa == null && agent.isWarningOn() && this.isRole(community, group, role)) {
            agent.handleException(AbstractAgent.Influence.GET_AGENT_ADDRESS_IN, new OrganizationWarning(AbstractAgent.ReturnCode.ROLE_NOT_HANDLED, community, group, role));
        }
        return aa;
    }

    @Override
    AbstractAgent.ReturnCode broadcastMessageWithRole(AbstractAgent requester, String community, String group, String role, Message messageToSend, String senderRole) {
        AbstractAgent.ReturnCode r = this.kernel.broadcastMessageWithRole(requester, community, group, role, messageToSend, senderRole);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.BROADCAST_MESSAGE) + "-> " + I18nUtilities.getCGRString(community, group, role) + (senderRole == null ? "" : " with role " + senderRole) + messageToSend);
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            if (r == AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND) {
                requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE, new MadkitWarning(r));
            } else if (r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
                requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE, new OrganizationWarning(r, community, group, senderRole));
            } else {
                requester.handleException(AbstractAgent.Influence.BROADCAST_MESSAGE, new OrganizationWarning(r, community, group, role));
            }
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, AgentAddress receiver, Message messageToSend, String senderRole) {
        AbstractAgent.ReturnCode r = this.kernel.sendMessage(requester, receiver, messageToSend, senderRole);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, AbstractAgent.Influence.SEND_MESSAGE.successString() + " " + messageToSend);
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            if (r == AbstractAgent.ReturnCode.NOT_IN_GROUP || r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
                requester.handleException(AbstractAgent.Influence.SEND_MESSAGE, new OrganizationWarning(r, receiver.getCommunity(), receiver.getGroup(), senderRole));
            } else {
                requester.handleException(AbstractAgent.Influence.SEND_MESSAGE, new MadkitWarning(r));
            }
        }
        return r;
    }

    @Override
    AbstractAgent.ReturnCode sendMessage(AbstractAgent requester, String community, String group, String role, Message messageToSend, String senderRole) {
        AbstractAgent.ReturnCode r = this.kernel.sendMessage(requester, community, group, role, messageToSend, senderRole);
        if (r == AbstractAgent.ReturnCode.SUCCESS) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, AbstractAgent.Influence.SEND_MESSAGE.successString() + "->" + I18nUtilities.getCGRString(community, group, role) + " " + messageToSend);
            }
            return AbstractAgent.ReturnCode.SUCCESS;
        }
        if (requester.isWarningOn()) {
            if (r == AbstractAgent.ReturnCode.NO_RECIPIENT_FOUND) {
                requester.handleException(AbstractAgent.Influence.SEND_MESSAGE, new MadkitWarning(r));
            } else if (r == AbstractAgent.ReturnCode.ROLE_NOT_HANDLED) {
                requester.handleException(AbstractAgent.Influence.SEND_MESSAGE, new OrganizationWarning(r, community, group, senderRole));
            } else {
                requester.handleException(AbstractAgent.Influence.SEND_MESSAGE, new OrganizationWarning(r, community, group, role));
            }
        }
        return r;
    }

    @Override
    List<Message> broadcastMessageWithRoleAndWaitForReplies(AbstractAgent requester, String community, String group, String role, Message message, String senderRole, Integer timeOutMilliSeconds) {
        List<Message> result = this.kernel.broadcastMessageWithRoleAndWaitForReplies(requester, community, group, role, message, senderRole, timeOutMilliSeconds);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.BROADCAST_MESSAGE_AND_WAIT) + ": received: " + result);
        }
        return result;
    }

    @Override
    void launchAgentBucketWithRoles(AbstractAgent requester, List<AbstractAgent> bucket, String ... CGRLocations) {
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, "launchAgentBucketWithRoles : " + bucket.size() + " : " + Arrays.deepToString(CGRLocations));
        }
        this.kernel.launchAgentBucketWithRoles(requester, bucket, CGRLocations);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, "launchAgentBucketWithRoles  done !");
        }
    }

    @Override
    final AbstractAgent.ReturnCode launchAgent(AbstractAgent requester, AbstractAgent agent, int timeOutSeconds, boolean defaultGUI) {
        AbstractAgent.ReturnCode r;
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.LAUNCH_AGENT) + " (" + timeOutSeconds + ")" + agent.getLoggingName() + "...");
        }
        if ((r = this.kernel.launchAgent(requester, agent, timeOutSeconds, defaultGUI)) == AbstractAgent.ReturnCode.SUCCESS || r == AbstractAgent.ReturnCode.TIMEOUT) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, AbstractAgent.Influence.LAUNCH_AGENT.toString() + agent + " " + (Object)((Object)r));
            }
        } else if (requester.isWarningOn()) {
            requester.handleException(AbstractAgent.Influence.LAUNCH_AGENT, new MadkitWarning(agent.toString(), r));
        }
        return r;
    }

    @Override
    final AbstractAgent.ReturnCode killAgent(AbstractAgent requester, AbstractAgent target, int timeOutSeconds) {
        AbstractAgent.ReturnCode r;
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.KILL_AGENT) + " (" + timeOutSeconds + ")" + target + "...");
        }
        if ((r = this.kernel.killAgent(requester, target, timeOutSeconds)) == AbstractAgent.ReturnCode.SUCCESS || r == AbstractAgent.ReturnCode.TIMEOUT) {
            if (requester.isFinestLogOn()) {
                requester.logger.log(Level.FINEST, (Object)((Object)AbstractAgent.Influence.KILL_AGENT) + target.getLoggingName() + " " + (Object)((Object)r));
            }
        } else if (requester.isWarningOn()) {
            requester.handleException(AbstractAgent.Influence.KILL_AGENT, new MadkitWarning(target.toString(), r));
        }
        return r;
    }

    @Override
    boolean isCommunity(AbstractAgent requester, String community) {
        boolean fact = this.kernel.isCommunity(requester, community);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, (Object)((Object)Words.COMMUNITY) + " ? " + I18nUtilities.getCGRString(community) + fact);
        }
        return fact;
    }

    @Override
    boolean isGroup(AbstractAgent requester, String community, String group) {
        boolean fact = this.kernel.isGroup(requester, community, group);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, (Object)((Object)Words.GROUP) + " ? " + I18nUtilities.getCGRString(community, group) + fact);
        }
        return fact;
    }

    @Override
    boolean isRole(AbstractAgent requester, String community, String group, String role) {
        boolean fact = this.kernel.isRole(requester, community, group, role);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, (Object)((Object)Words.ROLE) + " ? " + I18nUtilities.getCGRString(community, group, role) + fact);
        }
        return fact;
    }

    @Override
    MadkitKernel getMadkitKernel() {
        return this.kernel;
    }

    @Override
    synchronized boolean removeOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        boolean added = this.kernel.removeOverlooker(requester, o);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, o.getClass().getSimpleName() + (added ? " removed" : " not added") + o);
        }
        return added;
    }

    @Override
    synchronized boolean addOverlooker(AbstractAgent requester, Overlooker<? extends AbstractAgent> o) {
        boolean added = this.kernel.addOverlooker(requester, o);
        if (requester.isFinestLogOn()) {
            requester.logger.log(Level.FINEST, o.getClass().getSimpleName() + (added ? " OK" : " already added") + o);
        }
        return added;
    }
}

