/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;
import madkit.kernel.NetCode;
import madkit.kernel.NetworkAgent;
import madkit.kernel.NetworkMessage;

final class KernelConnection
extends Thread {
    private final Socket distantKernelSocket;
    private boolean activated = false;
    private final NetworkAgent myNetAgent;
    private KernelAddress distantKernelAddress;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;

    boolean isActivated() {
        return this.activated;
    }

    Socket getDistantKernelSocket() {
        return this.distantKernelSocket;
    }

    KernelAddress getKernelAddress() {
        return this.distantKernelAddress;
    }

    public KernelConnection(NetworkAgent netAgent, InetAddress address, int port) throws UnknownHostException, IOException {
        this(netAgent, new Socket(address, port));
    }

    public KernelConnection(NetworkAgent netAgent, Socket kernelClient) throws IOException {
        this.myNetAgent = netAgent;
        this.distantKernelSocket = kernelClient;
        this.initStreams();
    }

    private void initStreams() throws IOException {
        this.oos = new ObjectOutputStream(this.distantKernelSocket.getOutputStream());
        this.ois = new ObjectInputStream(this.distantKernelSocket.getInputStream());
    }

    Map<String, Map<String, Map<String, Set<AgentAddress>>>> waitForDistantOrg() throws IOException, ClassNotFoundException {
        return (Map)this.ois.readObject();
    }

    KernelAddress waitForDistantKernelAddress() throws IOException, ClassNotFoundException {
        this.distantKernelAddress = (KernelAddress)this.ois.readObject();
        return this.distantKernelAddress;
    }

    void sendConnectionInfo(KernelAddress myKA, Map<String, Map<String, Map<String, Set<AgentAddress>>>> map) throws IOException {
        this.oos.writeObject(myKA);
        this.oos.writeObject(map);
    }

    @Override
    public void run() {
        this.activated = true;
        while (this.distantKernelSocket.isConnected()) {
            try {
                this.myNetAgent.receiveMessage((Message)this.ois.readObject());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                break;
            }
            catch (IOException e) {
                this.myNetAgent.receiveMessage(new NetworkMessage(NetCode.PEER_DECONNECTED, this.distantKernelAddress));
                break;
            }
        }
        this.closeConnection();
    }

    synchronized void sendMessage(Message m) {
        try {
            this.oos.writeObject(m);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void closeConnection() {
        try {
            this.oos.close();
            this.ois.close();
            this.distantKernelSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.distantKernelSocket.getInetAddress().getHostAddress() + " dka = " + (this.distantKernelAddress == null ? "NA" : this.distantKernelAddress);
    }

    public int getPort() {
        return this.distantKernelSocket.getPort();
    }

    public InetAddress getInetAddress() {
        return this.distantKernelSocket.getInetAddress();
    }
}

