/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Gatekeeper;
import madkit.kernel.KernelAddress;
import madkit.kernel.ManagerRole;
import madkit.kernel.Organization;
import madkit.kernel.Role;

final class Group
extends ConcurrentHashMap<String, Role> {
    private static final long serialVersionUID = 498214902172237862L;
    private final Gatekeeper gatekeeper;
    private final Logger logger;
    private final String communityName;
    private final String groupName;
    private final Organization communityObject;
    private final boolean distributed;

    Group(String community, String group, AbstractAgent creator, Gatekeeper gatekeeper, boolean isDistributed, Organization organization) {
        this.distributed = isDistributed;
        this.gatekeeper = gatekeeper;
        this.communityName = community;
        this.groupName = group;
        this.communityObject = organization;
        this.logger = this.communityObject.getLogger();
        this.put("manager", new ManagerRole(this, creator));
    }

    final Organization getCommunityObject() {
        return this.communityObject;
    }

    Group(String community, String group, AgentAddress manager, Gatekeeper gatekeeper, Organization communityObject) {
        this.distributed = true;
        this.communityObject = communityObject;
        this.logger = communityObject.getLogger();
        this.gatekeeper = gatekeeper;
        this.communityName = community;
        this.groupName = group;
        if (manager != null) {
            this.put("manager", new ManagerRole(this, manager));
        }
    }

    String getName() {
        return this.groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractAgent.ReturnCode requestRole(AbstractAgent requester, String roleName, Object memberCard) {
        Role theRole;
        if (roleName == null) {
            throw new NullPointerException(ErrorMessages.R_NULL.toString());
        }
        if (this.gatekeeper != null && !this.gatekeeper.allowAgentToTakeRole(roleName, memberCard)) {
            return AbstractAgent.ReturnCode.ACCESS_DENIED;
        }
        AbstractAgent.ReturnCode result = AbstractAgent.ReturnCode.SUCCESS;
        Group group = this;
        synchronized (group) {
            theRole = (Role)this.get(roleName);
            if (theRole == null) {
                theRole = this.createRole(roleName);
                this.put(roleName, theRole);
                theRole.addMember(requester);
            } else {
                result = theRole.addMember(requester) ? AbstractAgent.ReturnCode.SUCCESS : AbstractAgent.ReturnCode.ROLE_ALREADY_HANDLED;
            }
        }
        if (result == AbstractAgent.ReturnCode.SUCCESS) {
            theRole.addToOverlookers(requester);
        }
        return result;
    }

    Role createRole(String roleName) {
        return new Role(this, roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRole(String roleName) {
        Group group = this;
        synchronized (group) {
            this.remove(roleName);
            if (this.logger != null) {
                this.logger.finer("Removing" + I18nUtilities.getCGRString(this.communityName, this.groupName, roleName));
            }
            this.checkEmptyness();
        }
    }

    private void checkEmptyness() {
        if (this.isEmpty()) {
            this.communityObject.removeGroup(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Role> leaveGroup(AbstractAgent requester) {
        ArrayList<Role> affectedRoles = null;
        Group group = this;
        synchronized (group) {
            for (Role r : this.values()) {
                if (r.removeMember(requester) != AbstractAgent.ReturnCode.SUCCESS) continue;
                if (affectedRoles == null) {
                    affectedRoles = new ArrayList<Role>();
                }
                affectedRoles.add(r);
            }
        }
        return affectedRoles;
    }

    boolean isIn(AbstractAgent agent) {
        for (Role r : this.values()) {
            if (!r.contains(agent)) continue;
            return true;
        }
        return false;
    }

    AgentAddress getAgentAddressOf(AbstractAgent abstractAgent) {
        for (Role r : this.values()) {
            AgentAddress aa = r.getAgentAddressOf(abstractAgent);
            if (aa == null) continue;
            return aa;
        }
        return null;
    }

    boolean isDistributed() {
        return this.distributed;
    }

    SortedMap<String, Set<AgentAddress>> getGroupMap() {
        TreeMap<String, Set<AgentAddress>> export = new TreeMap<String, Set<AgentAddress>>();
        for (Map.Entry org : this.entrySet()) {
            export.put((String)org.getKey(), ((Role)org.getValue()).buildAndGetAddresses());
        }
        return export;
    }

    void importDistantOrg(Map<String, Set<AgentAddress>> map) {
        for (String roleName : map.keySet()) {
            Set<AgentAddress> list = map.get(roleName);
            if (list == null) continue;
            Role role = (Role)this.get(roleName);
            if (role == null) {
                role = this.createRole(roleName);
                this.put(roleName, role);
            }
            role.importDistantOrg(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDistantMember(AgentAddress content) {
        Role r;
        String roleName = content.getRole();
        Group group = this;
        synchronized (group) {
            r = (Role)this.get(roleName);
            if (r == null) {
                r = this.createRole(roleName);
                this.put(roleName, r);
            }
        }
        r.addDistantMember(content);
    }

    void removeDistantMember(AgentAddress aa) {
        for (Role r : this.values()) {
            aa.setRoleObject(r);
            r.removeDistantMember(aa);
        }
    }

    void removeAgentsFromDistantKernel(KernelAddress kernelAddress) {
        if (this.logger != null) {
            this.logger.finest("Removing all agents from distant kernel " + kernelAddress + " in" + this);
        }
        for (Role r : this.values()) {
            r.removeAgentsFromDistantKernel(kernelAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void chooseNewManager(AbstractAgent oldManager) {
        Group group = this;
        synchronized (group) {
            if (!this.isEmpty()) {
                for (Role r : this.values()) {
                    for (AbstractAgent a : r.getPlayers()) {
                        if (a == oldManager) continue;
                        this.put("manager", new ManagerRole(this, a));
                        return;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return I18nUtilities.getCGRString(this.communityName, this.groupName) + this.values();
    }

    final void destroy() {
        for (Role r : this.values()) {
            r.destroy();
        }
        this.communityObject.removeGroup(this.groupName);
    }
}

