/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentFormatter;
import madkit.kernel.Madkit;

public class AgentLogger
extends Logger {
    public static final Formatter AGENT_FORMATTER = new AgentFormatter();
    public static final Formatter AGENT_FILE_FORMATTER = new AgentFormatter(){

        @Override
        protected String getHeader(LogRecord record) {
            return "";
        }
    };
    static final AgentLogger defaultAgentLogger = new AgentLogger();
    static final Level talkLevel = Level.parse("1100");
    private static final Map<AbstractAgent, AgentLogger> agentLoggers = new ConcurrentHashMap<AbstractAgent, AgentLogger>();
    private final AbstractAgent myAgent;
    private Level warningLogLevel = Madkit.LevelOption.warningLogLevel.getValue(Madkit.defaultConfig);

    static final AgentLogger getLogger(AbstractAgent agent) {
        AgentLogger al = agentLoggers.get(agent);
        if (al == null || !al.getName().equals(agent.getLoggingName())) {
            if (al != null) {
                for (Handler h : al.getHandlers()) {
                    h.close();
                }
            }
            al = new AgentLogger(agent);
            agentLoggers.put(agent, al);
        }
        return al;
    }

    static void removeLogger(AbstractAgent agent) {
        agentLoggers.remove(agent);
    }

    public Level getWarningLogLevel() {
        return this.warningLogLevel;
    }

    public void setWarningLogLevel(Level warningLogLevel) {
        this.warningLogLevel = warningLogLevel;
        AgentLogLevelMenu.update(this.myAgent);
    }

    private AgentLogger() {
        super("[UNREGISTERED AGENT]", null);
        this.myAgent = null;
        this.setUseParentHandlers(false);
        super.setLevel(Madkit.LevelOption.agentLogLevel.getValue(Madkit.defaultConfig));
        if (!Madkit.BooleanOption.noAgentConsoleLog.isActivated(Madkit.defaultConfig)) {
            this.addHandler(new ConsoleHandler());
        }
    }

    private AgentLogger(AbstractAgent agent) {
        super(agent.getLoggingName(), null);
        this.myAgent = agent;
        this.setUseParentHandlers(false);
        Level l = agent.logger == null ? Level.OFF : Madkit.LevelOption.agentLogLevel.getValue(agent.getMadkitConfig());
        super.setLevel(l);
        this.setWarningLogLevel(Madkit.LevelOption.warningLogLevel.getValue(agent.getMadkitConfig()));
        if (!Madkit.BooleanOption.noAgentConsoleLog.isActivated(agent.getMadkitConfig())) {
            ConsoleHandler ch = new ConsoleHandler();
            this.addHandler(ch);
            ch.setFormatter(AGENT_FORMATTER);
        }
        if (Madkit.BooleanOption.createLogFiles.isActivated(this.myAgent.getMadkitConfig())) {
            this.createLogFile();
        }
    }

    public void createLogFile() {
        String logDir = this.myAgent.getMadkitConfig().getProperty(Madkit.Option.logDirectory.name());
        new File(logDir).mkdirs();
        String fileName = logDir + File.separator + this.getName();
        if (!new File(fileName).exists()) {
            this.addHandler(AgentLogger.getFileHandler(fileName));
        }
    }

    private static FileHandler getFileHandler(String logFileName) {
        final File logFile = new File(logFileName);
        FileHandler fh = null;
        final String logSession = "\n------------------------------------------------------------------\n-- Log session for " + logFileName.substring(logFileName.lastIndexOf(File.separator) + 1);
        String logEnd = " --\n------------------------------------------------------------------\n\n";
        final Date date = new Date();
        try {
            FileWriter fw = new FileWriter(logFile, true);
            fw.write(logSession + " started on " + Madkit.dateFormat.format(date) + " --\n------------------------------------------------------------------\n\n");
            fw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fh = new FileHandler(logFileName, true){

                @Override
                public synchronized void close() throws SecurityException {
                    super.close();
                    try {
                        FileWriter fw = new FileWriter(logFile, true);
                        date.setTime(System.currentTimeMillis());
                        fw.write(logSession + " closed on  " + Madkit.dateFormat.format(date) + " --\n------------------------------------------------------------------\n\n");
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            fh.setFormatter(AGENT_FILE_FORMATTER);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fh;
    }

    @Override
    public synchronized void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        handler.setLevel(this.getLevel());
    }

    static void resetLoggers() {
        for (AgentLogger l : agentLoggers.values()) {
            for (Handler h : l.getHandlers()) {
                l.removeHandler(h);
                try {
                    h.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void talk(String msg) {
        if (this.getLevel() == Level.OFF) {
            System.err.print(msg);
        } else {
            this.log(talkLevel, msg);
        }
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
        for (Handler h : this.getHandlers()) {
            h.setLevel(newLevel);
        }
        if (this.myAgent.hasGUI()) {
            AgentLogLevelMenu.update(this.myAgent);
        }
    }

    public String toString() {
        return this.getName() + " logger: \n\tlevel " + this.getLevel() + "\n\twarningLogLevel " + this.getWarningLogLevel();
    }

    @Override
    public void log(LogRecord record) {
        Throwable t = record.getThrown();
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            record.setMessage(record.getMessage() + "\n ** " + sw);
        }
        super.log(record);
    }

    public void severeLog(String msg, Throwable t) {
        Level lvl;
        AgentLogger l = this.myAgent.getMadkitKernel().logger;
        if (l != null) {
            l.log(Level.FINEST, "log for " + this.myAgent + "\n" + msg, t);
        }
        if (t != null) {
            this.myAgent.setAgentStackTrace(t);
        }
        if ((lvl = this.getLevel()) == Level.OFF) {
            this.setLevel(Level.ALL);
        }
        this.log(Level.SEVERE, msg, t);
        this.setLevel(lvl);
    }
}

