/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentExecutor;
import madkit.kernel.KilledException;
import madkit.kernel.Message;
import madkit.kernel.SelfKillException;

public class Agent
extends AbstractAgent {
    private static final long serialVersionUID = 8564494100061187968L;
    Thread myThread;
    private final AgentExecutor agentExecutor;
    private final boolean isDaemon;

    public Agent(boolean isDaemon) {
        this.isDaemon = isDaemon;
        this.agentExecutor = new AgentExecutor(this);
    }

    public Agent() {
        this(false);
    }

    Agent(Object o) {
        super(o);
        this.isDaemon = false;
        this.agentExecutor = null;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    @Override
    final AgentExecutor getAgentExecutor() {
        return this.agentExecutor;
    }

    @Override
    final void suicide(SelfKillException e) {
        this.getAgentExecutor().getLiveProcess().cancel(false);
        this.getAgentExecutor().getEndProcess().cancel(false);
        super.suicide(e);
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean living() {
        try {
            this.state.set(AbstractAgent.State.LIVING);
            this.setMyThread(Thread.currentThread());
            this.logMethod(true);
            try {
                this.live();
            }
            catch (SelfKillException e) {
                this.suicide(e);
            }
            catch (Exception e) {
                AtomicReference atomicReference = this.state;
                synchronized (atomicReference) {
                    this.alive.set(false);
                    this.logLifeException(e);
                }
            }
            if (!this.alive.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (KilledException e) {
            this.logLifeException(e);
        }
        this.logMethod(false);
        return true;
    }

    protected void live() {
        this.setLogLevel(Level.INFO);
        if (this.logger != null) {
            this.logger.talk("\n\tHi human and hello World !!\n\n I am an instance of the madkit.kernel.Agent class\n As such, I am a MaDKit threaded Agent\n and thus have an autonomous activity!");
        }
        this.pause(5000);
        if (this.logger != null) {
            this.logger.talk("\n\n And in fact, I am the simpliest agent ever\n because I simply do nothing at all :)\n\n");
        }
        this.pause(4000);
        int i = (int)(Math.random() * 3000.0 + 4500.0);
        if (this.logger != null) {
            this.logger.info("I will quit in " + i + " milliseconds... Bye !");
        }
        this.pause(i);
    }

    @Override
    public AbstractAgent.ReturnCode killAgent(AbstractAgent target, int timeOutSeconds) {
        if (target == this && this.myThread == Thread.currentThread() && this.alive.compareAndSet(true, false)) {
            throw new SelfKillException("" + timeOutSeconds);
        }
        return super.killAgent(target, timeOutSeconds);
    }

    public Message sendMessageAndWaitForReply(AgentAddress receiver, Message messageToSend) {
        return this.sendMessageWithRoleAndWaitForReply(receiver, messageToSend, null, null);
    }

    public Message sendMessageAndWaitForReply(AgentAddress receiver, Message messageToSend, int timeOutMilliSeconds) {
        return this.sendMessageWithRoleAndWaitForReply(receiver, messageToSend, null, timeOutMilliSeconds);
    }

    public Message sendMessageWithRoleAndWaitForReply(AgentAddress receiver, Message messageToSend, String senderRole) {
        return this.sendMessageWithRoleAndWaitForReply(receiver, messageToSend, senderRole, null);
    }

    public Message sendMessageWithRoleAndWaitForReply(AgentAddress receiver, Message messageToSend, String senderRole, Integer timeOutMilliSeconds) {
        if (this.logger != null) {
            this.logger.finest("sendMessageAndWaitForReply : sending " + messageToSend + " to " + receiver + ", and waiting reply...");
        }
        if (this.getKernel().sendMessage(this, receiver, messageToSend, senderRole) != AbstractAgent.ReturnCode.SUCCESS) {
            return null;
        }
        return this.waitAnswer(messageToSend, timeOutMilliSeconds == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.toNanos(timeOutMilliSeconds.intValue())));
    }

    public Message sendMessageAndWaitForReply(String community, String group, String role, Message messageToSend) {
        return this.sendMessageWithRoleAndWaitForReply(community, group, role, messageToSend, null, null);
    }

    public Message sendMessageWithRoleAndWaitForReply(String community, String group, String role, Message messageToSend, String senderRole) {
        return this.sendMessageWithRoleAndWaitForReply(community, group, role, messageToSend, senderRole, null);
    }

    public Message sendMessageAndWaitForReply(String community, String group, String role, Message messageToSend, int timeOutMilliSeconds) {
        return this.sendMessageWithRoleAndWaitForReply(community, group, role, messageToSend, null, timeOutMilliSeconds);
    }

    public Message sendMessageWithRoleAndWaitForReply(String community, String group, String role, Message messageToSend, String senderRole, Integer timeOutMilliSeconds) {
        if (this.logger != null) {
            this.logger.finest("sendMessageAndWaitForReply : sending " + messageToSend + " to any " + I18nUtilities.getCGRString(community, group, role) + (timeOutMilliSeconds == null ? "" : ", and waiting reply for " + TimeUnit.MILLISECONDS.toSeconds(timeOutMilliSeconds.intValue()) + " s..."));
        }
        if (this.getKernel().sendMessage(this, community, group, role, messageToSend, senderRole) != AbstractAgent.ReturnCode.SUCCESS) {
            return null;
        }
        return this.waitAnswer(messageToSend, timeOutMilliSeconds == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.toNanos(timeOutMilliSeconds.intValue())));
    }

    public Message sendReplyAndWaitForReply(Message messageToReplyTo, Message reply) {
        return this.sendReplyWithRoleAndWaitForReply(messageToReplyTo, reply, null, null);
    }

    public Message sendReplyAndWaitForReply(Message messageToReplyTo, Message reply, int timeOutMilliSeconds) {
        return this.sendReplyWithRoleAndWaitForReply(messageToReplyTo, reply, null, timeOutMilliSeconds);
    }

    public Message sendReplyWithRoleAndWaitForReply(Message messageToReplyTo, Message reply, String senderRole) {
        return this.sendReplyWithRoleAndWaitForReply(messageToReplyTo, reply, senderRole, null);
    }

    public Message sendReplyWithRoleAndWaitForReply(Message messageToReplyTo, Message reply, String senderRole, Integer timeOutMilliSeconds) {
        if (this.logger != null) {
            this.logger.finest("sendReplyAndWaitForReply : sending " + reply + " as reply to " + messageToReplyTo + ", and waiting reply...");
        }
        if (this.sendReplyWithRole(messageToReplyTo, reply, senderRole) != AbstractAgent.ReturnCode.SUCCESS) {
            return null;
        }
        return this.waitAnswer(reply, TimeUnit.MILLISECONDS.toNanos(timeOutMilliSeconds.intValue()));
    }

    public List<Message> broadcastMessageWithRoleAndWaitForReplies(String community, String group, String role, Message message, String senderRole, Integer timeOutMilliSeconds) {
        return this.getKernel().broadcastMessageWithRoleAndWaitForReplies(this, community, group, role, message, senderRole, timeOutMilliSeconds);
    }

    public Message waitNextMessage() {
        if (this.logger != null) {
            this.logger.finest("waitNextMessage...");
            Message m = this.waitingNextMessageForEver();
            if (this.logger != null) {
                this.logger.finest("..." + (Object)((Object)Words.NEW_MSG) + ": " + m);
            }
            return m;
        }
        return this.waitingNextMessageForEver();
    }

    public final Message waitNextMessage(long timeOutMilliseconds) {
        if (this.logger != null) {
            this.logger.finest("Waiting next message during " + timeOutMilliseconds + " milliseconds...");
            Message m = this.waitingNextMessage(timeOutMilliseconds, TimeUnit.MILLISECONDS);
            if (m != null) {
                this.logger.finest("..." + (Object)((Object)Words.NEW_MSG) + ": " + m);
            } else {
                this.logger.finest("...time out !");
            }
            return m;
        }
        return this.waitingNextMessage(timeOutMilliseconds, TimeUnit.MILLISECONDS);
    }

    protected void pause(int milliSeconds) {
        if (this.logger != null) {
            this.logger.finest((Object)((Object)Words.PAUSE) + " " + milliSeconds + " ms.");
        }
        if (milliSeconds < 0) {
            return;
        }
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException();
        }
    }

    private Message waitingNextMessageForEver() {
        try {
            return (Message)this.messageBox.take();
        }
        catch (InterruptedException e) {
            this.handleInterruptedException();
            return null;
        }
    }

    private Message waitingNextMessage(long timeout, TimeUnit unit) {
        try {
            return (Message)this.messageBox.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message waitAnswer(Message m) {
        ArrayList<Message> receptions = new ArrayList<Message>(this.messageBox.size());
        long conversationID = m.getConversationID();
        Message answer = this.waitingNextMessageForEver();
        while ((long)answer.getConversationID() != conversationID) {
            receptions.add(answer);
            answer = this.waitingNextMessageForEver();
        }
        if (!receptions.isEmpty()) {
            BlockingQueue blockingQueue = this.messageBox;
            synchronized (blockingQueue) {
                this.messageBox.addAll(receptions);
            }
        }
        if (this.logger != null) {
            this.logger.finest("a reply has arrived " + answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message waitAnswer(Message theMessageToReplyTo, Long timeOutNanos) {
        if (timeOutNanos == null) {
            return this.waitAnswer(theMessageToReplyTo);
        }
        ArrayList<Message> receptions = new ArrayList<Message>(this.messageBox.size());
        long endTime = System.nanoTime() + timeOutNanos;
        long conversationID = theMessageToReplyTo.getConversationID();
        Message answer = this.waitingNextMessage(timeOutNanos, TimeUnit.NANOSECONDS);
        while (answer != null && (long)answer.getConversationID() != conversationID) {
            receptions.add(answer);
            answer = this.waitingNextMessage(endTime - System.nanoTime(), TimeUnit.NANOSECONDS);
        }
        if (!receptions.isEmpty()) {
            BlockingQueue blockingQueue = this.messageBox;
            synchronized (blockingQueue) {
                this.messageBox.addAll(receptions);
            }
        }
        if (answer == null) {
            if (this.logger != null) {
                this.logger.finest("...Waiting for reply has reached time out, no reply received");
            }
            return null;
        }
        if (this.logger != null) {
            this.logger.finest("...a reply has arrived : " + answer);
        }
        return answer;
    }
}

