/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.JFrame;
import madkit.action.ActionInfo;
import madkit.action.GUIManagerAction;
import madkit.gui.AgentStatusPanel;
import madkit.gui.OutputPanel;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.i18n.ErrorMessages;
import madkit.i18n.I18nUtilities;
import madkit.i18n.Words;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentExecutor;
import madkit.kernel.AgentLogger;
import madkit.kernel.FakeKernel;
import madkit.kernel.Gatekeeper;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelException;
import madkit.kernel.KilledException;
import madkit.kernel.Madkit;
import madkit.kernel.MadkitClassLoader;
import madkit.kernel.MadkitKernel;
import madkit.kernel.Message;
import madkit.kernel.SelfKillException;
import madkit.kernel.TerminatedKernel;
import madkit.message.EnumMessage;
import madkit.message.GUIMessage;
import madkit.message.hook.HookMessage;

public class AbstractAgent
implements Comparable<AbstractAgent>,
Serializable {
    private static final long serialVersionUID = -6180517348998118712L;
    private static final transient AtomicInteger agentCounter = new AtomicInteger(0);
    static final transient MadkitKernel FAKE_KERNEL = new FakeKernel();
    private static final transient MadkitKernel TERMINATED_KERNEL = new TerminatedKernel();
    final AtomicReference<State> state = new AtomicReference<State>(State.NOT_LAUNCHED);
    transient MadkitKernel kernel = FAKE_KERNEL;
    private final int _hashCode;
    private boolean hasGUI;
    private String name;
    final AtomicBoolean alive = new AtomicBoolean();
    final BlockingQueue<Message> messageBox = new LinkedBlockingQueue<Message>();
    protected AgentLogger logger;
    private static final Map<Class<?>, Class<?>> primitiveTypes = new HashMap();

    public AbstractAgent() {
        this._hashCode = agentCounter.getAndIncrement();
        this.logger = AgentLogger.defaultAgentLogger;
    }

    AbstractAgent(Object fake) {
        this._hashCode = -1;
    }

    MadkitKernel getMadkitKernel() {
        return this.kernel.getMadkitKernel();
    }

    public void createGUIOnStartUp() {
        if (this.state.get().compareTo(State.ACTIVATED) < 0) {
            this.hasGUI = true;
        }
    }

    public boolean hasGUI() {
        return this.hasGUI;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    final AtomicBoolean getAlive() {
        return this.alive;
    }

    public boolean isAlive() {
        return this.alive.get();
    }

    private final void activationFirstStage() {
        if (!this.state.compareAndSet(State.INITIALIZING, State.ACTIVATED)) {
            throw new AssertionError((Object)"not init in activation");
        }
        this.setMyThread(Thread.currentThread());
        if (!this.alive.compareAndSet(false, true)) {
            throw new AssertionError((Object)"already alive in launch");
        }
        if (this.hasGUI) {
            if (this.logger != null) {
                this.logger.finer("** setting up  GUI **");
            }
            this.getMadkitKernel().broadcastMessageWithRoleAndWaitForReplies(this, "local", "gui", "manager", new GUIMessage(GUIManagerAction.SETUP_AGENT_GUI, this), null, 3000);
        }
        this.logMethod(true);
    }

    void setMyThread(Thread thread) {
        thread.setName((Object)((Object)this.getState()) + "-" + this.hashCode());
    }

    final String getAgentThreadName(State s) {
        return (Object)((Object)s) + "-" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean activation() {
        boolean result = false;
        try {
            try {
                this.activationFirstStage();
                this.activate();
                AtomicReference<State> atomicReference = this.state;
                synchronized (atomicReference) {
                    Thread.currentThread().setName(this.getAgentThreadName(State.LIVING));
                }
                result = true;
            }
            catch (SelfKillException e) {
                this.logLifeException(e);
                this.logMethod(false);
                this.state.set(State.LIVING);
                this.suicide(e);
                return true;
            }
            catch (Throwable e) {
                this.validateDeathOnException(e, State.LIVING);
            }
        }
        catch (KilledException e) {
            this.logLifeException(e);
        }
        this.logMethod(false);
        return result;
    }

    final void logMethod(boolean entering) {
        if (this.logger != null) {
            this.logger.finer("** " + (Object)((Object)(entering ? Words.ENTERING : Words.EXITING)) + " " + this.getState().lifeCycleMethod() + " **");
        }
    }

    void suicide(SelfKillException e) {
        this.getMadkitKernel().startEndBehavior(this, Integer.parseInt(e.getMessage()), true);
    }

    protected void activate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean ending() {
        AtomicReference<State> atomicReference;
        this.state.set(State.ENDING);
        Thread.currentThread().setName(this.getAgentThreadName(State.ENDING));
        this.logMethod(true);
        try {
            atomicReference = this.state;
            synchronized (atomicReference) {
                this.state.notify();
            }
            try {
                this.end();
            }
            catch (Exception e) {
                this.validateDeathOnException(e, State.TERMINATED);
            }
            AtomicReference<State> e = this.state;
            synchronized (e) {
                this.alive.set(false);
                Thread.currentThread().setName(this.getAgentThreadName(State.TERMINATED));
            }
        }
        catch (KilledException e) {
            this.logLifeException(e);
        }
        this.logMethod(false);
        atomicReference = this.state;
        synchronized (atomicReference) {
            this.state.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDeathOnException(Throwable e, State threadNewState) {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            this.logLifeException(e);
            Thread.currentThread().setName(this.getAgentThreadName(threadNewState));
            if (!this.alive.compareAndSet(true, false)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Thread.currentThread().setName(this.getAgentThreadName(State.TERMINATED));
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            this.state.set(State.TERMINATED);
            this.state.notify();
        }
        this.kernel = this.getMadkitKernel();
        if (this.hasGUI) {
            this.kernel.broadcastMessageWithRole(this, "local", "gui", "manager", new GUIMessage(GUIManagerAction.DISPOSE_AGENT_GUI, this), null);
        }
        try {
            this.kernel.removeAgentFromOrganizations(this);
        }
        catch (Throwable e) {
            this.logLifeException(e);
        }
        if (this.logger != null) {
            this.logger.finest("** TERMINATED **");
            AgentLogger.removeLogger(this);
        }
        if (this.hasGUI) {
            AgentLogLevelMenu.remove(this);
            AgentStatusPanel.remove(this);
        }
        if (this.kernel.isHooked()) {
            this.kernel.informHooks(HookMessage.AgentActionEvent.AGENT_TERMINATED, this.getName());
        }
        this.kernel = TERMINATED_KERNEL;
    }

    protected void end() {
    }

    public ReturnCode launchAgent(AbstractAgent agent) {
        return this.launchAgent(agent, Integer.MAX_VALUE, false);
    }

    public ReturnCode launchAgent(AbstractAgent agent, int timeOutSeconds) {
        return this.launchAgent(agent, timeOutSeconds, false);
    }

    public ReturnCode launchAgent(AbstractAgent agent, boolean createFrame) {
        return this.launchAgent(agent, Integer.MAX_VALUE, createFrame);
    }

    public ReturnCode launchAgent(AbstractAgent agent, int timeOutSeconds, boolean createFrame) {
        return this.getKernel().launchAgent(this, agent, timeOutSeconds, createFrame);
    }

    public AbstractAgent launchAgent(String agentClass) {
        return this.launchAgent(agentClass, Integer.MAX_VALUE, false);
    }

    public AbstractAgent launchAgent(String agentClass, int timeOutSeconds) {
        return this.launchAgent(agentClass, timeOutSeconds, false);
    }

    public AbstractAgent launchAgent(String agentClass, boolean createFrame) {
        return this.launchAgent(agentClass, Integer.MAX_VALUE, createFrame);
    }

    public AbstractAgent launchAgent(String agentClass, int timeOutSeconds, boolean createFrame) {
        if (this.logger != null) {
            this.logger.finest((Object)((Object)Words.LAUNCH) + " " + agentClass + " GUI " + createFrame);
        }
        try {
            AbstractAgent a = (AbstractAgent)this.getMadkitClassLoader().loadClass(agentClass).newInstance();
            if (ReturnCode.SUCCESS == this.launchAgent(a, timeOutSeconds, createFrame)) {
                return a;
            }
        }
        catch (InstantiationException e) {
            this.cannotLaunchAgent(agentClass, e, " :  no default constructor");
        }
        catch (IllegalAccessException e) {
            this.cannotLaunchAgent(agentClass, e, " : constructor not public");
        }
        catch (ClassCastException e) {
            this.cannotLaunchAgent(agentClass, e, " : Not an agent class");
        }
        catch (ClassNotFoundException e) {
            this.cannotLaunchAgent(agentClass, e, null);
        }
        catch (KernelException e) {
            this.cannotLaunchAgent(agentClass, e, null);
        }
        return null;
    }

    final void cannotLaunchAgent(String agentClass, Throwable e, String infos) {
        this.getLogger().severeLog((Object)((Object)ErrorMessages.CANT_LAUNCH) + " " + agentClass + " : " + (infos != null ? infos : ""), e);
    }

    public List<AbstractAgent> launchAgentBucket(String agentClass, int bucketSize, String ... roles) {
        List<AbstractAgent> bucket = null;
        try {
            bucket = this.getMadkitKernel().createBucket(agentClass, bucketSize);
            this.launchAgentBucket(bucket, roles);
        }
        catch (InstantiationException e) {
            this.cannotLaunchAgent(agentClass, e, null);
        }
        catch (IllegalAccessException e) {
            this.cannotLaunchAgent(agentClass, e, null);
        }
        catch (ClassNotFoundException e) {
            this.cannotLaunchAgent(agentClass, e, null);
        }
        return bucket;
    }

    public void launchAgentBucket(List<? extends AbstractAgent> bucket, String ... roles) {
        this.getKernel().launchAgentBucketWithRoles(this, bucket, roles);
    }

    public ReturnCode killAgent(AbstractAgent target) {
        return this.killAgent(target, Integer.MAX_VALUE);
    }

    public ReturnCode killAgent(AbstractAgent target, int timeOutSeconds) {
        if (target == this && Thread.currentThread().getName().equals(this.getAgentThreadName(this.getState()))) {
            if (this.isFinestLogOn()) {
                this.logger.log(Level.FINEST, (Object)((Object)Influence.KILL_AGENT) + " (" + timeOutSeconds + ")" + target.getLoggingName() + "...");
            }
            if (this.alive.compareAndSet(true, false)) {
                throw new SelfKillException("" + timeOutSeconds);
            }
        }
        return this.getKernel().killAgent(this, target, timeOutSeconds);
    }

    final MadkitKernel getKernel() {
        return this.kernel;
    }

    final void setKernel(MadkitKernel kernel) {
        this.kernel = kernel;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getClass().getSimpleName() + "-" + this._hashCode;
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this.getName().equals(name)) {
            this.name = name;
            if (this.logger != null && this.logger != AgentLogger.defaultAgentLogger) {
                this.logger = null;
                this.getLogger();
            }
        }
    }

    public void setLogLevel(Level newLevel) {
        if (Level.OFF == newLevel) {
            if (this.logger != null && this.logger != AgentLogger.defaultAgentLogger) {
                this.logger.setLevel(newLevel);
            }
            this.logger = null;
            this.setKernel(this.getMadkitKernel());
        } else {
            this.getLogger().setLevel(newLevel);
            this.setKernel(this.kernel.getLoggedKernel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentLogger getLogger() {
        if (this.logger == AgentLogger.defaultAgentLogger || this.logger == null) {
            AbstractAgent abstractAgent = this;
            synchronized (abstractAgent) {
                this.logger = AgentLogger.getLogger(this);
            }
        }
        return this.logger;
    }

    @Override
    public int compareTo(AbstractAgent other) {
        return this._hashCode - other._hashCode;
    }

    public ReturnCode createGroup(String community, String group) {
        return this.createGroup(community, group, false, null);
    }

    public ReturnCode createGroup(String community, String group, boolean isDistributed) {
        return this.createGroup(community, group, isDistributed, null);
    }

    public ReturnCode createGroup(String community, String group, boolean isDistributed, Gatekeeper keyMaster) {
        return this.getKernel().createGroup(this, community, group, keyMaster, isDistributed);
    }

    public boolean createGroupIfAbsent(String community, String group) {
        return this.createGroupIfAbsent(community, group, false, null);
    }

    public boolean createGroupIfAbsent(String community, String group, boolean isDistributed) {
        return this.createGroupIfAbsent(community, group, isDistributed, null);
    }

    public boolean createGroupIfAbsent(String community, String group, boolean isDistributed, Gatekeeper keyMaster) {
        return this.getKernel().createGroupIfAbsent(this, community, group, keyMaster, isDistributed);
    }

    public ReturnCode leaveGroup(String community, String group) {
        return this.getKernel().leaveGroup(this, community, group);
    }

    public ReturnCode requestRole(String community, String group, String role) {
        return this.requestRole(community, group, role, null);
    }

    public ReturnCode requestRole(String community, String group, String role, Object passKey) {
        return this.getKernel().requestRole(this, community, group, role, passKey);
    }

    public ReturnCode leaveRole(String community, String group, String role) {
        return this.getKernel().leaveRole(this, community, group, role);
    }

    final void handleException(Influence i, Throwable e) {
        if (this.isWarningOn()) {
            this.setAgentStackTrace(e);
            this.logger.log(Level.WARNING, i.failedString(), e);
        }
    }

    final boolean isWarningOn() {
        return this.logger != null && this.logger.getWarningLogLevel().intValue() >= this.logger.getLevel().intValue();
    }

    final void setAgentStackTrace(Throwable e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
            String agentClassName = this.getClass().getName();
            for (int i = 0; i < stackTrace.length; ++i) {
                String trace = stackTrace[i].getClassName();
                if ((trace.contains("madkit.kernel") || trace.contains("java.")) && !trace.contains(agentClassName)) continue;
                stack.add(stackTrace[i]);
            }
            e.setStackTrace(stack.toArray(new StackTraceElement[0]));
        }
    }

    public AgentAddress getAgentAddressIn(String community, String group, String role) {
        return this.kernel.getAgentAddressIn(this, community, group, role);
    }

    public AgentAddress getAgentWithRole(String community, String group, String role) {
        return this.getKernel().getAgentWithRole(this, community, group, role);
    }

    public List<AgentAddress> getAgentsWithRole(String community, String group, String role) {
        return this.getAgentsWithRole(community, group, role, false);
    }

    public List<AgentAddress> getAgentsWithRole(String community, String group, String role, boolean callerIncluded) {
        return this.getKernel().getAgentsWithRole(this, community, group, role, callerIncluded);
    }

    public Message nextMessage() {
        if (this.logger != null) {
            Message m = (Message)this.messageBox.poll();
            this.logger.finest("getting nextMessage = " + m);
            return m;
        }
        return (Message)this.messageBox.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message purgeMailbox() {
        Message m = null;
        BlockingQueue<Message> blockingQueue = this.messageBox;
        synchronized (blockingQueue) {
            try {
                while (true) {
                    m = (Message)this.messageBox.remove();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        return m;
    }

    public boolean isMessageBoxEmpty() {
        return this.messageBox.isEmpty();
    }

    public ReturnCode sendMessage(AgentAddress receiver, Message messageToSend) {
        return this.sendMessageWithRole(receiver, messageToSend, null);
    }

    public ReturnCode sendMessageWithRole(AgentAddress receiver, Message message, String senderRole) {
        return this.getKernel().sendMessage(this, receiver, message, senderRole);
    }

    public ReturnCode sendMessage(String community, String group, String role, Message message) {
        return this.sendMessageWithRole(community, group, role, message, null);
    }

    public ReturnCode sendMessageWithRole(String community, String group, String role, Message message, String senderRole) {
        return this.getKernel().sendMessage(this, community, group, role, message, senderRole);
    }

    public ReturnCode broadcastMessage(String community, String group, String role, Message message) {
        return this.broadcastMessageWithRole(community, group, role, message, null);
    }

    public ReturnCode broadcastMessageWithRole(String community, String group, String role, Message messageToSend, String senderRole) {
        return this.getKernel().broadcastMessageWithRole(this, community, group, role, messageToSend, senderRole);
    }

    public ReturnCode sendReplyWithRole(Message messageToReplyTo, Message reply, String senderRole) {
        reply.setID(messageToReplyTo.getConversationID());
        return this.getKernel().sendMessage(this, messageToReplyTo.getSender(), reply, senderRole);
    }

    public ReturnCode sendReply(Message messageToReplyTo, Message reply) {
        return this.sendReplyWithRole(messageToReplyTo, reply, null);
    }

    public Message getReplyTo(Message originalMessage) {
        long searchID = originalMessage.getConversationID();
        Iterator it = this.messageBox.iterator();
        while (it.hasNext()) {
            Message m = (Message)it.next();
            if ((long)m.getConversationID() != searchID) continue;
            it.remove();
            return m;
        }
        return null;
    }

    public void receiveMessage(Message m) {
        this.messageBox.offer(m);
    }

    public final String getMadkitProperty(String key) {
        return this.getMadkitConfig().getProperty(key);
    }

    public void setMadkitProperty(String key, String value) {
        this.getMadkitConfig().setProperty(key, value);
    }

    public void setupFrame(JFrame frame) {
        frame.add(new OutputPanel(this));
    }

    public Map<String, Map<String, Map<String, Set<AgentAddress>>>> getOrganizationSnapShot(boolean global) {
        return this.getKernel().getOrganizationSnapShot(global);
    }

    public boolean isCommunity(String community) {
        return this.getKernel().isCommunity(this, community);
    }

    public boolean isGroup(String community, String group) {
        return this.getKernel().isGroup(this, community, group);
    }

    public boolean isRole(String community, String group, String role) {
        return this.getKernel().isRole(this, community, group, role);
    }

    public String toString() {
        return this.getName() + " " + (Object)((Object)this.getState());
    }

    public Properties getMadkitConfig() {
        return this.getKernel().getMadkitConfig();
    }

    final boolean isFinestLogOn() {
        if (this.logger != null) {
            return Level.FINEST.intValue() >= this.logger.getLevel().intValue();
        }
        this.setLogLevel(Level.OFF);
        return false;
    }

    public KernelAddress getKernelAddress() {
        return this.getKernel().getKernelAddress();
    }

    final boolean logLifeException(Throwable e) {
        if (e instanceof KilledException || e instanceof IllegalMonitorStateException) {
            if (this.logger != null) {
                this.logger.warning("-*-GET KILLED in " + this.getState().lifeCycleMethod() + "-*-");
            }
        } else if (this.alive.get()) {
            this.getLogger().severeLog("-*-" + this.getState().lifeCycleMethod() + " BUG*-*", e);
        }
        return false;
    }

    final String getLoggingName() {
        if (this.name != null) {
            return "[" + this.name + "]";
        }
        return "[" + this.getClass().getSimpleName() + "-" + this._hashCode + "]";
    }

    private Message waitingNextMessage(long timeout, TimeUnit unit) {
        try {
            return this.messageBox.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException();
            return null;
        }
    }

    public void destroyCommunity(String community) {
        this.getKernel().destroyCommunity(this, community);
    }

    public void destroyGroup(String community, String group) {
        this.getKernel().destroyGroup(this, community, group);
    }

    public void destroyRole(String community, String group, String role) {
        this.getKernel().destroyRole(this, community, group, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> waitAnswers(Message message, int size, Integer timeOutMilliSeconds) {
        Message answer;
        long endTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeOutMilliSeconds.intValue());
        long conversationID = message.getConversationID();
        int missing = size;
        ArrayList<Message> receptions = new ArrayList<Message>(this.messageBox.size());
        ArrayList<Message> answers = new ArrayList<Message>(size);
        while (missing > 0 && System.nanoTime() < endTime && (answer = this.waitingNextMessage(endTime - System.nanoTime(), TimeUnit.NANOSECONDS)) != null) {
            if ((long)answer.getConversationID() == conversationID) {
                answers.add(answer);
                --missing;
                continue;
            }
            receptions.add(answer);
        }
        if (!receptions.isEmpty()) {
            BlockingQueue<Message> blockingQueue = this.messageBox;
            synchronized (blockingQueue) {
                this.messageBox.addAll(receptions);
            }
        }
        if (!answers.isEmpty()) {
            return answers;
        }
        return null;
    }

    final void handleInterruptedException() {
        if (Thread.currentThread().getName().equals(this.getAgentThreadName(this.getState())) && this.alive.compareAndSet(true, false)) {
            throw new SelfKillException("0");
        }
        Thread.currentThread().interrupt();
    }

    public State getState() {
        return this.state.get();
    }

    public void reload() {
        this.launchAgent(this.getClass().getName(), 0, true);
        this.killAgent(this);
    }

    public <E extends Enum<E>> void proceedEnumMessage(EnumMessage<E> message) {
        block9: {
            if (this.logger != null) {
                this.logger.finest("proceeding command message " + message);
            }
            Object[] parameters = (Object[])message.getContent();
            Method m = null;
            try {
                m = this.findMethodFromParameters(ActionInfo.enumToMethodName(message.getCode()), parameters);
                m.invoke((Object)this, parameters);
            }
            catch (Error e) {
                throw e;
            }
            catch (NoSuchMethodException e) {
                if (this.logger != null) {
                    this.logger.warning("I do not know how to " + ActionInfo.enumToMethodName(message.getCode()) + Arrays.deepToString(parameters));
                }
                this.logForSender("I have sent a message which has not been understood", message);
            }
            catch (IllegalArgumentException e) {
                if (this.logger != null) {
                    this.logger.warning("Cannot proceed message : wrong argument " + m);
                }
                this.logForSender("I have sent an incorrect command message ", message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (!(t instanceof SelfKillException)) break block9;
                throw (SelfKillException)t;
            }
        }
    }

    private void logForSender(String msg, EnumMessage<?> cm) {
        try {
            cm.getSender().getAgent().logger.warning(msg + cm);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private Method findMethodFromParameters(String name2, Object[] parameters) throws NoSuchMethodException {
        Class<?>[] types = this.convertToObjectTypes(this.convertToTypes(parameters));
        Method m = this.findMethodIn(name2, this.getClass().getMethods(), types);
        if (m == null && (m = this.findMethodIn(name2, this.getClass().getDeclaredMethods(), types)) != null) {
            m.setAccessible(true);
        }
        if (m == null) {
            throw new NoSuchMethodException();
        }
        return m;
    }

    private Class<?>[] convertToObjectTypes(Class<?>[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> paramCl = parameters[i];
            if (paramCl == null || !paramCl.isPrimitive()) continue;
            parameters[i] = primitiveTypes.get(paramCl);
        }
        return parameters;
    }

    private Class<?>[] convertToTypes(Object[] parameters) {
        Class[] paramClasses = new Class[parameters.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            if (parameters[i] == null) continue;
            paramClasses[i] = parameters[i].getClass();
        }
        return paramClasses;
    }

    private Method findMethodIn(String name2, Method[] methods, Class<?>[] parameters) {
        for (Method method : methods) {
            if (!method.getName().equals(name2) || !this.checkArgumentTypes(this.convertToObjectTypes(method.getParameterTypes()), parameters)) continue;
            return method;
        }
        return null;
    }

    private boolean checkArgumentTypes(Class<?>[] types, Class<?>[] parameters) {
        if (parameters.length == types.length) {
            for (int i = 0; i < types.length; ++i) {
                if (parameters[i] == null || types[i].isAssignableFrom(parameters[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public MadkitClassLoader getMadkitClassLoader() {
        return this.getMadkitKernel().getMadkitClassLoader();
    }

    public boolean isKernelOnline() {
        return this.getMadkitKernel().isRole(this, "Cloud", "net", "net agent");
    }

    AgentExecutor getAgentExecutor() {
        return null;
    }

    public static void executeThisAgent(int nbOfInstances, boolean createFrame, String ... args) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(Madkit.Option.launchAgents.toString(), trace[trace.length - 1].getClassName() + "," + (createFrame ? "true" : "false") + "," + nbOfInstances));
        if (args != null) {
            arguments.addAll(Arrays.asList(args));
        }
        new Madkit(arguments.toArray(new String[0]));
    }

    protected static void executeThisAgent(String ... args) {
        AbstractAgent.executeThisAgent(1, true, args);
    }

    protected static void executeThisAgent() {
        AbstractAgent.executeThisAgent(1, true, new String[0]);
    }

    static {
        primitiveTypes.put(Integer.TYPE, Integer.class);
        primitiveTypes.put(Boolean.TYPE, Boolean.class);
        primitiveTypes.put(Byte.TYPE, Byte.class);
        primitiveTypes.put(Character.TYPE, Character.class);
        primitiveTypes.put(Float.TYPE, Float.class);
        primitiveTypes.put(Void.TYPE, Void.class);
        primitiveTypes.put(Short.TYPE, Short.class);
        primitiveTypes.put(Double.TYPE, Double.class);
        primitiveTypes.put(Long.TYPE, Long.class);
    }

    static enum Influence {
        CREATE_GROUP,
        REQUEST_ROLE,
        LEAVE_ROLE,
        LEAVE_GROUP,
        GET_AGENTS_WITH_ROLE,
        GET_AGENT_WITH_ROLE,
        SEND_MESSAGE,
        BROADCAST_MESSAGE,
        BROADCAST_MESSAGE_AND_WAIT,
        LAUNCH_AGENT,
        KILL_AGENT,
        GET_AGENT_ADDRESS_IN,
        RELOAD_CLASS;


        public String failedString() {
            return this.toString() + (Object)((Object)Words.FAILED) + " : ";
        }

        public String toString() {
            return this.name() + " ";
        }

        String successString() {
            return this.toString() + (Object)((Object)ReturnCode.SUCCESS) + " : ";
        }
    }

    public static enum ReturnCode {
        SUCCESS,
        NOT_COMMUNITY,
        NOT_GROUP,
        NOT_ROLE,
        NOT_IN_GROUP,
        ROLE_ALREADY_HANDLED,
        ACCESS_DENIED,
        ROLE_NOT_HANDLED,
        ALREADY_GROUP,
        ALREADY_LAUNCHED,
        TIMEOUT,
        AGENT_CRASH,
        NOT_YET_LAUNCHED,
        ALREADY_KILLED,
        INVALID_AGENT_ADDRESS,
        NO_RECIPIENT_FOUND,
        IGNORED,
        SEVERE;

        static final ResourceBundle messages;

        public String toString() {
            return messages.getString(this.name());
        }

        static {
            messages = I18nUtilities.getResourceBundle(ReturnCode.class.getSimpleName());
        }
    }

    public static enum State {
        NOT_LAUNCHED,
        INITIALIZING,
        ACTIVATED,
        LIVING,
        ENDING,
        TERMINATED;


        final String lifeCycleMethod() {
            switch (this) {
                case ACTIVATED: {
                    return "ACTIVATE";
                }
                case LIVING: {
                    return "LIVE";
                }
                case TERMINATED: {
                    return "TERMINATE";
                }
                case ENDING: {
                    return "END";
                }
            }
            return this.name();
        }
    }
}

