/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.action.KernelAction;
import madkit.gui.MASModel;
import madkit.gui.SwingUtil;
import madkit.i18n.Words;
import madkit.kernel.AbstractAgent;

public class LaunchMAS
extends JMenu {
    private static final long serialVersionUID = 6721458300016754609L;
    private static final Set<LaunchMAS> menus = new HashSet<LaunchMAS>();
    private final AbstractAgent myAgent;

    public LaunchMAS(AbstractAgent agent) {
        super(Words.MAS.toString());
        this.setMnemonic(83);
        this.myAgent = agent;
        menus.add(this);
        this.update();
    }

    public static void updateAllMenus() {
        for (LaunchMAS menu : menus) {
            menu.update();
        }
    }

    private void addTomenu(Action a, JMenu subMenu, MASModel demo) {
        JMenuItem name = new JMenuItem(a);
        String displayedName = demo.getName();
        name.setText(displayedName);
        name.setIcon(new ImageIcon(SwingUtil.MADKIT_LOGO.getImage().getScaledInstance(16, 16, 4)));
        name.setToolTipText(demo.toString());
        name.setAccelerator(null);
        name.setActionCommand(displayedName);
        subMenu.add(name);
    }

    private void update() {
        this.removeAll();
        for (MASModel dm : this.myAgent.getMadkitClassLoader().getAvailableConfigurations()) {
            this.addTomenu(KernelAction.LAUNCH_MAS.getActionFor(this.myAgent, dm), this, dm);
        }
        if (this.getItemCount() == 0) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }
}

