/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.action.AgentAction;
import madkit.action.MDKAbstractAction;
import madkit.kernel.AbstractAgent;
import madkit.kernel.MadkitClassLoader;

public class LaunchAgentsMenu
extends JMenu {
    private static final long serialVersionUID = 634377755586801986L;
    private static final Set<LaunchAgentsMenu> menus = new HashSet<LaunchAgentsMenu>();
    private final Action myAction;
    private final AbstractAgent myAgent;
    private final boolean withKernelAgents;

    public LaunchAgentsMenu(final AbstractAgent agent, boolean withKernelAgents) {
        super("Agents");
        this.withKernelAgents = withKernelAgents;
        this.setMnemonic(71);
        this.myAgent = agent;
        this.myAction = new MDKAbstractAction(AgentAction.LAUNCH_AGENT.getActionInfo()){
            private static final long serialVersionUID = 6530886642947530268L;

            @Override
            public void actionPerformed(ActionEvent e) {
                agent.launchAgent(e.getActionCommand(), 0, true);
            }
        };
        menus.add(this);
        this.update();
    }

    public LaunchAgentsMenu(AbstractAgent agent) {
        this(agent, false);
    }

    public static void updateAllMenus() {
        for (LaunchAgentsMenu menu : menus) {
            menu.update();
        }
    }

    private void addTomenu(Action a, JMenu subMenu, String className, boolean simpleName) {
        JMenuItem name = new JMenuItem(a);
        name.setText(simpleName ? MadkitClassLoader.getClassSimpleName(className) : className);
        name.setAccelerator(null);
        name.setActionCommand(className);
        subMenu.add(name);
    }

    private void update() {
        this.removeAll();
        Set<String> classesToLaunch = this.myAgent.getMadkitClassLoader().getAllAgentClasses();
        if (!this.withKernelAgents) {
            Iterator<String> iterator = classesToLaunch.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().contains("madkit.kernel")) continue;
                iterator.remove();
            }
        }
        if (classesToLaunch.size() < 20) {
            for (String string : classesToLaunch) {
                this.addTomenu(this.myAction, this, string, false);
            }
        } else {
            String pckName = null;
            JMenu subMenu = null;
            for (String string : classesToLaunch) {
                String pck = MadkitClassLoader.getClassPackageName(string);
                if (pck == null) continue;
                if (pck.equals(pckName)) {
                    this.addTomenu(this.myAction, subMenu, string, true);
                    continue;
                }
                pckName = pck;
                subMenu = new JMenu(pck);
                this.add(subMenu);
                this.addTomenu(this.myAction, subMenu, string, true);
            }
        }
    }
}

