/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.action.KernelAction;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AboutFrame;
import madkit.i18n.Words;
import madkit.kernel.Madkit;

public final class HelpMenu
extends JMenu {
    private static final String MDKWeb = "http://www.madkit.net/";
    private static final long serialVersionUID = 6177193453649323680L;
    private static final ActionListener about = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            new AboutFrame();
        }
    };
    private static final ActionListener tuto = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Desktop.getDesktop().browse(new URI(HelpMenu.MDKWeb + e.getActionCommand()));
            }
            catch (IOException e1) {
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
    };

    public HelpMenu() {
        super(Words.HELP.toString());
        JMenuItem mi;
        this.setMnemonic(69);
        if (Desktop.isDesktopSupported()) {
            ImageIcon ii = KernelAction.CONNECT_WEB_REPO.getActionInfo().getSmallIcon();
            mi = new JMenuItem("API", ii);
            mi.addActionListener(tuto);
            mi.setActionCommand("api/MaDKit-" + Madkit.VERSION);
            this.add(mi);
            mi = new JMenuItem(Words.TUTORIALS.toString(), ii);
            mi.addActionListener(tuto);
            mi.setActionCommand("tutorials");
            this.add(mi);
            mi = new JMenuItem("Forum", ii);
            mi.addActionListener(tuto);
            mi.setActionCommand("forum");
            this.add(mi);
        }
        mi = new JMenuItem(Words.ABOUT.toString(), new ImageIcon(SwingUtil.class.getResource("images/help.png")));
        mi.setMnemonic(65);
        mi.addActionListener(about);
        this.add(mi);
    }
}

