/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui.menu;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import madkit.gui.SwingUtil;
import madkit.gui.menu.SwingLink;
import madkit.kernel.Madkit;

final class AboutFrame
extends JDialog {
    private static final long serialVersionUID = -6291196559273649285L;

    public AboutFrame() {
        this.setTitle("MaDKit");
        this.setLocationRelativeTo(null);
        JLabel icon = new JLabel(SwingUtil.MADKIT_LOGO);
        icon.setBounds(10, 10, 10, 10);
        this.add((Component)icon, "West");
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        JTextPane textPanel = new JTextPane();
        textPanel.setEditable(false);
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(Box.createRigidArea(new Dimension(0, 110)));
        JLabel name = new JLabel("Visit");
        name.setAlignmentX(0.5f);
        textPanel.add(name);
        StyledDocument doc = textPanel.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setFontSize(s, 20);
        try {
            doc.insertString(doc.getLength(), "MaDKit\n", doc.getStyle("large"));
            doc.insertString(doc.getLength(), "The Multiagent Development Kit\n\n", doc.getStyle("italic"));
            doc.insertString(doc.getLength(), "Version: " + Madkit.VERSION + "\nBuild id: " + Madkit.BUILD_ID, doc.getStyle("small"));
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        try {
            textPanel.add(new SwingLink("www.madkit.org", new URI("http://www.madkit.org")));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        this.add(textPanel);
        JButton close = new JButton("OK");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutFrame.this.dispose();
            }
        });
        this.add((Component)close, "South");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.setSize(400, 200);
        this.setVisible(true);
        close.requestFocus();
    }
}

