/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;

public final class SwingUtil {
    public static final ImageIcon MADKIT_LOGO = new ImageIcon(SwingUtil.class.getResource("images/madkit_logo.png"));

    public static JPanel createSliderPanel(JSlider slider, String label) {
        return SwingUtil.createSliderPanel(slider, label, 170);
    }

    public static JPanel createSliderPanel(JSlider slider, String label, int width) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new TitledBorder(label));
        p.setPreferredSize(new Dimension(width, 60));
        p.add(slider);
        return p;
    }

    public static JPanel createSliderPanel(BoundedRangeModel model, String label) {
        return SwingUtil.createSliderPanel(SwingUtil.createJSlider(model), label);
    }

    public static JSlider createJSlider(final BoundedRangeModel model) {
        final JSlider slider = new JSlider(model);
        slider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                slider.setValue(-e.getWheelRotation() * model.getExtent() + model.getValue());
            }
        });
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setMajorTickSpacing(model.getMaximum() / 2);
        slider.setMinorTickSpacing(model.getExtent());
        slider.setSnapToTicks(true);
        return slider;
    }
}

