/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import madkit.action.ActionInfo;
import madkit.action.GUIManagerAction;
import madkit.gui.AgentFrame;
import madkit.gui.SwingUtil;
import madkit.gui.menu.HelpMenu;
import madkit.gui.menu.LaunchAgentsMenu;
import madkit.gui.menu.LaunchMAS;
import madkit.gui.menu.MadkitMenu;
import madkit.gui.toolbar.MadkitToolBar;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Madkit;
import madkit.kernel.Message;
import madkit.message.GUIMessage;
import madkit.message.KernelMessage;

class GUIManagerAgent
extends Agent {
    private static final long serialVersionUID = 8026421822077510523L;
    private final ConcurrentMap<AbstractAgent, JFrame> guis = new ConcurrentHashMap<AbstractAgent, JFrame>();
    private boolean shuttedDown = false;
    private JDesktopPane desktopPane;
    private JFrame myFrame;

    GUIManagerAgent(boolean asDaemon) {
        super(asDaemon);
    }

    @Override
    protected void activate() {
        if (!this.isDaemon()) {
            try {
                this.buildUI();
                if (ActionInfo.javawsIsOn) {
                    this.setMadkitProperty(Madkit.BooleanOption.autoConnectMadkitWebsite.name(), "true");
                }
            }
            catch (HeadlessException e) {
                this.headlessLog(e);
                return;
            }
        }
        this.createGroup("local", "gui");
    }

    private void headlessLog(HeadlessException e) {
        this.getLogger().severe("\t" + e.getMessage() + "\n\tNo graphic environment, quitting");
        this.shuttedDown = true;
    }

    @Override
    protected void live() {
        while (!this.shuttedDown) {
            Message m = this.waitNextMessage();
            if (m instanceof GUIMessage) {
                this.proceedCommandMessage((GUIMessage)m);
                continue;
            }
            if (m instanceof KernelMessage) {
                this.proceedEnumMessage((KernelMessage)m);
                continue;
            }
            if (this.logger == null) continue;
            this.logger.warning("I received a message that I do not understand. Discarding " + m);
        }
    }

    private void proceedCommandMessage(GUIMessage cm) {
        if (this.isAlive()) {
            if (cm.getCode() == GUIManagerAction.SETUP_AGENT_GUI) {
                try {
                    this.setupAgentGui((AbstractAgent)((Object[])cm.getContent())[0]);
                    this.sendReply(cm, cm);
                }
                catch (HeadlessException e) {
                    this.headlessLog(e);
                }
            } else {
                super.proceedEnumMessage(cm);
            }
        }
    }

    @Override
    protected void end() {
        if (this.logger != null) {
            this.logger.finer("Ending: Disposing frames");
        }
        this.killAgents();
        if (this.desktopPane != null) {
            this.myFrame.dispose();
        }
    }

    private void exit() {
        this.shuttedDown = true;
    }

    private void setupAgentGui(final AbstractAgent agent) {
        if (!this.shuttedDown && agent.isAlive()) {
            if (this.logger != null) {
                this.logger.fine("Setting up GUI for " + agent);
            }
            AgentFrame f = new AgentFrame(agent, agent.getName());
            try {
                agent.setupFrame(f);
            }
            catch (Exception e) {
                agent.getLogger().severeLog("Frame setup problem -> default GUI settings", e);
                f = new AgentFrame(agent, agent.getName());
            }
            this.guis.put(agent, f);
            final AgentFrame af = f;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (GUIManagerAgent.this.desktopPane != null) {
                        final JInternalFrame jf = GUIManagerAgent.this.buildInternalFrame(af);
                        GUIManagerAgent.this.desktopPane.add(jf);
                        jf.setDefaultCloseOperation(0);
                        jf.addInternalFrameListener(new InternalFrameAdapter(){

                            @Override
                            public void internalFrameClosing(InternalFrameEvent e) {
                                if (agent.isAlive()) {
                                    jf.setTitle("Closing " + agent.getName());
                                    AgentFrame.killAgent(agent, 2);
                                } else {
                                    jf.dispose();
                                }
                            }
                        });
                        jf.setLocation(GUIManagerAgent.this.checkLocation(jf));
                        jf.setVisible(true);
                    } else {
                        af.setLocation(GUIManagerAgent.this.checkLocation(af));
                        af.setVisible(true);
                    }
                }
            });
        }
    }

    private JInternalFrame buildInternalFrame(AgentFrame af) {
        JInternalFrame ijf = new JInternalFrame(af.getTitle(), true, true, true, true);
        ijf.setFrameIcon(new ImageIcon(af.getIconImage().getScaledInstance(14, 14, 4)));
        ijf.setSize(af.getSize());
        ijf.setLocation(af.getLocation());
        ijf.setContentPane(af.getContentPane());
        ijf.setJMenuBar(af.getJMenuBar());
        af.setInternalFrame(ijf);
        return ijf;
    }

    private void iconifyAll(boolean iconify) {
        int code = iconify ? 1 : 0;
        for (JFrame f : this.guis.values()) {
            f.setExtendedState(code);
        }
        for (JInternalFrame ijf : this.desktopPane.getAllFrames()) {
            try {
                ijf.setIcon(iconify);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
    }

    private void iconifyAll() {
        this.iconifyAll(true);
    }

    private void deiconifyAll() {
        this.iconifyAll(false);
    }

    private void disposeAgentGui(AbstractAgent agent) {
        JFrame f = (JFrame)this.guis.remove(agent);
        if (f != null) {
            f.dispose();
        }
        if (this.isDaemon() && this.guis.isEmpty() && ActionInfo.javawsIsOn) {
            System.exit(0);
        }
    }

    private Point checkLocation(Container c) {
        List<JInternalFrame> l;
        Dimension dim;
        if (c instanceof JInternalFrame) {
            dim = this.desktopPane.getSize();
            l = Arrays.asList(this.desktopPane.getAllFrames());
        } else {
            dim = Toolkit.getDefaultToolkit().getScreenSize();
            l = new ArrayList(this.guis.values());
        }
        Dimension size = c.getSize();
        if (size.width > dim.width) {
            size.width = dim.width;
        }
        if (size.height > dim.height) {
            size.height = dim.height;
        }
        c.setSize(size);
        dim.width -= 20;
        boolean notGood = true;
        Point location = c.getLocation();
        location.x = location.x > 0 ? location.x : 1;
        location.y = location.y > 0 ? location.y : 1;
        location.x = location.x <= dim.width ? location.x : location.x % dim.width;
        int n = location.y = location.y <= dim.height ? location.y : location.y % dim.height;
        while (notGood) {
            notGood = false;
            for (Container container : l) {
                if (container == c || !location.equals(container.getLocation())) continue;
                notGood = true;
                location.x += 20;
                location.x %= dim.width;
                location.y += 20;
                location.y %= dim.height;
            }
        }
        return location;
    }

    private void killAgents() {
        for (JFrame f : this.guis.values()) {
            f.dispose();
        }
        this.guis.clear();
    }

    private void buildUI() {
        this.myFrame = new JFrame("MaDKit " + this.getMadkitProperty("madkit.version") + " Desktop running on kernel " + this.getKernelAddress());
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(Color.BLACK);
        this.myFrame.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new MadkitMenu(this));
        menuBar.add(new LaunchAgentsMenu(this, true));
        menuBar.add(new LaunchMAS(this));
        menuBar.add(new HelpMenu());
        MadkitToolBar tb = new MadkitToolBar(this);
        this.myFrame.setJMenuBar(menuBar);
        tb.setRollover(true);
        tb.setFloatable(false);
        this.myFrame.add((Component)tb, "First");
        this.myFrame.setPreferredSize(new Dimension(800, 600));
        this.myFrame.setSize(new Dimension(800, 600));
        this.myFrame.setDefaultCloseOperation(3);
        this.myFrame.add(this.desktopPane);
        this.myFrame.pack();
        this.myFrame.setVisible(true);
        this.myFrame.setExtendedState(6);
        this.myFrame.setResizable(true);
    }
}

