/*
 * Decompiled with CFR 0.152.
 */
package madkit.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import madkit.action.KernelAction;
import madkit.gui.AgentStatusPanel;
import madkit.gui.SwingUtil;
import madkit.gui.menu.AgentLogLevelMenu;
import madkit.gui.menu.AgentMenu;
import madkit.gui.menu.HelpMenu;
import madkit.gui.menu.MadkitMenu;
import madkit.kernel.AbstractAgent;
import madkit.message.KernelMessage;

final class AgentFrame
extends JFrame {
    private static final long serialVersionUID = 6337250099157352055L;
    private JInternalFrame internalFrame;

    AgentFrame(final AbstractAgent agent, String name) {
        super(name);
        this.setIconImage(SwingUtil.MADKIT_LOGO.getImage());
        this.setJMenuBar(this.createMenuBarFor(agent));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                this.closeProcess();
            }

            private void closeProcess() {
                if (agent.isAlive()) {
                    AgentFrame.this.setTitle("Closing " + agent.getName());
                    AgentFrame.killAgent(agent, 2);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.closeProcess();
            }
        });
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void dispose() {
        if (this.internalFrame != null) {
            this.internalFrame.dispose();
        }
        super.dispose();
    }

    private JMenuBar createMenuBarFor(AbstractAgent agent) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new MadkitMenu(agent));
        menuBar.add(new AgentMenu(agent));
        menuBar.add(new AgentLogLevelMenu(agent));
        menuBar.add(new HelpMenu());
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(new AgentStatusPanel(agent));
        return menuBar;
    }

    void setInternalFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.internalFrame != null) {
            this.internalFrame.setLocation(x, y);
        }
    }

    static void killAgent(AbstractAgent agent, int timeOutSeconds) {
        if (agent.isAlive()) {
            agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.KILL_AGENT, agent, timeOutSeconds));
        }
    }
}

