/*
 * Decompiled with CFR 0.152.
 */
package madkit.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import madkit.action.ActionInfo;
import madkit.action.MDKAbstractAction;
import madkit.i18n.I18nUtilities;
import madkit.kernel.AbstractAgent;
import madkit.message.KernelMessage;

public enum KernelAction {
    EXIT(81),
    COPY(67),
    RESTART(82),
    LAUNCH_NETWORK(87),
    STOP_NETWORK(84),
    JCONSOLE(78),
    CONSOLE(79),
    LOAD_LOCAL_DEMOS(68),
    LAUNCH_AGENT(515),
    LAUNCH_MAS(515),
    KILL_AGENT(515),
    CONNECT_WEB_REPO(515),
    LOAD_JAR_FILE(515);

    private ActionInfo actionInfo;
    private final int keyEvent;
    private static final ResourceBundle messages;

    private KernelAction(int keyEvent) {
        this.keyEvent = keyEvent;
    }

    public Action getActionFor(final AbstractAgent agent, final Object ... parameters) {
        return new MDKAbstractAction(this.getActionInfo()){
            private static final long serialVersionUID = -8907472475007112860L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (agent.isAlive()) {
                    agent.sendMessage("local", "system", "manager", new KernelMessage(KernelAction.this, parameters));
                }
            }
        };
    }

    public ActionInfo getActionInfo() {
        if (this.actionInfo == null) {
            this.actionInfo = new ActionInfo(this, this.keyEvent, messages);
        }
        return this.actionInfo;
    }

    public static void addAllActionsTo(JComponent menuOrToolBar, AbstractAgent agent) {
        try {
            Method add = menuOrToolBar.getClass().getMethod("add", Action.class);
            Method addSeparator = menuOrToolBar.getClass().getMethod("addSeparator", new Class[0]);
            for (KernelAction ka : EnumSet.allOf(KernelAction.class)) {
                if (ka == LAUNCH_AGENT) {
                    return;
                }
                if ((ka == LOAD_LOCAL_DEMOS || ka == RESTART) && ActionInfo.javawsIsOn || ka == JCONSOLE && (KernelAction.findJconsole() == null || ActionInfo.javawsIsOn)) continue;
                add.invoke((Object)menuOrToolBar, ka.getActionFor(agent, new Object[0]));
                switch (ka) {
                    case EXIT: 
                    case RESTART: 
                    case STOP_NETWORK: 
                    case CONSOLE: {
                        addSeparator.invoke((Object)menuOrToolBar, new Object[0]);
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static String findJconsole() {
        File javaHome = new File(System.getProperty("java.home"));
        File jconsole = new File(javaHome.getParent(), "bin" + File.separatorChar + "jconsole");
        if (jconsole.exists()) {
            return jconsole.getAbsolutePath();
        }
        jconsole = javaHome.getParentFile().getParentFile();
        for (File dir : jconsole.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith("jdk");
            }
        })) {
            jconsole = new File(dir, "bin" + File.separatorChar + "jconsole");
            if (!jconsole.exists()) continue;
            return jconsole.getAbsolutePath();
        }
        return null;
    }

    static {
        messages = I18nUtilities.getResourceBundle(KernelAction.class.getSimpleName());
    }
}

